/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.SignatureAnalyzer;
import jd.core.process.analyzer.classfile.visitor.ReferenceVisitor;
import org.apache.bcel.classfile.AnnotationElementValue;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Signature;

public final class ReferenceAnalyzer {
    private ReferenceAnalyzer() {
    }

    public static void analyze(ReferenceMap referenceMap, ClassFile classFile) {
        ReferenceAnalyzer.collectReferences(referenceMap, classFile);
    }

    private static void collectReferences(ReferenceMap referenceMap, ClassFile classFile) {
        referenceMap.add(classFile.getThisClassName());
        Signature as = classFile.getAttributeSignature();
        if (as == null) {
            if (classFile.getSuperClassIndex() != 0 && !classFile.getClassName().equals(ReferenceAnalyzer.getSimpleName(classFile.getSuperClassName()))) {
                referenceMap.add(classFile.getSuperClassName());
            }
            int[] interfaces = classFile.getInterfaces();
            int i = interfaces.length - 1;
            while (i >= 0) {
                String internalInterfaceName = classFile.getConstantPool().getConstantClassName(interfaces[i]);
                if (!classFile.getClassName().equals(ReferenceAnalyzer.getSimpleName(internalInterfaceName))) {
                    referenceMap.add(internalInterfaceName);
                }
                --i;
            }
        } else {
            String signature = classFile.getConstantPool().getConstantUtf8(as.getSignatureIndex());
            SignatureAnalyzer.analyzeClassSignature(referenceMap, signature);
        }
        ReferenceAnalyzer.countReferencesInAttributes(referenceMap, classFile.getConstantPool(), classFile.getAttributes());
        List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles != null) {
            for (ClassFile innerClassFile : innerClassFiles) {
                ReferenceAnalyzer.collectReferences(referenceMap, innerClassFile);
            }
        }
        ReferenceVisitor visitor = new ReferenceVisitor(classFile.getConstantPool(), referenceMap);
        ReferenceAnalyzer.countReferencesInFields(referenceMap, visitor, classFile);
        ReferenceAnalyzer.countReferencesInMethods(referenceMap, visitor, classFile);
    }

    private static String getSimpleName(String internalName) {
        return internalName.substring(internalName.lastIndexOf(47) + 1);
    }

    private static void countReferencesInAttributes(ReferenceMap referenceMap, ConstantPool constants, Attribute[] attributes) {
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 13 || attribute.getTag() == 12) {
                AnnotationEntry[] annotations;
                AnnotationEntry[] annotationEntryArray = annotations = ((Annotations)attribute).getAnnotationEntries();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    AnnotationEntry annotationEntry = annotationEntryArray[n4];
                    ReferenceAnalyzer.countAnnotationReference(referenceMap, constants, annotationEntry);
                    ++n4;
                }
            } else if (attribute.getTag() == 15 || attribute.getTag() == 14) {
                ParameterAnnotationEntry[] parameterAnnotations = ((ParameterAnnotations)attribute).getParameterAnnotationEntries();
                ReferenceAnalyzer.countParameterAnnotationsReference(referenceMap, constants, parameterAnnotations);
            }
            ++n2;
        }
    }

    private static void countAnnotationReference(ReferenceMap referenceMap, ConstantPool constants, AnnotationEntry annotations) {
        String typeName = constants.getConstantUtf8(annotations.getTypeIndex());
        SignatureAnalyzer.analyzeSimpleSignature(referenceMap, typeName);
        ElementValuePair[] elementValuePairs = annotations.getElementValuePairs();
        int j = elementValuePairs.length - 1;
        while (j >= 0) {
            ReferenceAnalyzer.countElementValue(referenceMap, constants, elementValuePairs[j].getValue());
            --j;
        }
    }

    private static void countParameterAnnotationsReference(ReferenceMap referenceMap, ConstantPool constants, ParameterAnnotationEntry[] parameterAnnotations) {
        ParameterAnnotationEntry[] parameterAnnotationEntryArray = parameterAnnotations;
        int n = parameterAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterAnnotationEntry parameterAnnotationEntry = parameterAnnotationEntryArray[n2];
            AnnotationEntry[] annotationEntryArray = parameterAnnotationEntry.getAnnotationEntries();
            int n3 = annotationEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AnnotationEntry annotationEntry = annotationEntryArray[n4];
                ReferenceAnalyzer.countAnnotationReference(referenceMap, constants, annotationEntry);
                ++n4;
            }
            ++n2;
        }
    }

    private static void countElementValue(ReferenceMap referenceMap, ConstantPool constants, ElementValue ev) {
        if (ev instanceof ClassElementValue var3_4) {
            signature = evci.getClassString();
            SignatureAnalyzer.analyzeSimpleSignature(referenceMap, (String)signature);
        }
        if ((var8_6 = ev) instanceof AnnotationElementValue && (signature = (AnnotationElementValue)var8_6) == (AnnotationElementValue)var8_6) {
            ReferenceAnalyzer.countAnnotationReference(referenceMap, constants, evanv.getAnnotationEntry());
        }
        if (ev instanceof ArrayElementValue var9_8 && (values = evarv.getElementValuesArray()) != null) {
            ElementValue[] elementValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                ElementValue value = elementValueArray[n2];
                if (value instanceof ClassElementValue var17_16) {
                    String signature = evci.getClassString();
                    SignatureAnalyzer.analyzeSimpleSignature(referenceMap, signature);
                }
                ++n2;
            }
        }
        if ((var14_14 = ev) instanceof EnumElementValue && (values = (ElementValue[])var14_14) == (EnumElementValue)var14_14) {
            String signature = evecv.getEnumTypeString();
            SignatureAnalyzer.analyzeSimpleSignature(referenceMap, signature);
        }
    }

    private static void countReferencesInFields(ReferenceMap referenceMap, ReferenceVisitor visitor, ClassFile classFile) {
        Field[] fieldArray = classFile.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getAccessFlags() & 0x1000) == 0) {
                ReferenceAnalyzer.countReferencesInAttributes(referenceMap, classFile.getConstantPool(), field.getAttributes());
                String signature = classFile.getConstantPool().getConstantUtf8(field.getSignatureIndex());
                SignatureAnalyzer.analyzeSimpleSignature(referenceMap, signature);
                if (field.getValueAndMethod() != null) {
                    visitor.visit(field.getValueAndMethod().value());
                }
            }
            ++n2;
        }
    }

    private static void countReferencesInMethods(ReferenceMap referenceMap, ReferenceVisitor visitor, ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        ConstantPool constants = classFile.getConstantPool();
        int i = methods.length - 1;
        while (i >= 0) {
            Method method = methods[i];
            if ((method.getAccessFlags() & 0x1040) == 0 && !method.containsError()) {
                CodeException[] codeExceptions;
                LocalVariables localVariables;
                ElementValue defaultAnnotationValue;
                ReferenceAnalyzer.countReferencesInAttributes(referenceMap, classFile.getConstantPool(), method.getAttributes());
                String signature = constants.getConstantUtf8(method.getSignatureIndex());
                SignatureAnalyzer.analyzeMethodSignature(referenceMap, signature);
                int[] exceptionIndexes = method.getExceptionIndexes();
                if (exceptionIndexes != null) {
                    int j = exceptionIndexes.length - 1;
                    while (j >= 0) {
                        referenceMap.add(constants.getConstantClassName(exceptionIndexes[j]));
                        --j;
                    }
                }
                if ((defaultAnnotationValue = method.getDefaultAnnotationValue()) != null) {
                    ReferenceAnalyzer.countElementValue(referenceMap, constants, defaultAnnotationValue);
                }
                if ((localVariables = method.getLocalVariables()) != null) {
                    ReferenceAnalyzer.countReferencesInLocalVariables(referenceMap, constants, localVariables);
                }
                if ((codeExceptions = method.getCodeExceptions()) != null) {
                    ReferenceAnalyzer.countReferencesInCodeExceptions(referenceMap, constants, codeExceptions);
                }
                ReferenceAnalyzer.countReferencesInCode(visitor, method);
            }
            --i;
        }
    }

    private static void countReferencesInLocalVariables(ReferenceMap referenceMap, ConstantPool constants, LocalVariables localVariables) {
        int i = localVariables.size() - 1;
        while (i >= 0) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.getSignatureIndex() > 0) {
                String signature = lv.getSignature(constants);
                SignatureAnalyzer.analyzeSimpleSignature(referenceMap, signature);
            }
            --i;
        }
    }

    private static void countReferencesInCodeExceptions(ReferenceMap referenceMap, ConstantPool constants, CodeException[] codeExceptions) {
        CodeException[] codeExceptionArray = codeExceptions;
        int n = codeExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            CodeException ce = codeExceptionArray[n2];
            if (ce.getCatchType() != 0) {
                String internalClassName = constants.getConstantClassName(ce.getCatchType());
                referenceMap.add(internalClassName);
            }
            ++n2;
        }
    }

    private static void countReferencesInCode(ReferenceVisitor visitor, Method method) {
        visitor.visit(method.getFastNodes());
    }
}

