/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.List;
import java.util.Optional;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.AConstNull;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByTypeVisitor;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.process.analyzer.variable.VariableNameGenerator;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Signature;
import org.apache.commons.lang3.ArrayUtils;

public final class LocalVariableAnalyzer {
    private static final int UNDEFINED_TYPE = -1;
    private static final int NUMBER_TYPE = -2;
    private static final int OBJECT_TYPE = -3;

    private LocalVariableAnalyzer() {
    }

    public static void analyze(ClassFile classFile, Method method, VariableNameGenerator variableNameGenerator, List<Instruction> list, List<Instruction> listForAnalyze) {
        ConstantPool constants = classFile.getConstantPool();
        variableNameGenerator.clearLocalNames();
        byte[] code = method.getCode();
        int codeLength = ArrayUtils.getLength((Object)code);
        LocalVariables localVariables = method.getLocalVariables();
        if (localVariables == null) {
            int nameIndex;
            localVariables = new LocalVariables();
            method.setLocalVariables(localVariables);
            if ((method.getAccessFlags() & 8) == 0) {
                nameIndex = constants.addConstantUtf8("this");
                int signatureIndex = constants.addConstantUtf8(classFile.getInternalClassName());
                LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, 0);
                localVariables.add(lv);
            }
            if (method.getNameIndex() == constants.getInstanceConstructorIndex() && classFile.isAInnerClass() && (classFile.getAccessFlags() & 8) == 0) {
                nameIndex = constants.addConstantUtf8("this$1");
                String internalClassName = classFile.getInternalClassName();
                int lastInnerClassSeparatorIndex = internalClassName.lastIndexOf(36);
                String internalOuterClassName = String.valueOf(internalClassName.substring(0, lastInnerClassSeparatorIndex)) + ';';
                int signatureIndex = constants.addConstantUtf8(internalOuterClassName);
                LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, 1);
                localVariables.add(lv);
            }
            LocalVariableAnalyzer.analyzeMethodParameter(classFile, constants, method, localVariables, variableNameGenerator, codeLength);
            localVariables.setIndexOfFirstLocalVariable(localVariables.size());
            if (code != null) {
                LocalVariableAnalyzer.generateMissingMonitorLocalVariables(constants, localVariables, listForAnalyze);
            }
        } else {
            String methodSignature = constants.getConstantUtf8(method.getSignatureIndex());
            int indexOfFirstLocalVariable = ((method.getAccessFlags() & 8) == 0 ? 1 : 0) + SignatureUtil.getParameterSignatureCount(methodSignature);
            if (indexOfFirstLocalVariable > localVariables.size()) {
                LocalVariableAnalyzer.analyzeMethodParameter(classFile, constants, method, localVariables, variableNameGenerator, codeLength);
            }
            localVariables.setIndexOfFirstLocalVariable(indexOfFirstLocalVariable);
            if (code != null) {
                LocalVariableAnalyzer.generateMissingMonitorLocalVariables(constants, localVariables, listForAnalyze);
                LocalVariableAnalyzer.checkLocalVariableRanges(constants, code, localVariables, variableNameGenerator, listForAnalyze);
            }
        }
        if (code != null) {
            String returnedSignature = LocalVariableAnalyzer.getReturnedSignature(classFile, method);
            LocalVariableAnalyzer.analyzeMethodCode(classFile, localVariables, listForAnalyze, returnedSignature);
            LocalVariableAnalyzer.setConstantTypes(classFile, localVariables, list, listForAnalyze, returnedSignature);
            LocalVariableAnalyzer.initialyzeExceptionLoad(listForAnalyze, localVariables);
        }
        LocalVariableAnalyzer.generateLocalVariableNames(constants, localVariables, variableNameGenerator);
    }

    private static void analyzeMethodParameter(ClassFile classFile, ConstantPool constants, Method method, LocalVariables localVariables, VariableNameGenerator variableNameGenerator, int codeLength) {
        Signature as = method.getAttributeSignature();
        int methodSignatureIndex = method.getSignatureIndex();
        String methodSignature = constants.getConstantUtf8(methodSignatureIndex);
        List<String> parameterTypes = SignatureUtil.getParameterSignatures(methodSignature);
        if (parameterTypes != null) {
            boolean staticMethodFlag = (method.getAccessFlags() & 8) != 0;
            int variableIndex = staticMethodFlag ? 0 : 1;
            int firstVisibleParameterCounter = 0;
            if (method.getNameIndex() == constants.getInstanceConstructorIndex()) {
                if ((classFile.getAccessFlags() & 0x4000) != 0) {
                    if (as == null) {
                        firstVisibleParameterCounter = 2;
                    } else {
                        variableIndex = 3;
                    }
                } else if (classFile.isAInnerClass() && (classFile.getAccessFlags() & 8) == 0) {
                    firstVisibleParameterCounter = 1;
                }
            }
            int anonymousClassDepth = 0;
            ClassFile anonymousClassFile = classFile;
            while (anonymousClassFile != null && anonymousClassFile.getInternalAnonymousClassName() != null) {
                ++anonymousClassDepth;
                anonymousClassFile = anonymousClassFile.getOuterClass();
            }
            int length = parameterTypes.size();
            int varargsParameterIndex = (method.getAccessFlags() & 0x80) == 0 ? Integer.MAX_VALUE : length - 1;
            int parameterIndex = 0;
            while (parameterIndex < length) {
                char firstChar;
                String signature = parameterTypes.get(parameterIndex);
                if (localVariables.getLocalVariableWithIndexAndOffset(variableIndex, 0) == null) {
                    boolean appearsOnceFlag = LocalVariableAnalyzer.signatureAppearsOnceInParameters(parameterTypes, firstVisibleParameterCounter, length, signature);
                    String name = variableNameGenerator.generateParameterNameFromSignature(signature, appearsOnceFlag, parameterIndex == varargsParameterIndex, anonymousClassDepth);
                    int nameIndex = constants.addConstantUtf8(name);
                    int signatureIndex = constants.addConstantUtf8(signature);
                    LocalVariable lv = new LocalVariable(0, codeLength, nameIndex, signatureIndex, variableIndex);
                    localVariables.add(lv);
                }
                variableIndex += (firstChar = signature.charAt(0)) == 'D' || firstChar == 'J' ? 2 : 1;
                ++parameterIndex;
            }
        }
    }

    private static void generateMissingMonitorLocalVariables(ConstantPool constants, LocalVariables localVariables, List<Instruction> listForAnalyze) {
        int length = listForAnalyze.size();
        int i = 1;
        while (i < length) {
            block8: {
                LocalVariable lv;
                ALoad al;
                int monitorLocalVariableOffset;
                int monitorLocalVariableIndex;
                int monitorLocalVariableLength;
                Instruction instruction;
                block10: {
                    AStore astore;
                    MonitorEnter mEnter;
                    block9: {
                        AStore astore2;
                        instruction = listForAnalyze.get(i);
                        if (instruction.getOpcode() != 194) break block8;
                        mEnter = (MonitorEnter)instruction;
                        monitorLocalVariableLength = 1;
                        if (mEnter.getObjectref().getOpcode() != 263) break block9;
                        instruction = listForAnalyze.get(i - 1);
                        if (instruction.getOpcode() != 58 || (astore2 = (AStore)instruction).getValueref().getOpcode() != 263) break block8;
                        DupLoad dupload1 = (DupLoad)mEnter.getObjectref();
                        DupLoad dupload2 = (DupLoad)astore2.getValueref();
                        if (dupload1.getDupStore() != dupload2.getDupStore()) break block8;
                        monitorLocalVariableIndex = astore2.getIndex();
                        monitorLocalVariableOffset = astore2.getOffset();
                        break block10;
                    }
                    if (mEnter.getObjectref().getOpcode() != 25) break block8;
                    ALoad aload = (ALoad)mEnter.getObjectref();
                    instruction = listForAnalyze.get(i - 1);
                    if (instruction.getOpcode() != 58 || (astore = (AStore)instruction).getIndex() != aload.getIndex()) break block8;
                    monitorLocalVariableIndex = astore.getIndex();
                    monitorLocalVariableOffset = astore.getOffset();
                }
                int monitorExitCount = 0;
                int j = i;
                while (++j < length) {
                    instruction = listForAnalyze.get(j);
                    if (instruction.getOpcode() != 195 || ((MonitorExit)instruction).getObjectref().getOpcode() != 25 || (al = (ALoad)((MonitorExit)instruction).getObjectref()).getIndex() != monitorLocalVariableIndex) continue;
                    monitorLocalVariableLength = al.getOffset() - monitorLocalVariableOffset;
                    ++monitorExitCount;
                }
                if (monitorExitCount == 1) {
                    j = i;
                    while (j-- > 0) {
                        instruction = listForAnalyze.get(j);
                        if (instruction.getOpcode() != 195 || ((MonitorExit)instruction).getObjectref().getOpcode() != 25 || (al = (ALoad)((MonitorExit)instruction).getObjectref()).getIndex() != monitorLocalVariableIndex) continue;
                        monitorLocalVariableLength += monitorLocalVariableOffset - al.getOffset();
                        monitorLocalVariableOffset = al.getOffset();
                        ++monitorExitCount;
                        break;
                    }
                }
                if (monitorExitCount >= 2 && ((lv = localVariables.getLocalVariableWithIndexAndOffset(monitorLocalVariableIndex, monitorLocalVariableOffset)) == null || lv.getStartPc() + lv.getLength() < monitorLocalVariableOffset + monitorLocalVariableLength)) {
                    int signatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
                    localVariables.add(new LocalVariable(monitorLocalVariableOffset, monitorLocalVariableLength, signatureIndex, signatureIndex, monitorLocalVariableIndex));
                }
            }
            ++i;
        }
    }

    private static void checkLocalVariableRanges(ConstantPool constants, byte[] code, LocalVariables localVariables, VariableNameGenerator variableNameGenerator, List<Instruction> listForAnalyze) {
        int length = localVariables.size();
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length) {
            localVariables.getLocalVariableAt(i).setLength(1);
            ++i;
        }
        length = listForAnalyze.size();
        int i2 = 0;
        while (i2 < length) {
            Instruction instruction = listForAnalyze.get(i2);
            switch (instruction.getOpcode()) {
                case 277: 
                case 278: {
                    instruction = ((IncInstruction)instruction).getValue();
                    if (instruction.getOpcode() != 21 && instruction.getOpcode() != 268) break;
                    LocalVariableAnalyzer.checkLocalVariableRangesForIndexInstruction(code, localVariables, (IndexInstruction)instruction);
                    break;
                }
                case 58: {
                    AStore astore = (AStore)instruction;
                    if (astore.getValueref().getOpcode() == 270) {
                        LocalVariable lv;
                        ExceptionLoad el = (ExceptionLoad)astore.getValueref();
                        if (el.getExceptionNameIndex() == 0 || (lv = localVariables.getLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset())) != null) break;
                        int nextOffset = ByteCodeUtil.nextInstructionOffset((byte[])code, (int)astore.getOffset());
                        lv = localVariables.getLocalVariableWithIndexAndOffset(astore.getIndex(), nextOffset);
                        if (lv == null) {
                            lv = new LocalVariable(astore.getOffset(), 1, -1, el.getExceptionNameIndex(), astore.getIndex(), true);
                            localVariables.add(lv);
                            String signature = constants.getConstantUtf8(el.getExceptionNameIndex());
                            boolean appearsOnce = LocalVariableAnalyzer.signatureAppearsOnceInLocalVariables(localVariables, localVariables.size(), el.getExceptionNameIndex());
                            String name = variableNameGenerator.generateLocalVariableNameFromSignature(signature, appearsOnce);
                            lv.setNameIndex(constants.addConstantUtf8(name));
                            break;
                        }
                        lv.updateRange(astore.getOffset());
                        break;
                    }
                    if (i2 + 1 < length && astore.getValueref().getOpcode() == 263 && listForAnalyze.get(i2 + 1).getOpcode() == 194) {
                        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset());
                        if (lv != null) break;
                        MonitorEnter me = (MonitorEnter)listForAnalyze.get(i2 + 1);
                        if (me.getObjectref().getOpcode() == 263 && ((DupLoad)astore.getValueref()).getDupStore() == ((DupLoad)me.getObjectref()).getDupStore()) {
                            int signatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
                            localVariables.add(new LocalVariable(astore.getOffset(), 1, signatureIndex, signatureIndex, astore.getIndex()));
                            break;
                        }
                        LocalVariableAnalyzer.checkLocalVariableRangesForIndexInstruction(code, localVariables, astore);
                        break;
                    }
                    LocalVariableAnalyzer.checkLocalVariableRangesForIndexInstruction(code, localVariables, astore);
                    break;
                }
                case 21: 
                case 25: 
                case 54: 
                case 132: 
                case 268: 
                case 269: {
                    LocalVariableAnalyzer.checkLocalVariableRangesForIndexInstruction(code, localVariables, (IndexInstruction)instruction);
                }
            }
            ++i2;
        }
    }

    private static void checkLocalVariableRangesForIndexInstruction(byte[] code, LocalVariables localVariables, IndexInstruction ii) {
        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
        if (lv == null) {
            int nextOffset = ByteCodeUtil.nextInstructionOffset((byte[])code, (int)ii.getOffset());
            lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), nextOffset);
            if (lv != null) {
                lv.updateRange(ii.getOffset());
            } else {
                lv = localVariables.searchLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
                if (lv != null) {
                    lv.updateRange(ii.getOffset());
                }
            }
        } else {
            lv.updateRange(ii.getOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void analyzeMethodCode(ClassFile classFile, LocalVariables localVariables, List<Instruction> listForAnalyze, String returnedSignature) {
        boolean change;
        ConstantPool constants = classFile.getConstantPool();
        int i = 0;
        while (i < listForAnalyze.size()) {
            AConstNull aConstNull;
            Object ternaryOpStore;
            SearchInstructionByTypeVisitor<Instruction> searchInstructionByOffsetVisitor;
            Instruction ternaryOp2ndValue;
            Instruction instruction;
            Instruction instruction2 = listForAnalyze.get(i);
            if (instruction2.getOpcode() == 54 || instruction2.getOpcode() == 269 || instruction2.getOpcode() == 58 || instruction2.getOpcode() == 21 || instruction2.getOpcode() == 268 || instruction2.getOpcode() == 25 || instruction2.getOpcode() == 132) {
                LocalVariableAnalyzer.subAnalyzeMethodCode(classFile, localVariables, listForAnalyze, ((IndexInstruction)instruction2).getIndex(), i, returnedSignature);
            }
            if (instruction2.getOpcode() == 280 && i < listForAnalyze.size() - 1 && (instruction = (ternaryOp2ndValue = (searchInstructionByOffsetVisitor = new SearchInstructionByTypeVisitor<Instruction>(Instruction.class, arg_0 -> LocalVariableAnalyzer.lambda$0((TernaryOpStore)(ternaryOpStore = (TernaryOpStore)instruction2), arg_0))).visit(listForAnalyze.get(i + 1)))) instanceof AConstNull && (aConstNull = (AConstNull)instruction) == (AConstNull)instruction) {
                void aConstNull2;
                aConstNull2.setSignatureFunction(((TernaryOpStore)ternaryOpStore)::getReturnedSignature);
            }
            ++i;
        }
        do {
            change = false;
            block12: for (Instruction instruction2 : listForAnalyze) {
                switch (instruction2.getOpcode()) {
                    case 54: {
                        StoreInstruction si = (StoreInstruction)instruction2;
                        if (si.getValueref().getOpcode() != 21) break;
                        change |= LocalVariableAnalyzer.reverseAnalyzeIStore(localVariables, si);
                        break;
                    }
                    case 179: {
                        PutStatic ps = (PutStatic)instruction2;
                        if (ps.getValueref().getOpcode() != 21 && ps.getValueref().getOpcode() != 25) continue block12;
                        LoadInstruction load = (LoadInstruction)ps.getValueref();
                        change |= LocalVariableAnalyzer.reverseAnalyzePutStaticPutField(constants, localVariables, ps, load);
                        break;
                    }
                    case 181: {
                        PutField pf = (PutField)instruction2;
                        if (pf.getValueref().getOpcode() != 21 && pf.getValueref().getOpcode() != 25) continue block12;
                        LoadInstruction load = (LoadInstruction)pf.getValueref();
                        change |= LocalVariableAnalyzer.reverseAnalyzePutStaticPutField(constants, localVariables, pf, load);
                    }
                }
            }
        } while (change);
        int internalObjectSignatureIndex = constants.addConstantUtf8("Ljava/lang/Object;");
        int i2 = 0;
        while (i2 < localVariables.size()) {
            LocalVariable lv = localVariables.getLocalVariableAt(i2);
            switch (lv.getSignatureIndex()) {
                case -1: {
                    lv.setSignatureIndex(constants.addConstantUtf8("Ljava/lang/Object;"));
                    break;
                }
                case -2: {
                    lv.setSignatureIndex(constants.addConstantUtf8(SignatureUtil.getSignatureFromTypesBitField(lv.getTypesBitField())));
                    break;
                }
                case -3: {
                    lv.setSignatureIndex(internalObjectSignatureIndex);
                }
            }
            ++i2;
        }
    }

    private static void subAnalyzeMethodCode(ClassFile classFile, LocalVariables localVariables, List<Instruction> listForAnalyze, int varIndex, int startIndex, String returnedSignature) {
        IndexInstruction firstInstruction = (IndexInstruction)listForAnalyze.get(startIndex);
        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(firstInstruction.getIndex(), firstInstruction.getOffset());
        if (lv != null) {
            AStore astore;
            if (firstInstruction.getOpcode() == 58 && (astore = (AStore)firstInstruction).getValueref().getOpcode() == 270) {
                lv.setExceptionOrReturnAddress(true);
            }
            return;
        }
        int length = listForAnalyze.size();
        int i = startIndex;
        while (i < length) {
            Instruction instruction = listForAnalyze.get(i);
            switch (instruction.getOpcode()) {
                case 54: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeIStore(classFile, localVariables, instruction);
                    break;
                }
                case 269: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeStore(classFile, localVariables, instruction);
                    break;
                }
                case 58: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeAStore(classFile, localVariables, instruction);
                    break;
                }
                case 277: 
                case 278: {
                    instruction = ((IncInstruction)instruction).getValue();
                    if (instruction.getOpcode() != 21 && instruction.getOpcode() != 268) break;
                }
                case 21: 
                case 132: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeILoad(localVariables, instruction);
                    break;
                }
                case 268: 
                case 270: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeLoad(localVariables, instruction);
                    break;
                }
                case 25: {
                    if (((IndexInstruction)instruction).getIndex() != varIndex) break;
                    LocalVariableAnalyzer.analyzeALoad(localVariables, instruction);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    LocalVariableAnalyzer.analyzeInvokeInstruction(classFile.getConstantPool(), localVariables, instruction, varIndex);
                    break;
                }
                case 267: {
                    BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                    LocalVariableAnalyzer.analyzeBinaryOperator(classFile, localVariables, instruction, boi.getValue1(), boi.getValue2(), varIndex);
                    break;
                }
                case 261: {
                    IfCmp ic = (IfCmp)instruction;
                    LocalVariableAnalyzer.analyzeBinaryOperator(classFile, localVariables, instruction, ic.getValue1(), ic.getValue2(), varIndex);
                    break;
                }
                case 273: {
                    LocalVariableAnalyzer.analyzeReturnInstruction(classFile, localVariables, instruction, varIndex, returnedSignature);
                }
            }
            ++i;
        }
    }

    private static void analyzeIStore(ClassFile classFile, LocalVariables localVariables, Instruction instruction) {
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.getIndex();
        int offset = store.getOffset();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        String signature = store.getReturnedSignature(classFile, localVariables);
        if (lv == null) {
            ILoad iload;
            int typesBitField = signature == null ? (store.getValueref().getOpcode() == 21 ? ((lv = localVariables.getLocalVariableWithIndexAndOffset((iload = (ILoad)store.getValueref()).getIndex(), iload.getOffset())) == null ? 31 : lv.getTypesBitField()) : 31) : SignatureUtil.createTypesBitField(signature);
            localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
        } else if (signature == null) {
            lv.updateRange(offset);
        } else {
            int typesBitField = SignatureUtil.createTypesBitField(signature);
            switch (lv.getSignatureIndex()) {
                case -2: {
                    if ((typesBitField & lv.getTypesBitField()) != 0) {
                        lv.setTypesBitField(lv.getTypesBitField() & typesBitField);
                        lv.updateRange(offset);
                        break;
                    }
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                    break;
                }
                case -3: 
                case -1: {
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                    break;
                }
                default: {
                    ConstantPool constants = classFile.getConstantPool();
                    String signatureLV = lv.getSignature(constants);
                    int typesBitFieldLV = SignatureUtil.createTypesBitField(signatureLV);
                    if ((typesBitField & typesBitFieldLV) != 0) {
                        lv.updateRange(offset);
                        break;
                    }
                    localVariables.add(new LocalVariable(offset, 1, -1, -2, index, typesBitField));
                }
            }
        }
    }

    private static void analyzeILoad(LocalVariables localVariables, Instruction instruction) {
        int offset;
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.getIndex();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset = load.getOffset());
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -2, index, 31));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void analyzeLoad(LocalVariables localVariables, Instruction instruction) {
        int offset;
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.getIndex();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset = load.getOffset());
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -1, index));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void analyzeALoad(LocalVariables localVariables, Instruction instruction) {
        int offset;
        IndexInstruction load = (IndexInstruction)instruction;
        int index = load.getIndex();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset = load.getOffset());
        if (lv == null) {
            localVariables.add(new LocalVariable(offset, 1, -1, -1, index));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void analyzeInvokeInstruction(ConstantPool constants, LocalVariables localVariables, Instruction instruction, int varIndex) {
        InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
        List<Instruction> args = invokeInstruction.getArgs();
        List<String> argSignatures = invokeInstruction.getListOfParameterSignatures(constants);
        int nbrOfArgs = args.size();
        int j = 0;
        while (j < nbrOfArgs) {
            LocalVariableAnalyzer.analyzeArgOrReturnedInstruction(constants, localVariables, args.get(j), varIndex, argSignatures.get(j));
            ++j;
        }
    }

    private static void analyzeArgOrReturnedInstruction(ConstantPool constants, LocalVariables localVariables, Instruction instruction, int varIndex, String signature) {
        LocalVariable lv;
        LoadInstruction li;
        if (instruction.getOpcode() == 21) {
            LocalVariable lv2;
            LoadInstruction li2 = (LoadInstruction)instruction;
            if (li2.getIndex() == varIndex && (lv2 = localVariables.searchLocalVariableWithIndexAndOffset(li2.getIndex(), li2.getOffset())) != null) {
                lv2.setTypesBitField(lv2.getTypesBitField() & SignatureUtil.createArgOrReturnBitFields(signature));
            }
        } else if (instruction.getOpcode() == 25 && (li = (LoadInstruction)instruction).getIndex() == varIndex && (lv = localVariables.searchLocalVariableWithIndexAndOffset(li.getIndex(), li.getOffset())) != null) {
            if (lv.getSignatureIndex() == -1) {
                lv.setSignatureIndex(constants.addConstantUtf8(signature));
            } else if (lv.getSignatureIndex() == -2) {
                new Throwable("type inattendu").printStackTrace();
            }
        }
    }

    private static void analyzeBinaryOperator(ClassFile classFile, LocalVariables localVariables, Instruction instruction, Instruction i1, Instruction i2, int varIndex) {
        LocalVariable lv2;
        if (!(i1.getOpcode() == 21 && ((ILoad)i1).getIndex() == varIndex || i2.getOpcode() == 21 && ((ILoad)i2).getIndex() == varIndex)) {
            return;
        }
        LocalVariable lv1 = i1.getOpcode() == 21 ? localVariables.searchLocalVariableWithIndexAndOffset(((ILoad)i1).getIndex(), i1.getOffset()) : null;
        LocalVariable localVariable = lv2 = i2.getOpcode() == 21 ? localVariables.searchLocalVariableWithIndexAndOffset(((ILoad)i2).getIndex(), i2.getOffset()) : null;
        if (lv1 != null) {
            lv1.updateRange(instruction.getOffset());
            if (lv2 != null) {
                lv2.updateRange(instruction.getOffset());
            }
            if (lv1.getSignatureIndex() == -2) {
                if (lv2 != null) {
                    if (lv2.getSignatureIndex() == -2) {
                        lv1.setTypesBitField(lv1.getTypesBitField() & lv2.getTypesBitField());
                        lv2.setTypesBitField(lv2.getTypesBitField() & lv1.getTypesBitField());
                    } else {
                        lv1.setSignatureIndex(lv2.getSignatureIndex());
                    }
                } else {
                    int type;
                    String signature = i2.getReturnedSignature(classFile, localVariables);
                    if (SignatureUtil.isIntegerSignature(signature) && (type = SignatureUtil.createTypesBitField(signature)) != 0) {
                        lv1.setTypesBitField(lv1.getTypesBitField() & type);
                    }
                }
            } else if (lv2 != null && lv2.getSignatureIndex() == -2) {
                lv2.setSignatureIndex(lv1.getSignatureIndex());
            }
        } else if (lv2 != null) {
            int type;
            String signature;
            lv2.updateRange(instruction.getOffset());
            if (lv2.getSignatureIndex() == -2 && SignatureUtil.isIntegerSignature(signature = i1.getReturnedSignature(classFile, localVariables)) && (type = SignatureUtil.createTypesBitField(signature)) != 0) {
                lv2.setTypesBitField(lv2.getTypesBitField() & type);
            }
        }
    }

    private static void analyzeReturnInstruction(ClassFile classFile, LocalVariables localVariables, Instruction instruction, int varIndex, String returnedSignature) {
        ReturnInstruction ri = (ReturnInstruction)instruction;
        ConstantPool constants = classFile.getConstantPool();
        LocalVariableAnalyzer.analyzeArgOrReturnedInstruction(constants, localVariables, ri.getValueref(), varIndex, returnedSignature);
    }

    private static void analyzeStore(ClassFile classFile, LocalVariables localVariables, Instruction instruction) {
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.getIndex();
        int offset = store.getOffset();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        ConstantPool constants = classFile.getConstantPool();
        String signature = instruction.getReturnedSignature(classFile, localVariables);
        int signatureIndex = Optional.ofNullable(signature).map(constants::addConstantUtf8).orElse(-1);
        if (lv == null || lv.getSignatureIndex() != signatureIndex) {
            localVariables.add(new LocalVariable(offset, 1, -1, signatureIndex, index));
        } else {
            lv.updateRange(offset);
        }
    }

    private static void analyzeAStore(ClassFile classFile, LocalVariables localVariables, Instruction instruction) {
        boolean isExceptionOrReturnAddress;
        StoreInstruction store = (StoreInstruction)instruction;
        int index = store.getIndex();
        int offset = store.getOffset();
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(index, offset);
        String signatureInstruction = instruction.getReturnedSignature(classFile, localVariables);
        ConstantPool constants = classFile.getConstantPool();
        int signatureInstructionIndex = signatureInstruction != null ? constants.addConstantUtf8(signatureInstruction) : -1;
        boolean bl = isExceptionOrReturnAddress = store.getValueref().getOpcode() == 270 || store.getValueref().getOpcode() == 279;
        if (lv == null || lv.isExceptionOrReturnAddress() || isExceptionOrReturnAddress && lv.getStartPc() + lv.getLength() < offset) {
            localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index, isExceptionOrReturnAddress));
        } else if (!isExceptionOrReturnAddress) {
            if (lv.getSignatureIndex() == -1) {
                lv.setSignatureIndex(signatureInstructionIndex);
                lv.updateRange(offset);
            } else if (lv.getSignatureIndex() == -2) {
                localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index));
            } else if (lv.getSignatureIndex() == signatureInstructionIndex || lv.getSignatureIndex() == -3) {
                lv.updateRange(offset);
            } else {
                String signatureLV = lv.getSignature(constants);
                if (SignatureUtil.isPrimitiveSignature(signatureLV)) {
                    localVariables.add(new LocalVariable(offset, 1, -1, signatureInstructionIndex, index));
                } else {
                    lv.updateRange(offset);
                }
            }
        }
    }

    private static void setConstantTypes(ClassFile classFile, LocalVariables localVariables, List<Instruction> list, List<Instruction> listForAnalyze, String returnedSignature) {
        ConstantPool constants = classFile.getConstantPool();
        for (Instruction instruction : listForAnalyze) {
            switch (instruction.getOpcode()) {
                case 271: {
                    LocalVariableAnalyzer.setConstantTypesArrayLoad(classFile, localVariables, (ArrayLoadInstruction)instruction);
                    break;
                }
                case 272: {
                    LocalVariableAnalyzer.setConstantTypesArrayStore(classFile.getConstantPool(), localVariables, (ArrayStoreInstruction)instruction);
                    break;
                }
                case 267: {
                    BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                    LocalVariableAnalyzer.setConstantTypesBinaryOperator(classFile, localVariables, boi.getValue1(), boi.getValue2());
                    break;
                }
                case 261: {
                    IfCmp ic = (IfCmp)instruction;
                    LocalVariableAnalyzer.setConstantTypesBinaryOperator(classFile, localVariables, ic.getValue1(), ic.getValue2());
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 274: {
                    LocalVariableAnalyzer.setConstantTypesInvokeInstruction(constants, instruction);
                    break;
                }
                case 54: {
                    LocalVariableAnalyzer.setConstantTypesIStore(constants, localVariables, instruction);
                    break;
                }
                case 181: {
                    PutField putField = (PutField)instruction;
                    LocalVariableAnalyzer.setConstantTypesPutFieldAndPutStatic(constants, putField.getValueref(), putField.getIndex());
                    break;
                }
                case 179: {
                    PutStatic putStatic = (PutStatic)instruction;
                    LocalVariableAnalyzer.setConstantTypesPutFieldAndPutStatic(constants, putStatic.getValueref(), putStatic.getIndex());
                    break;
                }
                case 273: {
                    LocalVariableAnalyzer.setConstantTypesXReturn(instruction, returnedSignature);
                }
            }
        }
        for (Instruction instruction : listForAnalyze) {
            if (instruction.getOpcode() != 280) continue;
            TernaryOpStore tos = (TernaryOpStore)instruction;
            LocalVariableAnalyzer.setConstantTypesTernaryOpStore(classFile, localVariables, list, tos);
        }
    }

    private static void setConstantTypesInvokeInstruction(ConstantPool constants, Instruction instruction) {
        InvokeInstruction invokeInstruction = (InvokeInstruction)instruction;
        List<Instruction> args = invokeInstruction.getArgs();
        List<String> types = invokeInstruction.getListOfParameterSignatures(constants);
        int nbrOfArgs = args.size();
        int j = 0;
        while (j < nbrOfArgs) {
            Instruction arg = args.get(j);
            if (arg.getOpcode() == 16 || arg.getOpcode() == 256 || arg.getOpcode() == 17) {
                ((IConst)arg).setReturnedSignature(types.get(j));
            }
            ++j;
        }
    }

    private static void setConstantTypesPutFieldAndPutStatic(ConstantPool constants, Instruction valueref, int index) {
        if (valueref.getOpcode() == 16 || valueref.getOpcode() == 256 || valueref.getOpcode() == 17) {
            ConstantFieldref cfr = constants.getConstantFieldref(index);
            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            String signature = constants.getConstantUtf8(cnat.getSignatureIndex());
            ((IConst)valueref).setReturnedSignature(signature);
        }
    }

    private static void setConstantTypesTernaryOpStore(ClassFile classFile, LocalVariables localVariables, List<Instruction> list, TernaryOpStore tos) {
        int index;
        if ((tos.getObjectref().getOpcode() == 16 || tos.getObjectref().getOpcode() == 256 || tos.getObjectref().getOpcode() == 17) && (index = InstructionUtil.getIndexForOffset(list, tos.getTernaryOp2ndValueOffset())) != -1) {
            int length = list.size();
            SearchInstructionByTypeVisitor<Instruction> searchInstructionByOffsetVisitor = new SearchInstructionByTypeVisitor<Instruction>(Instruction.class, i -> i.getOffset() == tos.getTernaryOp2ndValueOffset());
            while (index < length) {
                Instruction result = searchInstructionByOffsetVisitor.visit(list.get(index));
                if (result != null) {
                    String signature = result.getReturnedSignature(classFile, localVariables);
                    ((IConst)tos.getObjectref()).setReturnedSignature(signature);
                    break;
                }
                ++index;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setConstantTypesArrayLoad(ClassFile classFile, LocalVariables localVariables, ArrayLoadInstruction ali) {
        Instruction instruction;
        void aload;
        Object lv;
        Instruction instruction2 = ali.getArrayref();
        if (instruction2 instanceof ALoad var3_4 && "B".equals(ali.getReturnedSignature(classFile, localVariables)) && (lv = localVariables.getLocalVariableWithIndexAndOffset(aload.getIndex(), aload.getOffset())) != null) {
            ConstantPool constants = classFile.getConstantPool();
            String signature = ((LocalVariable)lv).getSignature(constants);
            ali.setReturnedSignature(SignatureUtil.cutArrayDimensionPrefix(signature));
        }
        if ((instruction = ali.getArrayref()) instanceof GetField && (lv = (GetField)instruction) == (GetField)instruction && "B".equals(ali.getReturnedSignature(classFile, localVariables))) {
            void gf;
            String signature = gf.getReturnedSignature(classFile, localVariables);
            ali.setReturnedSignature(SignatureUtil.cutArrayDimensionPrefix(signature));
        }
    }

    private static void setConstantTypesArrayStore(ConstantPool constants, LocalVariables localVariables, ArrayStoreInstruction asi) {
        if (ByteCodeUtil.isLoadIntValue((int)asi.getValueref().getOpcode())) {
            int asiArrayRefOpCode = asi.getArrayref().getOpcode();
            if (asiArrayRefOpCode == 25) {
                ALoad aload = (ALoad)asi.getArrayref();
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(aload.getIndex(), aload.getOffset());
                if (lv == null) {
                    new Throwable("lv is null. index=" + aload.getIndex()).printStackTrace();
                    return;
                }
                String signature = lv.getSignature(constants);
                ((IConst)asi.getValueref()).setReturnedSignature(SignatureUtil.cutArrayDimensionPrefix(signature));
            } else if (asiArrayRefOpCode == 180 || asiArrayRefOpCode == 178) {
                IndexInstruction ii = (IndexInstruction)asi.getArrayref();
                ConstantFieldref cfr = constants.getConstantFieldref(ii.getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                String signature = constants.getConstantUtf8(cnat.getSignatureIndex());
                ((IConst)asi.getValueref()).setReturnedSignature(SignatureUtil.cutArrayDimensionPrefix(signature));
            }
        }
    }

    private static void setConstantTypesIStore(ConstantPool constants, LocalVariables localVariables, Instruction instruction) {
        StoreInstruction store = (StoreInstruction)instruction;
        if (store.getValueref().getOpcode() == 16 || store.getValueref().getOpcode() == 256 || store.getValueref().getOpcode() == 17) {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(store.getIndex(), store.getOffset());
            String signature = lv.getSignature(constants);
            ((IConst)store.getValueref()).setReturnedSignature(signature);
        }
    }

    private static void setConstantTypesBinaryOperator(ClassFile classFile, LocalVariables localVariables, Instruction i1, Instruction i2) {
        String signature;
        if (i1.getOpcode() == 16 || i1.getOpcode() == 256 || i1.getOpcode() == 17) {
            String signature2;
            if (i2.getOpcode() != 16 && i2.getOpcode() != 256 && i2.getOpcode() != 17 && (signature2 = i2.getReturnedSignature(classFile, localVariables)) != null) {
                ((IConst)i1).setReturnedSignature(signature2);
            }
        } else if ((i2.getOpcode() == 16 || i2.getOpcode() == 256 || i2.getOpcode() == 17) && (signature = i1.getReturnedSignature(classFile, localVariables)) != null) {
            ((IConst)i2).setReturnedSignature(signature);
        }
    }

    private static void setConstantTypesXReturn(Instruction instruction, String returnedSignature) {
        ReturnInstruction ri = (ReturnInstruction)instruction;
        int opcode = ri.getValueref().getOpcode();
        if (opcode != 17 && opcode != 16 && opcode != 256) {
            return;
        }
        ((IConst)ri.getValueref()).setSignature(returnedSignature);
    }

    private static String getReturnedSignature(ClassFile classFile, Method method) {
        int signatureIndex = method.getSignatureIndex();
        String signature = classFile.getConstantPool().getConstantUtf8(signatureIndex);
        return SignatureUtil.getMethodReturnedSignature(signature);
    }

    private static void initialyzeExceptionLoad(List<Instruction> listForAnalyze, LocalVariables localVariables) {
        int length = listForAnalyze.size();
        int index = 0;
        while (index < length) {
            ExceptionLoad el;
            AStore as;
            Instruction i = listForAnalyze.get(index);
            if (i.getOpcode() == 58 && (as = (AStore)i).getValueref().getOpcode() == 270 && (el = (ExceptionLoad)as.getValueref()).getIndex() == -1) {
                el.setIndex(as.getIndex());
            }
            ++index;
        }
        int index2 = 0;
        while (index2 < length) {
            ExceptionLoad el;
            Instruction i = listForAnalyze.get(index2);
            if (i.getOpcode() == 270 && (el = (ExceptionLoad)i).getIndex() == -1 && el.getExceptionNameIndex() > 0) {
                int varIndex = localVariables.size();
                LocalVariable localVariable = new LocalVariable(el.getOffset(), 1, -1, el.getExceptionNameIndex(), varIndex, true);
                localVariables.add(localVariable);
                el.setIndex(varIndex);
            }
            ++index2;
        }
    }

    private static void generateLocalVariableNames(ConstantPool constants, LocalVariables localVariables, VariableNameGenerator variableNameGenerator) {
        int length = localVariables.size();
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.getNameIndex() <= 0) {
                String signature = lv.getSignature(constants);
                boolean appearsOnce = LocalVariableAnalyzer.signatureAppearsOnceInLocalVariables(localVariables, length, lv.getSignatureIndex());
                String name = variableNameGenerator.generateLocalVariableNameFromSignature(signature, appearsOnce);
                lv.setNameIndex(constants.addConstantUtf8(name));
            }
            ++i;
        }
    }

    private static boolean signatureAppearsOnceInParameters(List<String> parameterTypes, int firstIndex, int length, String signature) {
        int counter = 0;
        int i = firstIndex;
        while (i < length && counter < 2) {
            if (signature.equals(parameterTypes.get(i))) {
                ++counter;
            }
            ++i;
        }
        return counter <= 1;
    }

    private static boolean signatureAppearsOnceInLocalVariables(LocalVariables localVariables, int length, int signatureIndex) {
        int counter = 0;
        int i = localVariables.getIndexOfFirstLocalVariable();
        while (i < length && counter < 2) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.getSignatureIndex() == signatureIndex) {
                ++counter;
            }
            ++i;
        }
        return counter == 1;
    }

    private static boolean reverseAnalyzeIStore(LocalVariables localVariables, StoreInstruction si) {
        LoadInstruction load = (LoadInstruction)si.getValueref();
        LocalVariable lvLoad = localVariables.getLocalVariableWithIndexAndOffset(load.getIndex(), load.getOffset());
        if (lvLoad == null || lvLoad.getSignatureIndex() != -2) {
            return false;
        }
        LocalVariable lvStore = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset());
        if (lvStore == null) {
            return false;
        }
        if (lvStore.getSignatureIndex() == -2) {
            int old = lvLoad.getTypesBitField();
            lvLoad.setTypesBitField(lvLoad.getTypesBitField() & lvStore.getTypesBitField());
            return old != lvLoad.getTypesBitField();
        }
        if (lvStore.getSignatureIndex() >= 0 && lvStore.getSignatureIndex() != lvLoad.getSignatureIndex()) {
            lvLoad.setSignatureIndex(lvStore.getSignatureIndex());
            return true;
        }
        return false;
    }

    private static boolean reverseAnalyzePutStaticPutField(ConstantPool constants, LocalVariables localVariables, IndexInstruction ii, LoadInstruction load) {
        LocalVariable lvLoad = localVariables.getLocalVariableWithIndexAndOffset(load.getIndex(), load.getOffset());
        if (lvLoad != null) {
            ConstantFieldref cfr = constants.getConstantFieldref(ii.getIndex());
            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            if (lvLoad.getSignatureIndex() == -2) {
                String descriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
                int typesBitField = SignatureUtil.createArgOrReturnBitFields(descriptor);
                int old = lvLoad.getTypesBitField();
                lvLoad.setTypesBitField(lvLoad.getTypesBitField() & typesBitField);
                return old != lvLoad.getTypesBitField();
            }
            if (lvLoad.getSignatureIndex() == -1) {
                lvLoad.setSignatureIndex(cnat.getSignatureIndex());
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$0(TernaryOpStore ternaryOpStore, Instruction instr) {
        return instr.getOffset() == ternaryOpStore.getTernaryOp2ndValueOffset();
    }
}

