/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import jd.core.util.CharArrayUtil;

public final class FieldNameGenerator {
    private FieldNameGenerator() {
    }

    public static String generateName(String signature, String name) {
        StringBuilder sbName = new StringBuilder("jdField_");
        sbName.append(name);
        sbName.append("OfType");
        char[] caSignature = signature.toCharArray();
        int length = caSignature.length;
        FieldNameGenerator.generateName(sbName, caSignature, length, 0);
        return sbName.toString();
    }

    private static int generateName(StringBuilder sbName, char[] caSignature, int length, int index) {
        sbName.append('_');
        while (true) {
            int nbrOfDimensions = 0;
            while (caSignature[index] == '[') {
                ++index;
                ++nbrOfDimensions;
            }
            if (nbrOfDimensions > 0) {
                sbName.append("Array");
                if (nbrOfDimensions > 1) {
                    sbName.append(nbrOfDimensions);
                    sbName.append('d');
                }
                sbName.append("Of");
            }
            switch (caSignature[index]) {
                case 'B': {
                    sbName.append("Byte");
                    ++index;
                    break;
                }
                case 'C': {
                    sbName.append("Char");
                    ++index;
                    break;
                }
                case 'D': {
                    sbName.append("Double");
                    ++index;
                    break;
                }
                case 'F': {
                    sbName.append("Float");
                    ++index;
                    break;
                }
                case 'I': {
                    sbName.append("Int");
                    ++index;
                    break;
                }
                case 'J': {
                    sbName.append("Long");
                    ++index;
                    break;
                }
                case '.': 
                case 'L': {
                    int beginIndex = ++index;
                    int c = 46;
                    while (index < length) {
                        c = caSignature[index];
                        if (c == 59 || c == 60) break;
                        ++index;
                    }
                    String internalClassName = CharArrayUtil.substring(caSignature, beginIndex, index);
                    FieldNameGenerator.internalClassNameToCapitalizedClassName(sbName, internalClassName);
                    if (c == 60) {
                        sbName.append("Of");
                        index = FieldNameGenerator.generateName(sbName, caSignature, length, index + 1);
                        while (caSignature[index] != '>') {
                            sbName.append("And");
                            index = FieldNameGenerator.generateName(sbName, caSignature, length, index);
                        }
                        ++index;
                    }
                    if (caSignature[index] != ';') break;
                    ++index;
                    break;
                }
                case 'S': {
                    sbName.append("Short");
                    ++index;
                    break;
                }
                case 'T': {
                    int beginIndex = ++index;
                    index = CharArrayUtil.indexOf(caSignature, ';', beginIndex);
                    sbName.append(caSignature, beginIndex, index - beginIndex);
                    ++index;
                    break;
                }
                case 'V': {
                    sbName.append("Void");
                    ++index;
                    break;
                }
                case 'Z': {
                    sbName.append("Boolean");
                    ++index;
                    break;
                }
                case '-': {
                    sbName.append("Super");
                    index = FieldNameGenerator.generateName(sbName, caSignature, length, index + 1);
                    break;
                }
                case '+': {
                    sbName.append("Extends");
                    index = FieldNameGenerator.generateName(sbName, caSignature, length, index + 1);
                    break;
                }
                case '*': {
                    sbName.append('X');
                    ++index;
                    break;
                }
                case 'X': 
                case 'Y': {
                    sbName.append('X');
                    System.err.println("<UNDEFINED>");
                    ++index;
                    break;
                }
                default: {
                    new Throwable("SignatureWriter.writeSignature: invalid signature '" + String.valueOf(caSignature) + "'").printStackTrace();
                }
            }
            if (index >= length || caSignature[index] != '.') break;
            sbName.append("_");
        }
        return index;
    }

    private static void internalClassNameToCapitalizedClassName(StringBuilder sbName, String internalClassName) {
        int index1 = 0;
        int index2 = internalClassName.indexOf(47);
        while (index2 != -1) {
            sbName.append(Character.toUpperCase(internalClassName.charAt(index1)));
            sbName.append(internalClassName.substring(index1 + 1, index2));
            index1 = index2 + 1;
            index2 = internalClassName.indexOf(47, index1);
        }
        sbName.append(Character.toUpperCase(internalClassName.charAt(index1)));
        sbName.append(internalClassName.substring(index1 + 1));
    }
}

