/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.AccessorAnalyzer;
import jd.core.process.analyzer.classfile.FieldNameGenerator;
import jd.core.process.analyzer.classfile.LocalVariableAnalyzer;
import jd.core.process.analyzer.classfile.reconstructor.AssignmentInstructionReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotClass118AReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotClass14Reconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotNewReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DotSuperReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.DupStoreThisReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitDexEnumFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitInstanceFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.InitStaticFieldsReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.NewInstructionReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.OuterReferenceReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.PostIncReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.PreIncReconstructor;
import jd.core.process.analyzer.classfile.reconstructor.SimpleNewInstructionReconstructor;
import jd.core.process.analyzer.classfile.visitor.CheckCastAndConvertInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceStringBuxxxerVisitor;
import jd.core.process.analyzer.classfile.visitor.SetConstantTypeInStringIndexOfMethodsVisitor;
import jd.core.process.analyzer.instruction.bytecode.InstructionListBuilder;
import jd.core.process.analyzer.instruction.fast.DupLocalVariableAnalyzer;
import jd.core.process.analyzer.instruction.fast.FastInstructionListBuilder;
import jd.core.process.analyzer.instruction.fast.ReturnLineNumberAnalyzer;
import jd.core.process.analyzer.instruction.fast.reconstructor.InitArrayInstructionReconstructor;
import jd.core.process.analyzer.variable.VariableNameGenerator;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class ClassFileAnalyzer {
    private ClassFileAnalyzer() {
    }

    public static void analyze(ReferenceMap referenceMap, ClassFile classFile) {
        HashMap<String, ClassFile> innerClassesMap;
        if (classFile.getInnerClassFiles() != null) {
            innerClassesMap = new HashMap<String, ClassFile>(10);
            innerClassesMap.put(classFile.getThisClassName(), classFile);
            ClassFileAnalyzer.populateInnerClassMap(innerClassesMap, classFile);
        } else {
            innerClassesMap = null;
        }
        ClassFileAnalyzer.preAnalyzeClass(referenceMap, innerClassesMap, classFile);
        ClassFileAnalyzer.analyzeClass(referenceMap, innerClassesMap, classFile);
    }

    private static void populateInnerClassMap(Map<String, ClassFile> innerClassesMap, ClassFile classFile) {
        List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles != null) {
            for (ClassFile innerClassFile : innerClassFiles) {
                innerClassesMap.put(innerClassFile.getThisClassName(), innerClassFile);
                ClassFileAnalyzer.populateInnerClassMap(innerClassesMap, innerClassFile);
            }
        }
    }

    private static void preAnalyzeClass(ReferenceMap referenceMap, Map<String, ClassFile> innerClassesMap, ClassFile classFile) {
        if ((classFile.getAccessFlags() & 0x1000) == 0) {
            ClassFileAnalyzer.preAnalyzeMethods(classFile);
            List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
            if (innerClassFiles != null) {
                for (ClassFile innerClassFile : innerClassFiles) {
                    ClassFileAnalyzer.preAnalyzeClass(referenceMap, innerClassesMap, innerClassFile);
                }
            }
        }
    }

    private static void analyzeClass(ReferenceMap referenceMap, Map<String, ClassFile> innerClassesMap, ClassFile classFile) {
        if ((classFile.getAccessFlags() & 0x1000) != 0) {
            ClassFileAnalyzer.analyzeSyntheticClass(classFile);
        } else {
            List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
            if (innerClassFiles != null) {
                for (ClassFile innerClassFile : innerClassFiles) {
                    ClassFileAnalyzer.analyzeClass(referenceMap, innerClassesMap, innerClassFile);
                }
            }
            ClassFileAnalyzer.checkUnicityOfFieldNames(classFile);
            ClassFileAnalyzer.checkUnicityOfFieldrefNames(classFile);
            ClassFileAnalyzer.analyzeMethods(referenceMap, innerClassesMap, classFile);
            ClassFileAnalyzer.checkAssertionsDisabledField(classFile);
            if ((classFile.getAccessFlags() & 0x4000) != 0) {
                ClassFileAnalyzer.analyzeEnum(classFile);
            }
        }
    }

    private static void analyzeSyntheticClass(ClassFile classFile) {
        if ((classFile.getAccessFlags() & 8) != 0 && classFile.getOuterClass() != null && classFile.getInternalAnonymousClassName() != null && classFile.getFields().length > 0 && classFile.getMethods().length == 1 && (classFile.getMethod(0).getAccessFlags() & 0x101F) == 8) {
            ClassFile outerClassFile = classFile.getOuterClass();
            ConstantPool outerConstants = outerClassFile.getConstantPool();
            ConstantPool constants = classFile.getConstantPool();
            Method method = classFile.getMethod(0);
            try {
                ArrayList<Instruction> list = new ArrayList<Instruction>();
                ArrayList<Instruction> listForAnalyze = new ArrayList<Instruction>();
                InstructionListBuilder.build(classFile, method, list, listForAnalyze);
                int length = list.size();
                int index = 0;
                while (index < length) {
                    String fieldName;
                    ConstantNameAndType cnat;
                    Field field;
                    PutStatic ps;
                    ConstantFieldref cfr;
                    if (((Instruction)list.get(index)).getOpcode() == 179 && (cfr = constants.getConstantFieldref((ps = (PutStatic)list.get(index)).getIndex())).getClassIndex() == classFile.getThisClassIndex() && (field = ClassFileAnalyzer.searchField(classFile, cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex()))) != null && (field.getAccessFlags() & 0x101F) == 4120 && (fieldName = constants.getConstantUtf8(cnat.getNameIndex())).startsWith("$SwitchMap$")) {
                        ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
                        index += 3;
                        while (index < length) {
                            Instruction instruction = (Instruction)list.get(index - 2);
                            if (instruction.getOpcode() != 272 || ((Instruction)list.get(index - 1)).getOpcode() != 167 || ((Instruction)list.get(index)).getOpcode() != 58 || (instruction = ((ArrayStoreInstruction)instruction).getIndexref()).getOpcode() != 182 || (instruction = ((Invokevirtual)instruction).getObjectref()).getOpcode() != 178) break;
                            cfr = constants.getConstantFieldref(((GetStatic)instruction).getIndex());
                            cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                            String enumName = constants.getConstantUtf8(cnat.getNameIndex());
                            int outerEnumNameIndex = outerConstants.addConstantUtf8(enumName);
                            enumNameIndexes.add(outerEnumNameIndex);
                            index += 3;
                        }
                        outerClassFile.getSwitchMaps().put(fieldName, enumNameIndexes);
                        index -= 3;
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                method.setContainsError(true);
            }
        }
    }

    private static Field searchField(ClassFile classFile, ConstantNameAndType cnat) {
        Field[] fields = classFile.getFields();
        int i = fields.length;
        while (i-- > 0) {
            Field field = fields[i];
            if (field.getNameIndex() != cnat.getNameIndex() || field.getDescriptorIndex() != cnat.getSignatureIndex()) continue;
            return field;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static void checkUnicityOfFieldNames(ClassFile classFile) {
        fields = classFile.getFields();
        constants = classFile.getConstantPool();
        map = new HashMap<String, List>();
        i = fields.length;
        while (i-- > 0) {
            field = fields[i];
            if ((field.getAccessFlags() & 5) != 0) continue;
            name = constants.getConstantUtf8(field.getNameIndex());
            map.computeIfAbsent(name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(field);
        }
        for (String name : map.keySet()) {
            list = (List)map.get(name);
            j = list.size();
            if (j >= 2) ** GOTO lbl22
            continue;
lbl-1000:
            // 1 sources

            {
                field = (Field)list.get(j);
                fieldDescriptorIndex = field.getSignatureIndex();
                newName = FieldNameGenerator.generateName(constants.getConstantUtf8(fieldDescriptorIndex), constants.getConstantUtf8(field.getNameIndex()));
                newNameIndex = constants.addConstantUtf8(newName);
                field.setNameIndex(newNameIndex);
lbl22:
                // 2 sources

                ** while (j-- > 0)
            }
lbl23:
            // 1 sources

        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void checkUnicityOfFieldrefNames(ClassFile classFile) {
        constants = classFile.getConstantPool();
        i = constants.size();
        array = new Object[i];
        while (i-- > 0) {
            constant = constants.get(i);
            if (!(constant instanceof ConstantFieldref)) continue;
            cfr = (ConstantFieldref)constant;
            map /* !! */  = (Map)array[cfr.getClassIndex()];
            if (map /* !! */  == null) {
                array[cfr.getClassIndex()] = map /* !! */  = new HashMap<String, ArrayList<E>>();
            }
            if ((list = (List)map /* !! */ .get(name = constants.getConstantUtf8((cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex())).getNameIndex()))) != null) {
                if (((ConstantNameAndType)list.get(0)).getSignatureIndex() == cnat.getSignatureIndex()) continue;
                list.add(cnat);
                continue;
            }
            list = new ArrayList<ConstantNameAndType>(5);
            map /* !! */ .put(name, list);
            list.add(cnat);
        }
        i = array.length;
        while (i-- > 0) {
            if (array[i] == null) continue;
            map /* !! */  = (HashMap<String, ArrayList<E>>)array[i];
            for (String name : map /* !! */ .keySet()) {
                list = (ArrayList<ConstantNameAndType>)map /* !! */ .get(name);
                k = list.size();
                if (k >= 2) ** GOTO lbl35
                continue;
lbl-1000:
                // 1 sources

                {
                    cnat = (ConstantNameAndType)list.get(k);
                    signature = constants.getConstantUtf8(cnat.getSignatureIndex());
                    newName = FieldNameGenerator.generateName(signature, name);
                    cnat.setNameIndex(constants.addConstantUtf8(newName));
lbl35:
                    // 2 sources

                    ** while (k-- > 0)
                }
lbl36:
                // 1 sources

            }
        }
    }

    private static void checkAssertionsDisabledField(ClassFile classFile) {
        ConstantPool constants = classFile.getConstantPool();
        Field[] fields = classFile.getFields();
        int i = fields.length;
        while (i-- > 0) {
            String name;
            Field field = fields[i];
            if ((field.getAccessFlags() & 0x101F) != 24 || field.getValueAndMethod() == null || !"$assertionsDisabled".equals(name = constants.getConstantUtf8(field.getNameIndex()))) continue;
            field.setAccessFlags(field.getAccessFlags() | 0x1000);
        }
    }

    private static boolean hasAAccessorMethodName(ClassFile classFile, Method method) {
        String methodName = classFile.getConstantPool().getConstantUtf8(method.getNameIndex());
        if (!methodName.startsWith("access$")) {
            return false;
        }
        int i = methodName.length();
        while (i-- > "access$".length()) {
            if (Character.isDigit(methodName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAEclipseSwitchTableMethodName(ClassFile classFile, Method method) {
        String methodName = classFile.getConstantPool().getConstantUtf8(method.getNameIndex());
        if (!methodName.startsWith("$SWITCH_TABLE$")) {
            return false;
        }
        String methodDescriptor = classFile.getConstantPool().getConstantUtf8(method.getDescriptorIndex());
        return "()[I".equals(methodDescriptor);
    }

    private static void parseEclipseOrDexSwitchTableMethod(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        int length = list.size();
        if (length >= 6 && list.get(0).getOpcode() == 264 && list.get(1).getOpcode() == 262 && list.get(2).getOpcode() == 273 && list.get(3).getOpcode() == 87 && list.get(4).getOpcode() == 58) {
            ConstantPool constants = classFile.getConstantPool();
            ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
            int index = 7;
            while (index < length) {
                Instruction instruction = list.get(index - 2);
                if (instruction.getOpcode() != 272 || list.get(index - 1).getOpcode() != 167 || list.get(index).getOpcode() != 87 || (instruction = ((ArrayStoreInstruction)instruction).getIndexref()).getOpcode() != 182 || (instruction = ((Invokevirtual)instruction).getObjectref()).getOpcode() != 178) break;
                ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                enumNameIndexes.add(cnat.getNameIndex());
                index += 3;
            }
            classFile.getSwitchMaps().put(constants.getConstantUtf8(method.getNameIndex()), enumNameIndexes);
        } else if (length >= 7 && list.get(0).getOpcode() == 58 && list.get(1).getOpcode() == 262 && list.get(2).getOpcode() == 273 && list.get(3).getOpcode() == 58 && list.get(4).getOpcode() == 272) {
            ConstantPool constants = classFile.getConstantPool();
            ArrayList<Integer> enumNameIndexes = new ArrayList<Integer>();
            int index = 4;
            while (index < length) {
                Instruction instruction = list.get(index);
                if (instruction.getOpcode() != 272 || (instruction = ((ArrayStoreInstruction)instruction).getIndexref()).getOpcode() != 182 || (instruction = ((Invokevirtual)instruction).getObjectref()).getOpcode() != 178) break;
                ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                enumNameIndexes.add(cnat.getNameIndex());
                ++index;
            }
            classFile.getSwitchMaps().put(constants.getConstantUtf8(method.getNameIndex()), enumNameIndexes);
        }
    }

    private static void preAnalyzeMethods(ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        VariableNameGenerator variableNameGenerator = classFile.getVariableNameGenerator();
        int outerThisFieldrefIndex = 0;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                if (method.getCode() == null) {
                    if ((method.getAccessFlags() & 0x1040) == 0) {
                        LocalVariableAnalyzer.analyze(classFile, method, variableNameGenerator, null, null);
                    }
                } else {
                    outerThisFieldrefIndex = ClassFileAnalyzer.preAnalyzeSingleMethod(classFile, variableNameGenerator, outerThisFieldrefIndex, method);
                }
            }
            catch (Exception e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                method.setContainsError(true);
            }
            ++n2;
        }
        if (outerThisFieldrefIndex != 0) {
            ClassFileAnalyzer.analyzeOuterReferences(classFile, outerThisFieldrefIndex);
        }
    }

    public static int preAnalyzeSingleMethod(ClassFile classFile, VariableNameGenerator variableNameGenerator, int outerThisFieldrefIndex, Method method) {
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        ArrayList<Instruction> listForAnalyze = new ArrayList<Instruction>();
        InstructionListBuilder.build(classFile, method, list, listForAnalyze);
        method.setInstructions(list);
        if ((method.getAccessFlags() & 0xF) == 8 && ClassFileAnalyzer.hasAAccessorMethodName(classFile, method)) {
            PreIncReconstructor.reconstruct(list);
            PostIncReconstructor.reconstruct(list);
            DupStoreThisReconstructor.reconstruct(list);
            AccessorAnalyzer.analyze(classFile, method);
            method.setAccessFlags(method.getAccessFlags() | 0x1000);
        } else if ((method.getAccessFlags() & 0x1040) == 0 || method.isLambda(classFile.getConstantPool())) {
            LocalVariableAnalyzer.analyze(classFile, method, variableNameGenerator, list, listForAnalyze);
            outerThisFieldrefIndex = ClassFileAnalyzer.searchOuterThisFieldrefIndex(classFile, method, list, outerThisFieldrefIndex);
        } else if ((method.getAccessFlags() & 0x100F) == 4104 && ClassFileAnalyzer.hasAEclipseSwitchTableMethodName(classFile, method)) {
            ClassFileAnalyzer.parseEclipseOrDexSwitchTableMethod(classFile, method);
        }
        return outerThisFieldrefIndex;
    }

    private static void analyzeMethods(ReferenceMap referenceMap, Map<String, ClassFile> innerClassesMap, ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        OuterReferenceReconstructor outerReferenceReconstructor = innerClassesMap != null ? new OuterReferenceReconstructor(innerClassesMap, classFile) : null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (((method.getAccessFlags() & 0x1040) == 0 || method.isLambda(classFile.getConstantPool())) && method.getCode() != null && !method.containsError()) {
                try {
                    ClassFileAnalyzer.analyzeSingleMethod(referenceMap, classFile, outerReferenceReconstructor, method);
                }
                catch (Exception e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    method.setContainsError(true);
                }
            }
            ++n2;
        }
        InitDexEnumFieldsReconstructor.reconstruct(classFile);
        InitStaticFieldsReconstructor.reconstruct(classFile);
        InitInstanceFieldsReconstructor.reconstruct(classFile);
        ClassFileAnalyzer.postAnalyzeMethods(classFile, methods);
    }

    private static void postAnalyzeMethods(ClassFile classFile, Method[] methods) {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (((method.getAccessFlags() & 0x1000) == 0 || method.isLambda(classFile.getConstantPool())) && (method.getAccessFlags() & 0x40) == 0 && method.getCode() != null && method.getFastNodes() != null && !method.containsError()) {
                ClassFileAnalyzer.postAnalyzeSingleMethod(classFile, method);
            }
            ++n2;
        }
    }

    public static void analyzeSingleMethod(ReferenceMap referenceMap, ClassFile classFile, OuterReferenceReconstructor outerReferenceReconstructor, Method method) {
        List<Instruction> list = method.getInstructions();
        if (outerReferenceReconstructor != null) {
            outerReferenceReconstructor.reconstruct(method, list);
        }
        NewInstructionReconstructor.reconstruct(classFile, method, list);
        SimpleNewInstructionReconstructor.reconstruct(classFile, method, list);
        PreIncReconstructor.reconstruct(list);
        PostIncReconstructor.reconstruct(list);
        DotClass118AReconstructor.reconstruct(referenceMap, classFile, list);
        DotClass14Reconstructor.reconstruct(referenceMap, classFile, list);
        ClassFileAnalyzer.removeUnusedPopInstruction(list);
        ClassFileAnalyzer.transformTestOnLongOrDouble(list);
        ClassFileAnalyzer.setConstantTypeInStringIndexOfMethods(classFile, list);
        DupStoreThisReconstructor.reconstruct(list);
        AssignmentInstructionReconstructor.reconstruct(list);
        CheckCastAndConvertInstructionVisitor.visit(classFile, method, list);
        DotNewReconstructor.reconstruct(classFile, list);
        DotSuperReconstructor.reconstruct(classFile, list);
        ArrayList<Instruction> fastList = new ArrayList<Instruction>(list);
        method.setFastNodes(fastList);
        FastInstructionListBuilder.build(referenceMap, classFile, method, fastList);
        DupLocalVariableAnalyzer.declare(classFile, method, fastList);
    }

    public static void postAnalyzeSingleMethod(ClassFile classFile, Method method) {
        try {
            ClassFileAnalyzer.analyseAndModifyConstructors(classFile, method);
            ReturnLineNumberAnalyzer.check(method);
            ClassFileAnalyzer.removeLastReturnInstruction(method);
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            method.setContainsError(true);
        }
    }

    private static int searchOuterThisFieldrefIndex(ClassFile classFile, Method method, List<Instruction> list, int outerThisFieldrefIndex) {
        if (!classFile.isAInnerClass() || (classFile.getAccessFlags() & 8) != 0) {
            return 0;
        }
        ConstantPool constants = classFile.getConstantPool();
        if (method.getNameIndex() != constants.getInstanceConstructorIndex()) {
            return outerThisFieldrefIndex;
        }
        String methodSignature = constants.getConstantUtf8(method.getSignatureIndex());
        if (methodSignature.charAt(1) == ')') {
            return 0;
        }
        for (Instruction instruction : list) {
            ConstantNameAndType cnat;
            Invokespecial is;
            ConstantCP cmr;
            if (instruction.getOpcode() == 181) {
                PutField pf = (PutField)instruction;
                if (pf.getObjectref().getOpcode() != 25 || pf.getValueref().getOpcode() != 25 || ((ALoad)pf.getObjectref()).getIndex() != 0 || ((ALoad)pf.getValueref()).getIndex() != 1 || outerThisFieldrefIndex != 0 && pf.getIndex() != outerThisFieldrefIndex) continue;
                return pf.getIndex();
            }
            if (instruction.getOpcode() != 183 || (cmr = constants.getConstantMethodref((is = (Invokespecial)instruction).getIndex())).getClassIndex() != classFile.getThisClassIndex() || (cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex())).getNameIndex() != constants.getInstanceConstructorIndex()) continue;
            return outerThisFieldrefIndex;
        }
        return 0;
    }

    private static void analyzeOuterReferences(ClassFile classFile, int outerThisFieldrefIndex) {
        int n;
        Method[] methods = classFile.getMethods();
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(outerThisFieldrefIndex);
        if (cfr.getClassIndex() == classFile.getThisClassIndex()) {
            ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            Field[] fieldArray = classFile.getFields();
            n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getNameIndex() == cnat.getNameIndex() && field.getDescriptorIndex() == cnat.getSignatureIndex()) {
                    classFile.setOuterThisField(field);
                    field.setAccessFlags(field.getAccessFlags() | 0x1000);
                    break;
                }
                ++n2;
            }
        }
        Method[] methodArray = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            List<Instruction> list;
            Method method = methodArray[n];
            if (method.getCode() != null && !method.containsError() && (list = method.getInstructions()) != null) {
                int listLength = list.size();
                if (method.getNameIndex() == constants.getInstanceConstructorIndex()) {
                    int index = 0;
                    while (index < listLength) {
                        Instruction instruction = list.get(index);
                        if (instruction.getOpcode() == 181 && ((PutField)instruction).getIndex() == outerThisFieldrefIndex) {
                            list.remove(index);
                            break;
                        }
                        ++index;
                    }
                }
            }
            ++n;
        }
    }

    private static void analyseAndModifyConstructors(ClassFile classFile, Method method) {
        ConstantPool constants = classFile.getConstantPool();
        if (method.getNameIndex() == constants.getInstanceConstructorIndex()) {
            List<Instruction> list = method.getFastNodes();
            while (!list.isEmpty()) {
                IndexInstruction ii;
                PutField pf;
                Instruction instruction = list.get(0);
                if (instruction.getOpcode() == 183) {
                    ConstantCP cmr;
                    ConstantNameAndType cnat;
                    Invokespecial is = (Invokespecial)instruction;
                    if (is.getObjectref().getOpcode() == 25 && ((ALoad)is.getObjectref()).getIndex() == 0 && (cnat = constants.getConstantNameAndType((cmr = constants.getConstantMethodref(is.getIndex())).getNameAndTypeIndex())).getNameIndex() == constants.getInstanceConstructorIndex()) {
                        String signature;
                        if (cmr.getClassIndex() != classFile.getSuperClassIndex()) break;
                        List<Instruction> args = is.getArgs();
                        int count = args.size();
                        method.setSuperConstructorParameterCount(count);
                        if ((classFile.getAccessFlags() & 0x4000) != 0) {
                            if (count != 2) break;
                            list.remove(0);
                            break;
                        }
                        if (count == 0) {
                            if (is.getPrefix() != null) break;
                            list.remove(0);
                            break;
                        }
                        if (count == 1 && args.get(0).getOpcode() == 1) {
                            String signature2 = constants.getConstantUtf8(cnat.getSignatureIndex());
                            if (!signature2.endsWith("$1;)V")) break;
                            list.remove(0);
                            break;
                        }
                        if (args.get(0).getOpcode() != 285) break;
                        GetStatic getStatic = (GetStatic)args.get(0);
                        ConstantFieldref fieldref = constants.getConstantFieldref(getStatic.getIndex());
                        int nameAndTypeIndex = fieldref.getNameAndTypeIndex();
                        ConstantNameAndType nameAndType = constants.getConstantNameAndType(nameAndTypeIndex);
                        String name = constants.getConstantUtf8(nameAndType.getNameIndex());
                        String suffix = "$" + classFile.getClassName() + ";";
                        String internalName = classFile.getInternalClassName();
                        if (count == 1 && "this".equals(name) && internalName.endsWith(suffix)) {
                            list.remove(0);
                            break;
                        }
                        if (count <= 1 || args.get(count - 1).getOpcode() != 1 || !(signature = constants.getConstantUtf8(cnat.getSignatureIndex())).endsWith("$1;)V")) break;
                        list.remove(0);
                        break;
                    }
                } else if (instruction.getOpcode() == 181 && ((pf = (PutField)instruction).getValueref().getOpcode() == 268 || pf.getValueref().getOpcode() == 25 || pf.getValueref().getOpcode() == 21) && (ii = (IndexInstruction)pf.getValueref()).getIndex() > 1) {
                    ConstantFieldref cfr = constants.getConstantFieldref(pf.getIndex());
                    ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                    Field field = classFile.getField(cnat.getNameIndex(), cnat.getSignatureIndex());
                    field.setAnonymousClassConstructorParameterIndex(ii.getIndex() - 1);
                    field.setAccessFlags(field.getAccessFlags() | 0x1000);
                }
                list.remove(0);
            }
        }
    }

    private static void removeLastReturnInstruction(Method method) {
        int length;
        List<Instruction> list = method.getFastNodes();
        if (list != null && (length = list.size()) > 0) {
            FastLabel fl;
            int lastOpCode = list.get(length - 1).getOpcode();
            if (lastOpCode == 177) {
                list.remove(length - 1);
            } else if (lastOpCode == 320 && (fl = (FastLabel)list.get(length - 1)).getInstruction().getOpcode() == 177) {
                fl.setInstruction(null);
            }
        }
    }

    public static void replaceStringBufferAndStringBuilder(ClassFile classFile, LocalVariables localVariables, List<Instruction> list) {
        new ReplaceStringBuxxxerVisitor(classFile, localVariables).visit(list);
    }

    private static void removeUnusedPopInstruction(List<Instruction> list) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            if (instruction.getOpcode() != 87 || ((Pop)instruction).getObjectref().getOpcode() != 180 && ((Pop)instruction).getObjectref().getOpcode() != 178 && ((Pop)instruction).getObjectref().getOpcode() != 285 && ((Pop)instruction).getObjectref().getOpcode() != 25 && ((Pop)instruction).getObjectref().getOpcode() != 21 && ((Pop)instruction).getObjectref().getOpcode() != 268) continue;
            list.remove(index);
        }
    }

    private static void transformTestOnLongOrDouble(List<Instruction> list) {
        int index = list.size();
        while (index-- > 0) {
            BinaryOperatorInstruction boi;
            IfInstruction ii;
            Instruction instruction = list.get(index);
            if (instruction.getOpcode() != 260 || (ii = (IfInstruction)instruction).getCmp() != 0 && ii.getCmp() != 7 && ii.getCmp() != 1 && ii.getCmp() != 6 && ii.getCmp() != 2 && ii.getCmp() != 5 || ii.getValue().getOpcode() != 267 || !"<".equals((boi = (BinaryOperatorInstruction)ii.getValue()).getOperator())) continue;
            list.set(index, new IfCmp(261, ii.getOffset(), ii.getLineNumber(), ii.getCmp(), boi.getValue1(), boi.getValue2(), ii.getBranch()));
        }
    }

    private static void setConstantTypeInStringIndexOfMethods(ClassFile classFile, List<Instruction> list) {
        SetConstantTypeInStringIndexOfMethodsVisitor visitor = new SetConstantTypeInStringIndexOfMethodsVisitor(classFile.getConstantPool());
        visitor.visit(list);
    }

    private static void analyzeEnum(ClassFile classFile) {
        ConstantPool constants = classFile.getConstantPool();
        String enumArraySignature = "[" + classFile.getInternalClassName();
        Field[] fieldArray = classFile.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getAccessFlags() & 0x5000) != 0 && field.getValueAndMethod() != null) {
                Instruction instruction = field.getValueAndMethod().value();
                if (instruction instanceof Invokestatic var9_9) {
                    ConstantCP cmr = constants.getConstantMethodref(is.getIndex());
                    ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(cnat.getNameIndex());
                    String signature = constants.getConstantUtf8(cnat.getSignatureIndex());
                    Method method = classFile.getMethod(name, signature);
                    InitArrayInstructionReconstructor.reconstruct(method.getInstructions());
                    ReturnInstruction returnInstruction = (ReturnInstruction)method.getInstructions().get(0);
                    instruction = returnInstruction.getValueref();
                }
                if ((instruction.getOpcode() == 282 || instruction.getOpcode() == 283) && constants.getConstantUtf8(field.getDescriptorIndex()).equals(enumArraySignature) && ("$VALUES".equals(fieldName = constants.getConstantUtf8(field.getNameIndex())) || "ENUM$VALUES".equals(fieldName))) {
                    classFile.setEnumValues(((InitArrayInstruction)instruction).getValues());
                    break;
                }
            }
            ++n2;
        }
    }

    private static /* synthetic */ List lambda$0(String k) {
        return new ArrayList(5);
    }
}

