/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.accessor.GetFieldAccessor;
import jd.core.model.classfile.accessor.GetStaticAccessor;
import jd.core.model.classfile.accessor.IncGetFieldAccessor;
import jd.core.model.classfile.accessor.IncGetStaticAccessor;
import jd.core.model.classfile.accessor.InvokeMethodAccessor;
import jd.core.model.classfile.accessor.PutFieldAccessor;
import jd.core.model.classfile.accessor.PutStaticAccessor;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public final class AccessorAnalyzer {
    private AccessorAnalyzer() {
    }

    public static void analyze(ClassFile classFile, Method method) {
        if (AccessorAnalyzer.searchGetStaticAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.searchPutStaticAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.searchIncGetFieldAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.searchIncGetStaticAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.searchGetFieldAccessor(classFile, method)) {
            return;
        }
        if (AccessorAnalyzer.searchPutFieldAccessor(classFile, method)) {
            return;
        }
        AccessorAnalyzer.searchInvokeMethodAccessor(classFile, method);
    }

    private static boolean searchGetStaticAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.getOpcode() != 273) {
            return false;
        }
        if ((instruction = ((ReturnInstruction)instruction).getValueref()).getOpcode() != 178) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)instruction).getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) != ')') {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new GetStaticAccessor(1, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean searchPutStaticAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 2) {
            return false;
        }
        if (list.get(1).getOpcode() != 273 && list.get(1).getOpcode() != 177) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.getOpcode() != 179) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((PutStatic)instruction).getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.getParameterSignatureCount(methodDescriptor) != 1) {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new PutStaticAccessor(2, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean searchGetFieldAccessor(ClassFile classFile, Method method) {
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.getOpcode() != 273) {
            return false;
        }
        if ((instruction = ((ReturnInstruction)instruction).getValueref()).getOpcode() != 180) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(((GetField)instruction).getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.getParameterSignatureCount(methodDescriptor) != 1) {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new GetFieldAccessor(3, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean searchIncGetFieldAccessor(ClassFile classFile, Method method) {
        void inc;
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.getOpcode() != 273) {
            return false;
        }
        Instruction instruction2 = instruction = ((ReturnInstruction)instruction).getValueref();
        if (!(instruction2 instanceof IncInstruction var4_5)) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        if (!(inc.getValue() instanceof GetField)) {
            return false;
        }
        ConstantFieldref cfr = constants.getConstantFieldref(((GetField)inc.getValue()).getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.getParameterSignatureCount(methodDescriptor) != 1) {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new IncGetFieldAccessor(6, classFile.getThisClassName(), fieldName, fieldDescriptor, inc.getCount(), inc.getOpcode()));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean searchIncGetStaticAccessor(ClassFile classFile, Method method) {
        void inc;
        List<Instruction> list = method.getInstructions();
        if (list.size() != 1) {
            return false;
        }
        Instruction instruction = list.get(0);
        if (instruction.getOpcode() != 273) {
            return false;
        }
        Instruction instruction2 = instruction = ((ReturnInstruction)instruction).getValueref();
        if (!(instruction2 instanceof IncInstruction var4_5)) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        if (!(inc.getValue() instanceof GetStatic)) {
            return false;
        }
        ConstantFieldref cfr = constants.getConstantFieldref(((GetStatic)inc.getValue()).getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) != ')') {
            return false;
        }
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new IncGetStaticAccessor(7, classFile.getThisClassName(), fieldName, fieldDescriptor, inc.getCount(), inc.getOpcode()));
        return true;
    }

    private static boolean searchPutFieldAccessor(ClassFile classFile, Method method) {
        PutField pf;
        List<Instruction> list = method.getInstructions();
        switch (list.size()) {
            case 2: {
                if (list.get(1).getOpcode() != 177) {
                    return false;
                }
                Instruction instruction = list.get(0);
                if (instruction.getOpcode() != 181) {
                    return false;
                }
                pf = (PutField)instruction;
                break;
            }
            case 3: {
                if (list.get(0).getOpcode() != 264) {
                    return false;
                }
                if (list.get(2).getOpcode() != 273) {
                    return false;
                }
                Instruction instruction = list.get(1);
                if (instruction.getOpcode() != 181) {
                    return false;
                }
                pf = (PutField)instruction;
                break;
            }
            default: {
                return false;
            }
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantFieldref cfr = constants.getConstantFieldref(pf.getIndex());
        if (cfr.getClassIndex() != classFile.getThisClassIndex()) {
            return false;
        }
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        if (methodDescriptor.charAt(1) == ')') {
            return false;
        }
        if (SignatureUtil.getParameterSignatureCount(methodDescriptor) != 2) {
            return false;
        }
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        classFile.addAccessor(methodName, methodDescriptor, new PutFieldAccessor(4, classFile.getThisClassName(), fieldName, fieldDescriptor));
        return true;
    }

    private static boolean searchInvokeMethodAccessor(ClassFile classFile, Method method) {
        InvokeInstruction ii;
        Instruction instruction;
        List<Instruction> list = method.getInstructions();
        switch (list.size()) {
            case 1: {
                instruction = list.get(0);
                if (instruction.getOpcode() != 273) {
                    return false;
                }
                instruction = ((ReturnInstruction)instruction).getValueref();
                break;
            }
            case 2: {
                instruction = list.get(1);
                if (instruction.getOpcode() != 177) {
                    return false;
                }
                instruction = list.get(0);
                break;
            }
            default: {
                return false;
            }
        }
        switch (instruction.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (insi.getObjectref().getOpcode() != 25 || ((ALoad)insi.getObjectref()).getIndex() != 0) {
                    return false;
                }
                ii = insi;
                break;
            }
            case 184: {
                ii = (InvokeInstruction)instruction;
                break;
            }
            default: {
                return false;
            }
        }
        ConstantPool constants = classFile.getConstantPool();
        String methodName = constants.getConstantUtf8(method.getNameIndex());
        String methodDescriptor = constants.getConstantUtf8(method.getDescriptorIndex());
        ConstantCP cmr = constants.getConstantMethodref(ii.getIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String targetMethodName = constants.getConstantUtf8(cnat.getNameIndex());
        String targetMethodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        classFile.addAccessor(methodName, methodDescriptor, new InvokeMethodAccessor(5, classFile.getThisClassName(), ii.getOpcode(), targetMethodName, targetMethodDescriptor));
        return true;
    }
}

