/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process;

import java.io.IOException;
import java.util.ArrayList;
import jd.core.Decompiler;
import jd.core.model.classfile.ClassFile;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.model.reference.ReferenceMap;
import jd.core.preferences.Preferences;
import jd.core.printer.Printer;
import jd.core.process.analyzer.classfile.ClassFileAnalyzer;
import jd.core.process.analyzer.classfile.ReferenceAnalyzer;
import jd.core.process.deserializer.ClassFileDeserializer;
import jd.core.process.layouter.ClassFileLayouter;
import jd.core.process.writer.ClassFileWriter;
import org.jd.core.v1.api.loader.Loader;

public class DecompilerImpl
implements Decompiler {
    @Override
    public synchronized void decompile(Preferences preferences, Loader loader, Printer printer, String internalClassPath) throws IOException {
        ClassFile classFile = ClassFileDeserializer.deserialize(loader, internalClassPath);
        if (classFile == null) {
            throw new IOException("Can not deserialize '" + internalClassPath + "'.");
        }
        ReferenceMap referenceMap = new ReferenceMap();
        ClassFileAnalyzer.analyze(referenceMap, classFile);
        ReferenceAnalyzer.analyze(referenceMap, classFile);
        ArrayList<LayoutBlock> layoutBlockList = new ArrayList<LayoutBlock>(1024);
        int maxLineNumber = ClassFileLayouter.layout(preferences, referenceMap, classFile, layoutBlockList);
        ClassFileWriter.write(loader, printer, referenceMap, maxLineNumber, classFile.getMajorVersion(), classFile.getMinorVersion(), layoutBlockList);
    }
}

