/*
 * Decompiled with CFR 0.152.
 */
package jd.core.printer;

import java.util.HashMap;
import java.util.Map;
import jd.core.DecompilationResult;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import jd.core.links.StringData;
import jd.core.preferences.Preferences;
import jd.core.printer.PlainTextPrinter;

public class PrinterImpl
extends PlainTextPrinter {
    private final Map<String, ReferenceData> referencesCache = new HashMap<String, ReferenceData>();
    private final DecompilationResult result = new DecompilationResult();
    private final boolean realignmentLineNumber;
    private int textAreaLineNumber = 1;

    public PrinterImpl(Preferences preferences) {
        this.setPreferences(preferences);
        this.realignmentLineNumber = preferences.getRealignmentLineNumber();
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        super.start(maxLineNumber, majorVersion, minorVersion);
        if (maxLineNumber != 0) {
            this.result.setMaxLineNumber(maxLineNumber);
        }
    }

    @Override
    public void startOfLine(int sourceLineNumber) {
        super.startOfLine(sourceLineNumber);
        this.result.putLineNumber(this.textAreaLineNumber, sourceLineNumber);
    }

    @Override
    public void endOfLine() {
        super.endOfLine();
        ++this.textAreaLineNumber;
    }

    @Override
    public void extraLine(int count) {
        super.extraLine(count);
        if (this.realignmentLineNumber && count > 0) {
            this.textAreaLineNumber += count;
        }
    }

    @Override
    public void printString(String s, String scopeInternalName) {
        this.result.addString(new StringData(this.length(), s, scopeInternalName));
        super.printString(s, scopeInternalName);
    }

    @Override
    public void printTypeImport(String internalName, String name) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, null, null, null)));
        super.printTypeImport(internalName, name);
    }

    @Override
    public void printType(String internalName, String name, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, null, null, scopeInternalName)));
        super.printType(internalName, name, scopeInternalName);
    }

    @Override
    public void printField(String internalName, String name, String descriptor, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, name, descriptor, scopeInternalName)));
        super.printField(internalName, name, descriptor, scopeInternalName);
    }

    @Override
    public void printStaticField(String internalName, String name, String descriptor, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, name, descriptor, scopeInternalName)));
        super.printStaticField(internalName, name, descriptor, scopeInternalName);
    }

    @Override
    public void printConstructor(String internalName, String name, String descriptor, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, "<init>", descriptor, scopeInternalName)));
        super.printConstructor(internalName, name, descriptor, scopeInternalName);
    }

    @Override
    public void printMethod(String internalName, String name, String descriptor, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, name, descriptor, scopeInternalName)));
        super.printMethod(internalName, name, descriptor, scopeInternalName);
    }

    @Override
    public void printStaticMethod(String internalName, String name, String descriptor, String scopeInternalName) {
        this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.length(), name.length(), this.newReferenceData(internalName, name, descriptor, scopeInternalName)));
        super.printStaticMethod(internalName, name, descriptor, scopeInternalName);
    }

    public void addHyperlink(HyperlinkData hyperlinkData) {
        this.result.addHyperLink(hyperlinkData.getStartPosition(), hyperlinkData);
    }

    public ReferenceData newReferenceData(String internalName, String name, String descriptor, String scopeInternalName) {
        String key = String.valueOf(internalName) + '-' + name + '-' + descriptor + '-' + scopeInternalName;
        return this.referencesCache.computeIfAbsent(key, k -> {
            ReferenceData reference = new ReferenceData(internalName, name, descriptor, scopeInternalName);
            this.result.addReference(reference);
            return reference;
        });
    }

    @Override
    public void printTypeDeclaration(String internalName, String name) {
        DeclarationData data = new DeclarationData(this.length(), name.length(), internalName, null, null);
        this.result.addDeclaration(internalName, data);
        this.result.addTypeDeclaration(this.length(), data);
        super.printTypeDeclaration(internalName, name);
    }

    @Override
    public void printFieldDeclaration(String internalName, String name, String descriptor) {
        this.result.addDeclaration(String.valueOf(internalName) + '-' + name + '-' + descriptor, new DeclarationData(this.length(), name.length(), internalName, name, descriptor));
        super.printFieldDeclaration(internalName, name, descriptor);
    }

    @Override
    public void printStaticFieldDeclaration(String internalName, String name, String descriptor) {
        this.result.addDeclaration(String.valueOf(internalName) + '-' + name + '-' + descriptor, new DeclarationData(this.length(), name.length(), internalName, name, descriptor));
        super.printStaticFieldDeclaration(internalName, name, descriptor);
    }

    @Override
    public void printConstructorDeclaration(String internalName, String name, String descriptor) {
        this.result.addDeclaration(String.valueOf(internalName) + "-<init>-" + descriptor, new DeclarationData(this.length(), name.length(), internalName, "<init>", descriptor));
        super.printConstructorDeclaration(internalName, name, descriptor);
    }

    @Override
    public void printStaticConstructorDeclaration(String internalName, String name) {
        this.result.addDeclaration(String.valueOf(internalName) + "-<clinit>-()V", new DeclarationData(this.length(), name.length(), internalName, "<clinit>", "()V"));
        super.printStaticConstructorDeclaration(internalName, name);
    }

    @Override
    public void printMethodDeclaration(String internalName, String name, String descriptor) {
        this.result.addDeclaration(String.valueOf(internalName) + '-' + name + '-' + descriptor, new DeclarationData(this.length(), name.length(), internalName, name, descriptor));
        super.printMethodDeclaration(internalName, name, descriptor);
    }

    @Override
    public void printStaticMethodDeclaration(String internalName, String name, String descriptor) {
        this.result.addDeclaration(String.valueOf(internalName) + '-' + name + '-' + descriptor, new DeclarationData(this.length(), name.length(), internalName, name, descriptor));
        super.printStaticMethodDeclaration(internalName, name, descriptor);
    }

    public DecompilationResult getResult() {
        return this.result;
    }
}

