/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.reference;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jd.core.model.reference.Reference;

public class ReferenceMap {
    private final Map<String, Reference> references = new HashMap<String, Reference>();
    private final Map<String, String> simpleNameToInternalName = new HashMap<String, String>();

    public void add(String internalName) {
        if (internalName.indexOf(59) != -1) {
            System.err.println("ReferenceMap.add: InvalidParameterException(" + internalName + ")");
        } else {
            Reference ref = this.references.get(internalName);
            if (ref == null) {
                this.references.put(internalName, new Reference(internalName));
                int lastIndexOfSlash = internalName.lastIndexOf(47);
                int lastIndexOfDollar = internalName.lastIndexOf(36);
                if (lastIndexOfDollar != -1) {
                    this.simpleNameToInternalName.put(internalName.substring(lastIndexOfDollar + 1), internalName);
                } else {
                    this.simpleNameToInternalName.put(internalName.substring(lastIndexOfSlash + 1), internalName);
                }
            } else {
                ref.incCounter();
            }
        }
    }

    public Reference remove(String internalName) {
        return this.references.remove(internalName);
    }

    public Collection<Reference> values() {
        return this.references.values();
    }

    public boolean contains(String internalName) {
        return this.references.containsKey(internalName);
    }

    public String getSimpleNameClashWith(String internalName) {
        String importedInternalName;
        String importedInternalName2;
        int lastIndexOfDollar = internalName.lastIndexOf(36);
        if (lastIndexOfDollar != -1 && (importedInternalName2 = this.simpleNameToInternalName.get(internalName.substring(lastIndexOfDollar + 1))) != null && !internalName.equals(importedInternalName2)) {
            return importedInternalName2;
        }
        int lastIndexOfSlash = internalName.lastIndexOf(47);
        if (lastIndexOfSlash != -1 && (importedInternalName = this.simpleNameToInternalName.get(internalName.substring(lastIndexOfSlash + 1))) != null && !internalName.equals(importedInternalName)) {
            return importedInternalName;
        }
        return null;
    }
}

