/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.layout.section;

public class LayoutSection
implements Comparable<LayoutSection> {
    private final int index;
    private int firstBlockIndex;
    private int lastBlockIndex;
    private final int originalLineCount;
    private boolean relayout;
    private int score;
    private final boolean containsError;

    public LayoutSection(int index, int firstBlockIndex, int lastBlockIndex, int firstLineNumber, int lastLineNumber, boolean containsError) {
        this.index = index;
        this.setFirstBlockIndex(firstBlockIndex);
        this.setLastBlockIndex(lastBlockIndex);
        this.originalLineCount = lastLineNumber - firstLineNumber;
        this.setRelayout(true);
        this.setScore(0);
        this.containsError = containsError;
    }

    @Override
    public int compareTo(LayoutSection o) {
        return o.getScore() - this.getScore();
    }

    public int hashCode() {
        return this.score;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((LayoutSection)obj) == 0;
    }

    public int getOriginalLineCount() {
        return this.originalLineCount;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public boolean isRelayout() {
        return this.relayout;
    }

    public void setRelayout(boolean relayout) {
        this.relayout = relayout;
    }

    public int getFirstBlockIndex() {
        return this.firstBlockIndex;
    }

    public void setFirstBlockIndex(int firstBlockIndex) {
        this.firstBlockIndex = firstBlockIndex;
    }

    public int getLastBlockIndex() {
        return this.lastBlockIndex;
    }

    public void setLastBlockIndex(int lastBlockIndex) {
        this.lastBlockIndex = lastBlockIndex;
    }

    public boolean containsError() {
        return this.containsError;
    }

    public int getIndex() {
        return this.index;
    }
}

