/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.fast.instruction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastList;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;

public class FastTry
extends FastList {
    private final List<FastCatch> catches;
    private final List<Instruction> finallyInstructions;
    private final List<Instruction> resources;

    public FastTry(int opcode, int offset, int lineNumber, int branch, List<Instruction> instructions, List<FastCatch> catches, List<Instruction> finallyInstructions) {
        super(opcode, offset, lineNumber, branch, instructions);
        this.catches = catches;
        this.finallyInstructions = finallyInstructions;
        this.resources = new ArrayList<Instruction>();
    }

    public List<FastCatch> getCatches() {
        return this.catches;
    }

    public List<Instruction> getFinallyInstructions() {
        return this.finallyInstructions;
    }

    public void removeOutOfBounds() {
        if (this.getInstructions().isEmpty()) {
            return;
        }
        int firstLineNumber = ((Instruction)this.instructions.get(0)).getLineNumber();
        for (Instruction instruction : this.instructions) {
            if (!(instruction instanceof FastTry var4_4)) continue;
            fastTry.removeOutOfBounds();
            if (fastTry.getInstructions().isEmpty()) continue;
            fastTry.cleanUpCatches(fastTry.getInstructions().get(0).getLineNumber());
        }
        this.cleanUpCatches(firstLineNumber);
    }

    private void cleanUpCatches(int firstLineNumber) {
        Iterator<FastCatch> iterator = this.catches.iterator();
        while (iterator.hasNext()) {
            FastCatch fastCatch = iterator.next();
            if (!fastCatch.removeOutOfBounds(firstLineNumber) || !fastCatch.instructions().isEmpty()) continue;
            iterator.remove();
        }
    }

    public boolean removeTryResourcesPattern(LocalVariables localVariables, ConstantPool cp, List<Instruction> instructions) {
        if (instructions == null || instructions.size() < 4) {
            return false;
        }
        int i = instructions.size() - 1;
        while (i >= 3) {
            Instruction firstInstruction = instructions.get(i - 3);
            int firstLineNumber = firstInstruction.getLineNumber();
            if (!instructions.subList(i - 3, i).stream().anyMatch(instr -> instr.getLineNumber() != firstLineNumber) && firstInstruction instanceof IfInstruction && instructions.get(i - 2) instanceof IfInstruction && instructions.get(i - 1) instanceof FastTry && instructions.get(i) instanceof InvokeNoStaticInstruction) {
                Invokevirtual catchInstruction;
                IfInstruction firstIf = (IfInstruction)firstInstruction;
                IfInstruction secondIf = (IfInstruction)instructions.get(i - 2);
                FastTry fastTry = (FastTry)instructions.get(i - 1);
                InvokeNoStaticInstruction invokeNoStaticInstruction = (InvokeNoStaticInstruction)instructions.get(i);
                if (firstIf.getValue() instanceof ALoad && invokeNoStaticInstruction.getObjectref() instanceof ALoad && ((ALoad)firstIf.getValue()).getIndex() == ((ALoad)invokeNoStaticInstruction.getObjectref()).getIndex() && fastTry.getInstructions() != null && fastTry.getInstructions().size() == 1 && fastTry.getCatches() != null && fastTry.getCatches().size() == 1 && fastTry.getCatches().get(0).instructions() != null && fastTry.getCatches().get(0).instructions().size() == 1 && fastTry.getCatches().get(0).instructions().get(0) instanceof Invokevirtual && (catchInstruction = (Invokevirtual)fastTry.getCatches().get(0).instructions().get(0)).getObjectref() instanceof ALoad) {
                    InvokeNoStaticInstruction tryInstruction;
                    ALoad aLoad2 = (ALoad)catchInstruction.getObjectref();
                    if (((ALoad)secondIf.getValue()).getIndex() == aLoad2.getIndex() && fastTry.getInstructions().get(0) instanceof InvokeNoStaticInstruction && (tryInstruction = (InvokeNoStaticInstruction)fastTry.getInstructions().get(0)).getObjectref() instanceof ALoad) {
                        ALoad aLoad1 = (ALoad)tryInstruction.getObjectref();
                        if (((ALoad)firstIf.getValue()).getIndex() == aLoad1.getIndex()) {
                            LocalVariable lv1 = localVariables.getLocalVariableWithIndexAndOffset(aLoad1.getIndex(), aLoad1.getOffset());
                            LocalVariable lv2 = localVariables.getLocalVariableWithIndexAndOffset(aLoad2.getIndex(), aLoad2.getOffset());
                            lv1.setTryResources(this);
                            ConstantCP catchInstructionMethodref = cp.getConstantMethodref(catchInstruction.getIndex());
                            ConstantClass catchInstructionClass = cp.getConstantClass(catchInstructionMethodref.getClassIndex());
                            ConstantNameAndType catchInstructionMethod = cp.getConstantNameAndType(catchInstructionMethodref.getNameAndTypeIndex());
                            String catchInstructionMethodName = cp.getConstantUtf8(catchInstructionMethod.getNameIndex());
                            String catchInstructionMethodDesc = cp.getConstantUtf8(catchInstructionMethod.getSignatureIndex());
                            String catchInstructionClassName = cp.getConstantUtf8(catchInstructionClass.getNameIndex());
                            if ("java/lang/Throwable".equals(catchInstructionClassName) && "addSuppressed".equals(catchInstructionMethodName) && "(Ljava/lang/Throwable;)V".equals(catchInstructionMethodDesc)) {
                                lv2.setThrowableFromTryResources(true);
                                if (lv2.isExceptionOrThrowable(cp)) {
                                    lv2.setToBeRemoved(true);
                                }
                            }
                            instructions.remove(i);
                            instructions.remove(i - 1);
                            instructions.remove(i - 2);
                            instructions.remove(i - 3);
                            return true;
                        }
                    }
                }
            }
            --i;
        }
        return false;
    }

    public void addResource(StoreInstruction si, LocalVariable lv) {
        this.resources.add(new FastDeclaration(si.getOffset(), si.getLineNumber(), lv, si));
        lv.setDeclarationFlag(true);
    }

    public List<Instruction> getResources() {
        return this.resources;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processTryResources() {
        void fastTry;
        FastTry fastTry2;
        Iterator<Instruction> iterator;
        Instruction instruction;
        Instruction instruction2;
        boolean processed = false;
        List<Instruction> instructions = this.getInstructions();
        if (instructions.size() == 1 && (instruction2 = (instruction = (iterator = instructions.iterator()).next())) instanceof FastTry && (fastTry2 = (FastTry)instruction2) == (FastTry)instruction2 && fastTry.isResourceOnly()) {
            iterator.remove();
            this.resources.addAll(fastTry.getResources());
            instructions.addAll(fastTry.getInstructions());
            processed = true;
        }
        return processed;
    }

    public void removeOutOfBoundsInstructions(int maxLineNumber) {
        if (maxLineNumber <= 0) {
            return;
        }
        this.instructions.removeIf(tryInstr -> tryInstr.getLineNumber() >= maxLineNumber);
        for (Instruction instruction : this.instructions) {
            if (!(instruction instanceof FastTry var4_4)) continue;
            nestedTry.removeOutOfBoundsInstructions(maxLineNumber);
        }
        for (FastCatch fastCatch : this.catches) {
            fastCatch.instructions().removeIf(catchInstr -> catchInstr.getLineNumber() >= maxLineNumber);
        }
    }

    public boolean isResourceOnly() {
        return this.hasResource() && !this.hasCatch() && !this.hasFinally();
    }

    public boolean hasResource() {
        return !this.resources.isEmpty();
    }

    public boolean hasFinally() {
        return this.finallyInstructions != null && !this.finallyInstructions.isEmpty();
    }

    public boolean hasCatch() {
        return this.catches != null && !this.catches.isEmpty();
    }

    public static class FastCatch {
        int exceptionOffset;
        int exceptionTypeIndex;
        int[] otherExceptionTypeIndexes;
        int localVarIndex;
        List<Instruction> instructions;

        public FastCatch(int exceptionOffset, int exceptionTypeIndex, int[] otherExceptionTypeIndexes, int localVarIndex, List<Instruction> instructions) {
            this.exceptionOffset = exceptionOffset;
            this.exceptionTypeIndex = exceptionTypeIndex;
            this.otherExceptionTypeIndexes = otherExceptionTypeIndexes;
            this.localVarIndex = localVarIndex;
            this.instructions = instructions;
        }

        public boolean removeOutOfBounds(int firstLineNumber) {
            return this.instructions.removeIf(instr -> instr.getLineNumber() < firstLineNumber);
        }

        public int localVarIndex() {
            return this.localVarIndex;
        }

        public int exceptionOffset() {
            return this.exceptionOffset;
        }

        public int exceptionTypeIndex() {
            return this.exceptionTypeIndex;
        }

        public List<Instruction> instructions() {
            return this.instructions;
        }

        public int[] otherExceptionTypeIndexes() {
            return this.otherExceptionTypeIndexes;
        }
    }
}

