/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.fast.instruction;

import java.util.List;
import java.util.Objects;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByTypeVisitor;

public class FastSwitch
extends BranchInstruction {
    private Instruction test;
    private final Pair[] pairs;

    public FastSwitch(int opcode, int offset, int lineNumber, int branch, Instruction test, Pair[] pairs) {
        super(opcode, offset, lineNumber, branch);
        this.setTest(test);
        this.pairs = pairs;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return null;
    }

    public Pair[] getPairs() {
        return this.pairs;
    }

    public Pair getPair(int i) {
        return this.pairs[i];
    }

    public Instruction getTest() {
        return this.test;
    }

    public void setTest(Instruction test) {
        this.test = test;
    }

    public static class Pair
    implements Comparable<Pair> {
        private final boolean defaultFlag;
        private int key;
        private final int offset;
        private List<Instruction> instructions;

        public Pair(boolean defaultFlag, int key, int offset) {
            this.defaultFlag = defaultFlag;
            this.key = key;
            this.offset = offset;
            this.instructions = null;
        }

        public boolean isDefault() {
            return this.defaultFlag;
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public int getOffset() {
            return this.offset;
        }

        public List<Instruction> getInstructions() {
            return this.instructions;
        }

        public void setInstructions(List<Instruction> instructions) {
            this.instructions = instructions;
        }

        @Override
        public int compareTo(Pair p) {
            int diffOffset = this.offset - p.offset;
            if (diffOffset != 0) {
                return diffOffset;
            }
            if (this.isDefault()) {
                return 1;
            }
            if (p.isDefault()) {
                return -1;
            }
            return this.key - p.key;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((Pair)obj) == 0;
        }

        public boolean hasDeclaration() {
            SearchInstructionByTypeVisitor<FastDeclaration> visitor = new SearchInstructionByTypeVisitor<FastDeclaration>(FastDeclaration.class);
            for (Instruction i : this.instructions) {
                FastDeclaration fd = visitor.visit(i);
                if (fd == null) continue;
                return true;
            }
            return false;
        }
    }
}

