/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.fast.instruction;

import java.util.Objects;
import java.util.Optional;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.Instruction;

public class FastDeclaration
extends Instruction {
    private final LocalVariable lv;
    private Instruction instruction;

    public FastDeclaration(int offset, int lineNumber, LocalVariable lv, Instruction instruction) {
        super(317, offset, lineNumber);
        this.lv = lv;
        this.setInstruction(instruction);
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        if (classFile == null) {
            return null;
        }
        return this.lv.getSignature(classFile.getConstantPool());
    }

    public int hashCode() {
        return Objects.hash(this.getLv().getIndex(), this.getLv().getNameIndex(), this.getLv().getSignatureIndex());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FastDeclaration other = (FastDeclaration)obj;
        return this.getLv().getIndex() == other.getLv().getIndex() && this.getLv().getNameIndex() == other.getLv().getNameIndex() && this.getLv().getSignatureIndex() == other.getLv().getSignatureIndex();
    }

    public LocalVariable getLv() {
        return this.lv;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    @Override
    public int getLastOffset() {
        return Optional.ofNullable(this.instruction).map(Instruction::getLastOffset).orElseGet(() -> super.getLastOffset());
    }
}

