/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.printer.Printer;
import jd.core.process.writer.SourceWriteable;
import jd.core.process.writer.visitor.SourceWriterVisitor;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;

public class StaticMethodReference
extends Instruction
implements SourceWriteable {
    private final ObjectTypeReferenceExpression objectType;
    private final String typeName;
    private final String name;
    private final String descriptor;

    public StaticMethodReference(int opcode, int offset, int lineNumber, ObjectTypeReferenceExpression objectType, String typeName, String name, String descriptor) {
        super(opcode, offset, lineNumber);
        this.objectType = objectType;
        this.typeName = typeName;
        this.name = name;
        this.descriptor = descriptor;
    }

    public ObjectTypeReferenceExpression getObjectType() {
        return this.objectType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return this.descriptor;
    }

    @Override
    public void write(Printer printer, SourceWriterVisitor visitor) {
        printer.print(this.objectType.getObjectType().getName());
        printer.print("::");
        printer.print(this.name);
    }

    @Override
    public String getInternalTypeName() {
        return this.typeName;
    }
}

