/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.util.SignatureUtil;

public class NewArray
extends Instruction {
    private final int type;
    private Instruction dimension;

    public NewArray(int opcode, int offset, int lineNumber, int type, Instruction dimension) {
        super(opcode, offset, lineNumber);
        this.type = type;
        this.setDimension(dimension);
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        String signature = SignatureUtil.getSignatureFromType(this.getType());
        return signature == null ? null : "[" + signature;
    }

    public int getType() {
        return this.type;
    }

    public Instruction getDimension() {
        return this.dimension;
    }

    public void setDimension(Instruction dimension) {
        this.dimension = dimension;
    }
}

