/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.printer.Printer;
import jd.core.process.writer.SourceWriteable;
import jd.core.process.writer.visitor.SourceWriterVisitor;

public class MethodReference
extends Instruction
implements SourceWriteable {
    private final List<Instruction> parameters;
    private final String internalTypeName;
    private final String name;
    private final String descriptor;

    public MethodReference(int opcode, int offset, int lineNumber, List<Instruction> parameters, String internalTypeName, String name, String descriptor) {
        super(opcode, offset, lineNumber);
        this.parameters = parameters;
        this.internalTypeName = internalTypeName;
        this.name = name;
        this.descriptor = descriptor;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return this.descriptor;
    }

    @Override
    public String getInternalTypeName() {
        return this.internalTypeName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public List<Instruction> getParameters() {
        return this.parameters;
    }

    @Override
    public void write(Printer printer, SourceWriterVisitor visitor) {
        if (!this.parameters.isEmpty()) {
            Instruction parameter = this.parameters.get(0);
            if (parameter instanceof ALoad var4_5) {
                visitor.visit((Instruction)aLoad);
            }
            if (parameter instanceof DupLoad var7_7) {
                visitor.visit(dupLoad.getDupStore().getObjectref());
            }
        }
        printer.print("::");
        printer.print(this.name);
    }
}

