/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;

public class LoadInstruction
extends IndexInstruction {
    private final String signature;

    public LoadInstruction(int opcode, int offset, int lineNumber, int index, String signature) {
        super(opcode, offset, lineNumber, index);
        this.signature = signature;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return this.signature;
    }

    protected String getReturnedSignature(ClassFile classFile, LocalVariables localVariables, String defaultSignature) {
        if (classFile == null || localVariables == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(this.getIndex(), this.getOffset());
        if (lv == null || lv.getSignatureIndex() < 0) {
            return defaultSignature;
        }
        return lv.getSignature(constants);
    }
}

