/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.deserializer.ClassFileDeserializer;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Signature;

public abstract class InvokeInstruction
extends IndexInstruction {
    private final List<Instruction> args;

    protected InvokeInstruction(int opcode, int offset, int lineNumber, int index, List<Instruction> args) {
        super(opcode, offset, lineNumber, index);
        this.args = args;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        Signature genericSignature;
        ClassFile javaClass;
        Method method;
        if (classFile == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        ConstantCP cmr = constants.getConstantMethodref(this.getIndex());
        String internalClassName = constants.getConstantClassName(cmr.getClassIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String methodName = constants.getConstantUtf8(cnat.getNameIndex());
        String methodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        String methodReturnedSignature = SignatureUtil.getMethodReturnedSignature(methodDescriptor);
        if (classFile.getLoader().canLoad(internalClassName) && (method = (javaClass = ClassFileDeserializer.deserialize(classFile.getLoader(), internalClassName)).getMethod(methodName, methodDescriptor)) != null && (genericSignature = method.getAttributeSignature()) != null) {
            return SignatureUtil.getMethodReturnedSignature(genericSignature.getSignature());
        }
        return methodReturnedSignature;
    }

    public List<String> getListOfParameterSignatures(ConstantPool constants) {
        ConstantCP cmr = constants.getConstantMethodref(this.getIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String methodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        return SignatureUtil.getParameterSignatures(methodDescriptor);
    }

    public List<Instruction> getArgs() {
        return this.args;
    }
}

