/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import java.util.Optional;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;

public abstract class Instruction {
    public static final int UNKNOWN_LINE_NUMBER = 0;
    public static final int ZERO_PRIORITY = 0;
    private int opcode;
    private final int offset;
    private int lineNumber;
    private Instruction next;

    protected Instruction(int opcode, int offset, int lineNumber) {
        this.opcode = opcode;
        this.offset = offset;
        this.setLineNumber(lineNumber);
    }

    public abstract String getReturnedSignature(ClassFile var1, LocalVariables var2);

    public int getPriority() {
        return 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLastOffset() {
        return Optional.ofNullable(this.next).map(Instruction::getLastOffset).orElse(this.offset);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public Instruction getNext() {
        return this.next;
    }

    public void setNext(Instruction next) {
        this.next = next;
    }
}

