/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.Instruction;

public class IncInstruction
extends Instruction {
    private Instruction value;
    private final int count;

    public IncInstruction(int opcode, int offset, int lineNumber, Instruction value, int count) {
        super(opcode, offset, lineNumber);
        this.setValue(value);
        this.count = count;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return this.getValue() == null ? null : this.getValue().getReturnedSignature(classFile, localVariables);
    }

    @Override
    public int getPriority() {
        if (this.isSingleStep()) {
            return 2;
        }
        return 14;
    }

    public boolean isSingleStep() {
        return this.getCount() == 1 || this.getCount() == -1;
    }

    public int getCount() {
        return this.count;
    }

    public Instruction getValue() {
        return this.value;
    }

    public void setValue(Instruction value) {
        this.value = value;
    }
}

