/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.ConstInstruction;

public class IConst
extends ConstInstruction {
    private String signature;

    public IConst(int opcode, int offset, int lineNumber, int value) {
        super(opcode, offset, lineNumber, value);
        if (value < 0) {
            if (value >= -128) {
                this.setSignature("B");
            } else if (value >= Short.MIN_VALUE) {
                this.setSignature("S");
            } else {
                this.setSignature("I");
            }
        } else if (value <= 1) {
            this.setSignature("X");
        } else if (value <= 127) {
            this.setSignature("Y");
        } else if (value <= Short.MAX_VALUE) {
            this.setSignature("S");
        } else if (value <= 65535) {
            this.setSignature("C");
        } else {
            this.setSignature("I");
        }
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        return this.getSignature();
    }

    public void setReturnedSignature(String signature) {
        this.setSignature(signature);
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

