/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Signature;

public class GetField
extends IndexInstruction
implements ObjectrefAttribute {
    private Instruction objectref;

    public GetField(int opcode, int offset, int lineNumber, int index, Instruction objectref) {
        super(opcode, offset, lineNumber, index);
        this.setObjectref(objectref);
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        Signature attributeSignature;
        String fieldSignature;
        ConstantFieldref cfr;
        ConstantNameAndType cnat;
        if (classFile == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        String fieldName = constants.getConstantUtf8((cnat = constants.getConstantNameAndType((cfr = constants.getConstantFieldref(this.getIndex())).getNameAndTypeIndex())).getNameIndex());
        Field field = classFile.getField(fieldName, fieldSignature = constants.getConstantUtf8(cnat.getSignatureIndex()));
        if (field != null && (attributeSignature = field.getAttributeSignature()) != null) {
            return attributeSignature.getSignature();
        }
        return constants.getConstantUtf8(cnat.getSignatureIndex());
    }

    @Override
    public Instruction getObjectref() {
        return this.objectref;
    }

    @Override
    public void setObjectref(Instruction objectref) {
        this.objectref = objectref;
    }
}

