/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;

public class ExceptionLoad
extends IndexInstruction {
    private final int exceptionNameIndex;

    public ExceptionLoad(int opcode, int offset, int lineNumber, int signatureIndex) {
        super(opcode, offset, lineNumber, -1);
        this.exceptionNameIndex = signatureIndex;
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        if (classFile == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        if (this.getExceptionNameIndex() == 0) {
            return null;
        }
        return constants.getConstantUtf8(this.getExceptionNameIndex());
    }

    public int getExceptionNameIndex() {
        return this.exceptionNameIndex;
    }
}

