/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantUtf8;

public class CheckCast
extends IndexInstruction
implements ObjectrefAttribute {
    private Instruction objectref;

    public CheckCast(int opcode, int offset, int lineNumber, int index, Instruction objectref) {
        super(opcode, offset, lineNumber, index);
        this.setObjectref(objectref);
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        if (classFile == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        Constant c = constants.get(this.getIndex());
        if (c instanceof ConstantUtf8 var5_6) {
            return cutf8.getBytes();
        }
        ConstantClass cc = (ConstantClass)c;
        String signature = constants.getConstantUtf8(cc.getNameIndex());
        if (signature.charAt(0) != '[') {
            signature = SignatureUtil.createTypeName(signature);
        }
        return signature;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public Instruction getObjectref() {
        return this.objectref;
    }

    @Override
    public void setObjectref(Instruction objectref) {
        this.objectref = objectref;
    }
}

