/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.instruction.bytecode.instruction;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;

public class ANewArray
extends IndexInstruction {
    private Instruction dimension;

    public ANewArray(int opcode, int offset, int lineNumber, int index, Instruction dimension) {
        super(opcode, offset, lineNumber, index);
        this.setDimension(dimension);
    }

    @Override
    public String getReturnedSignature(ClassFile classFile, LocalVariables localVariables) {
        if (classFile == null) {
            return null;
        }
        ConstantPool constants = classFile.getConstantPool();
        String str = constants.getConstantClassName(this.getIndex());
        if (str.isEmpty()) {
            return null;
        }
        if (str.charAt(0) == '[') {
            return "[" + constants.getConstantClassName(this.getIndex());
        }
        return "[L" + constants.getConstantClassName(this.getIndex()) + ';';
    }

    public Instruction getDimension() {
        return this.dimension;
    }

    public void setDimension(Instruction dimension) {
        this.dimension = dimension;
    }
}

