/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import jd.core.model.classfile.Base;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.SignatureInfo;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import org.apache.bcel.classfile.AnnotationDefault;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;

public class Method
extends Base
implements SignatureInfo {
    private FieldOrMethod fieldOrMethod;
    private boolean containsError;
    private int[] exceptionIndexes;
    private byte[] code;
    private LineNumber[] lineNumbers;
    private CodeException[] codeExceptions;
    private ParameterAnnotationEntry[] visibleParameterAnnotations;
    private ParameterAnnotationEntry[] invisibleParameterAnnotations;
    private ElementValue defaultAnnotationValue;
    private List<Instruction> instructions;
    private List<Instruction> fastNodes;
    private LocalVariables localVariables;
    private int superConstructorParameterCount;

    public Method(FieldOrMethod fieldOrMethod) {
        super(fieldOrMethod.getAccessFlags(), fieldOrMethod.getAttributes());
        this.fieldOrMethod = fieldOrMethod;
        this.containsError = false;
        this.exceptionIndexes = null;
        this.code = null;
        this.localVariables = null;
        this.lineNumbers = null;
        this.codeExceptions = null;
        this.visibleParameterAnnotations = null;
        this.invisibleParameterAnnotations = null;
        this.defaultAnnotationValue = null;
        this.superConstructorParameterCount = 0;
        Code ac = null;
        Attribute[] attributeArray = fieldOrMethod.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            switch (attribute.getTag()) {
                case 3: {
                    this.exceptionIndexes = ((ExceptionTable)attribute).getExceptionIndexTable();
                    break;
                }
                case 2: {
                    ac = (Code)attribute;
                    break;
                }
                case 14: {
                    this.visibleParameterAnnotations = ((RuntimeVisibleParameterAnnotations)attribute).getParameterAnnotationEntries();
                    break;
                }
                case 15: {
                    this.invisibleParameterAnnotations = ((RuntimeInvisibleParameterAnnotations)attribute).getParameterAnnotationEntries();
                    break;
                }
                case 16: {
                    this.defaultAnnotationValue = ((AnnotationDefault)attribute).getDefaultValue();
                }
            }
            ++n2;
        }
        if (ac != null) {
            this.code = ac.getCode();
            LocalVariableTable alvt = ac.getLocalVariableTable();
            if (alvt != null && alvt.getLocalVariableTable().length > 0) {
                LocalVariableTypeTable alvtt = Stream.of(ac.getAttributes()).filter(LocalVariableTypeTable.class::isInstance).findAny().orElse(null);
                org.apache.bcel.classfile.LocalVariable[] localVariableTypeTable = Optional.ofNullable(alvtt).map(LocalVariableTypeTable::getLocalVariableTypeTable).orElse(null);
                this.localVariables = new LocalVariables((LocalVariable[])Stream.of(alvt.getLocalVariableTable()).map(LocalVariable::new).toArray(LocalVariable[]::new), (LocalVariable[])Optional.ofNullable(localVariableTypeTable).map(localVariableArray -> Stream.of(localVariableArray)).orElseGet(Stream::empty).map(LocalVariable::new).toArray(LocalVariable[]::new));
            }
            LineNumberTable ant = ac.getLineNumberTable();
            this.lineNumbers = Optional.ofNullable(ant).map(LineNumberTable::getLineNumberTable).orElse(null);
            this.codeExceptions = ac.getExceptionTable();
        }
    }

    public boolean containsError() {
        return this.containsError;
    }

    public void setContainsError(boolean containsError) {
        this.containsError = containsError;
    }

    public int[] getExceptionIndexes() {
        return this.exceptionIndexes;
    }

    public LocalVariables getLocalVariables() {
        return this.localVariables;
    }

    public void setLocalVariables(LocalVariables llv) {
        this.localVariables = llv;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<Instruction> instructions) {
        this.instructions = instructions;
    }

    public List<Instruction> getFastNodes() {
        return this.fastNodes;
    }

    public void setFastNodes(List<Instruction> fastNodes) {
        this.fastNodes = fastNodes;
    }

    public byte[] getCode() {
        return this.code;
    }

    public LineNumber[] getLineNumbers() {
        return this.lineNumbers;
    }

    public CodeException[] getCodeExceptions() {
        return this.codeExceptions;
    }

    public ParameterAnnotationEntry[] getVisibleParameterAnnotations() {
        return this.visibleParameterAnnotations;
    }

    public ParameterAnnotationEntry[] getInvisibleParameterAnnotations() {
        return this.invisibleParameterAnnotations;
    }

    public ElementValue getDefaultAnnotationValue() {
        return this.defaultAnnotationValue;
    }

    public int getSuperConstructorParameterCount() {
        return this.superConstructorParameterCount;
    }

    public void setSuperConstructorParameterCount(int count) {
        this.superConstructorParameterCount = count;
    }

    public int getNameIndex() {
        return this.fieldOrMethod.getNameIndex();
    }

    public String getName(ConstantPool constants) {
        return constants.getConstantUtf8(this.fieldOrMethod.getNameIndex());
    }

    public String getDescriptor(ConstantPool constants) {
        return constants.getConstantUtf8(this.fieldOrMethod.getSignatureIndex());
    }

    @Override
    public int getDescriptorIndex() {
        return this.fieldOrMethod.getSignatureIndex();
    }

    public boolean isOverride(ClassFile classFile) {
        String descriptor;
        String name;
        Method overridenMethod;
        ConstantPool cp = classFile.getConstantPool();
        return this.getNameIndex() != cp.getInstanceConstructorIndex() && this.getNameIndex() != cp.getClassConstructorIndex() && (this.getAccessFlags() & 0x40A) == 0 && (overridenMethod = classFile.findMethodInSuperClassAndInterfaces(name = this.getName(cp), descriptor = this.getDescriptor(cp))) != null;
    }

    public boolean isLambda(ConstantPool constants) {
        return this.getName(constants).startsWith("lambda$");
    }
}

