/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;

public class LocalVariables {
    private final List<LocalVariable> listOfLocalVariables;
    private int indexOfFirstLocalVariable;

    public LocalVariables() {
        this.listOfLocalVariables = new ArrayList<LocalVariable>(1);
    }

    public LocalVariables(LocalVariable lv) {
        this.listOfLocalVariables = Collections.singletonList(lv);
    }

    public LocalVariables(LocalVariable[] localVariableTable, LocalVariable[] localVariableTypeTable) {
        int length = localVariableTable.length;
        this.listOfLocalVariables = new ArrayList<LocalVariable>(length);
        LocalVariable[] localVariableArray = localVariableTable;
        int n = localVariableTable.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable localVariable = localVariableArray[n2];
            if (localVariableTypeTable != null) {
                int typeLength = localVariableTypeTable.length;
                int j = 0;
                while (j < typeLength) {
                    LocalVariable typeLocalVariable = localVariableTypeTable[j];
                    if (typeLocalVariable != null && localVariable.compareTo(typeLocalVariable) == 0) {
                        localVariableTypeTable[j] = null;
                        localVariable = typeLocalVariable;
                        break;
                    }
                    ++j;
                }
            }
            this.add(localVariable);
            ++n2;
        }
    }

    public void add(LocalVariable localVariable) {
        int length = this.listOfLocalVariables.size();
        int index = localVariable.getIndex();
        int i = 0;
        while (i < length) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.getIndex() == index && lv.getStartPc() > localVariable.getStartPc() || lv.getIndex() > index) {
                this.listOfLocalVariables.add(i, localVariable);
                return;
            }
            ++i;
        }
        this.listOfLocalVariables.add(localVariable);
    }

    public String toString() {
        return this.listOfLocalVariables.toString();
    }

    public LocalVariable getLocalVariableAt(int i) {
        return i >= this.listOfLocalVariables.size() ? null : this.listOfLocalVariables.get(i);
    }

    public LocalVariable getLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.getIndex() == index && lv.getStartPc() <= offset && offset < lv.getStartPc() + lv.getLength()) {
                return lv;
            }
            --i;
        }
        return null;
    }

    public LocalVariable getLocalVariableForStoreInstruction(Instruction instruction) {
        if (instruction instanceof StoreInstruction var2_3) {
            return this.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset());
        }
        return null;
    }

    public boolean containsLocalVariableWithNameIndex(int nameIndex) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.getNameIndex() == nameIndex) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void removeLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.getIndex() == index && lv.getStartPc() <= offset && offset < lv.getStartPc() + lv.getLength()) {
                this.listOfLocalVariables.remove(i);
                break;
            }
            --i;
        }
    }

    public LocalVariable searchLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.getIndex() == index && lv.getStartPc() <= offset) {
                return lv;
            }
            --i;
        }
        return null;
    }

    public void removeUselessLocalVariables() {
        int i = this.listOfLocalVariables.size() - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.isToBeRemoved()) {
                this.listOfLocalVariables.remove(i);
            }
            --i;
        }
    }

    public int size() {
        return this.listOfLocalVariables.size();
    }

    public int getIndexOfFirstLocalVariable() {
        return this.indexOfFirstLocalVariable;
    }

    public void setIndexOfFirstLocalVariable(int indexOfFirstLocalVariable) {
        this.indexOfFirstLocalVariable = indexOfFirstLocalVariable;
    }

    public List<String> getFormalParameterNames(ConstantPool constantPool) {
        return this.listOfLocalVariables.stream().filter(lv -> lv.getStartPc() == 0).map(constantPool::getLocalVariableName).toList();
    }
}

