/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.Objects;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.instruction.fast.instruction.FastTry;

public class LocalVariable
implements Comparable<LocalVariable> {
    private int startPc;
    private int length;
    private int nameIndex;
    private int signatureIndex;
    private final int index;
    private boolean exceptionOrReturnAddress;
    private int typesBitField;
    private boolean declarationFlag;
    private boolean finalFlag;
    private boolean toBeRemoved;
    private FastTry tryResources;
    private boolean throwableFromTryResources;

    public LocalVariable(org.apache.bcel.classfile.LocalVariable lv) {
        this(lv.getStartPC(), lv.getLength(), lv.getNameIndex(), lv.getSignatureIndex(), lv.getIndex(), false, 0);
    }

    public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index) {
        this(startPc, length, nameIndex, signatureIndex, index, false, 0);
    }

    public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index, int typesBitSet) {
        this(startPc, length, nameIndex, signatureIndex, index, false, typesBitSet);
    }

    public LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index, boolean exception) {
        this(startPc, length, nameIndex, signatureIndex, index, exception, 0);
    }

    protected LocalVariable(int startPc, int length, int nameIndex, int signatureIndex, int index, boolean exceptionOrReturnAddress, int typesBitField) {
        this.setStartPc(startPc);
        this.setLength(length);
        this.setNameIndex(nameIndex);
        this.setSignatureIndex(signatureIndex);
        this.index = index;
        this.setExceptionOrReturnAddress(exceptionOrReturnAddress);
        this.setDeclarationFlag(exceptionOrReturnAddress);
        this.setTypesBitField(typesBitField);
    }

    public void updateRange(int offset) {
        if (offset < this.getStartPc()) {
            this.setLength(this.getLength() + this.getStartPc() - offset);
            this.setStartPc(offset);
        }
        if (offset >= this.getStartPc() + this.getLength()) {
            this.setLength(offset - this.getStartPc() + 1);
        }
    }

    public String toString() {
        return "LocalVariable{startPc=" + this.getStartPc() + ", length=" + this.getLength() + ", nameIndex=" + this.getNameIndex() + ", signatureIndex=" + this.getSignatureIndex() + ", index=" + this.getIndex() + "}";
    }

    @Override
    public int compareTo(LocalVariable other) {
        if (other == null) {
            return -1;
        }
        if (this.getNameIndex() != other.getNameIndex()) {
            return this.getNameIndex() - other.getNameIndex();
        }
        if (this.getLength() != other.getLength()) {
            return this.getLength() - other.getLength();
        }
        if (this.getStartPc() != other.getStartPc()) {
            return this.getStartPc() - other.getStartPc();
        }
        return this.getIndex() - other.getIndex();
    }

    public int hashCode() {
        return Objects.hash(this.nameIndex, this.length, this.startPc, this.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((LocalVariable)obj) == 0;
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public void setToBeRemoved(boolean toBeRemoved) {
        this.toBeRemoved = toBeRemoved;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSignature(ConstantPool constants) {
        return constants.getConstantUtf8(this.signatureIndex);
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public void setSignatureIndex(int signatureIndex) {
        this.signatureIndex = signatureIndex;
    }

    public boolean isExceptionOrReturnAddress() {
        return this.exceptionOrReturnAddress;
    }

    public void setExceptionOrReturnAddress(boolean exceptionOrReturnAddress) {
        this.exceptionOrReturnAddress = exceptionOrReturnAddress;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getStartPc() {
        return this.startPc;
    }

    private void setStartPc(int startPc) {
        this.startPc = startPc;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public String getName(ConstantPool cp) {
        return cp.getConstantUtf8(this.nameIndex);
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public int getTypesBitField() {
        return this.typesBitField;
    }

    public void setTypesBitField(int typesBitField) {
        this.typesBitField = typesBitField;
    }

    public boolean hasDeclarationFlag() {
        return this.declarationFlag;
    }

    public void setDeclarationFlag(boolean declarationFlag) {
        this.declarationFlag = declarationFlag;
    }

    public boolean hasFinalFlag() {
        return this.finalFlag;
    }

    public void setFinalFlag(boolean finalFlag) {
        this.finalFlag = finalFlag;
    }

    public boolean isExceptionOrThrowable(ConstantPool cp) {
        String signature = cp.getConstantUtf8(this.signatureIndex);
        String name = cp.getConstantUtf8(this.nameIndex);
        return name != null && ("Ljava/lang/Throwable;".equals(signature) && name.startsWith("localThrowable") || signature.endsWith("Exception;") && "e".equals(name));
    }

    public FastTry getTryResources() {
        return this.tryResources;
    }

    public void setTryResources(FastTry tryResources) {
        this.tryResources = tryResources;
    }

    public boolean isThrowableFromTryResources() {
        return this.throwableFromTryResources;
    }

    public void setThrowableFromTryResources(boolean throwableFromTryResources) {
        this.throwableFromTryResources = throwableFromTryResources;
    }
}

