/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import jd.core.model.classfile.Base;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.SignatureInfo;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.FieldOrMethod;

public class Field
extends Base
implements SignatureInfo {
    private FieldOrMethod fieldOrMethod;
    private ValueAndMethod valueAndMethod;
    private ConstantPool constantPool;
    private boolean outerLocalVariable;
    private int anonymousClassConstructorParameterIndex;
    private int outerMethodLocalVariableNameIndex;

    public Field(FieldOrMethod fieldOrMethod) {
        super(fieldOrMethod.getAccessFlags(), fieldOrMethod.getAttributes());
        this.fieldOrMethod = fieldOrMethod;
        this.setAnonymousClassConstructorParameterIndex(-1);
        this.setOuterMethodLocalVariableNameIndex(-1);
    }

    public Constant getConstantValue(ConstantPool constants) {
        Attribute[] attributeArray = this.fieldOrMethod.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 1) {
                ConstantValue acv = (ConstantValue)attribute;
                return constants.getConstantValue(acv.getConstantValueIndex());
            }
            ++n2;
        }
        return null;
    }

    public ValueAndMethod getValueAndMethod() {
        return this.valueAndMethod;
    }

    public void setValueAndMethod(Instruction value, Method method) {
        this.valueAndMethod = new ValueAndMethod(value, method);
    }

    public int getAnonymousClassConstructorParameterIndex() {
        return this.anonymousClassConstructorParameterIndex;
    }

    public void setAnonymousClassConstructorParameterIndex(int anonymousClassConstructorParameterIndex) {
        this.anonymousClassConstructorParameterIndex = anonymousClassConstructorParameterIndex;
    }

    public int getOuterMethodLocalVariableNameIndex() {
        return this.outerMethodLocalVariableNameIndex;
    }

    public void setOuterMethodLocalVariableNameIndex(int outerMethodLocalVariableNameIndex) {
        this.outerMethodLocalVariableNameIndex = outerMethodLocalVariableNameIndex;
    }

    public int getNameIndex() {
        return this.fieldOrMethod.getNameIndex();
    }

    @Override
    public int getDescriptorIndex() {
        return this.fieldOrMethod.getSignatureIndex();
    }

    public void setNameIndex(int newNameIndex) {
        this.fieldOrMethod.setNameIndex(newNameIndex);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public boolean isOuterLocalVariable() {
        return this.outerLocalVariable;
    }

    public void setOuterLocalVariable(boolean outerLocalVariable) {
        this.outerLocalVariable = outerLocalVariable;
    }

    public record ValueAndMethod(Instruction value, Method method) {
    }
}

