/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jd.core.model.classfile.LocalVariable;
import jd.core.util.IndexToIndexMap;
import jd.core.util.StringToIndexMap;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.commons.lang3.Validate;

public class ConstantPool {
    private final org.apache.bcel.classfile.ConstantPool constantPool;
    private final List<Constant> listOfConstants;
    private final StringToIndexMap constantUtf8ToIndex;
    private final IndexToIndexMap constantClassToIndex;
    private final int instanceConstructorIndex;
    private final int classConstructorIndex;
    private final int internalDeprecatedSignatureIndex;
    private final int overrideSignatureIndex;
    private final int toStringIndex;
    private final int valueOfIndex;
    private final int appendIndex;
    private final int objectClassNameIndex;
    private final int stringClassNameIndex;
    private final int stringBufferClassNameIndex;
    private final int stringBuilderClassNameIndex;
    private final int objectSignatureIndex;
    private final int thisLocalVariableNameIndex;

    public ConstantPool(org.apache.bcel.classfile.ConstantPool constantPool) {
        this.constantPool = constantPool;
        this.listOfConstants = new ArrayList<Constant>();
        this.constantUtf8ToIndex = new StringToIndexMap();
        this.constantClassToIndex = new IndexToIndexMap();
        Constant[] constantArray = constants = constantPool.getConstantPool();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Constant constant = constantArray[n2];
            int index = this.listOfConstants.size();
            this.listOfConstants.add(constant);
            if (constant instanceof ConstantUtf8 var8_8) {
                this.constantUtf8ToIndex.put(cu.getBytes(), index);
            }
            if (constant instanceof ConstantClass var11_10) {
                this.constantClassToIndex.put(cc.getNameIndex(), index);
            }
            ++n2;
        }
        this.instanceConstructorIndex = this.addConstantUtf8("<init>");
        this.classConstructorIndex = this.addConstantUtf8("<clinit>");
        this.internalDeprecatedSignatureIndex = this.addConstantUtf8("Ljava/lang/Deprecated;");
        this.overrideSignatureIndex = this.addConstantUtf8("Ljava/lang/Override;");
        this.toStringIndex = this.addConstantUtf8("toString");
        this.valueOfIndex = this.addConstantUtf8("valueOf");
        this.appendIndex = this.addConstantUtf8("append");
        this.objectClassNameIndex = this.addConstantUtf8("java/lang/Object");
        this.objectSignatureIndex = this.addConstantUtf8("Ljava/lang/Object;");
        this.stringClassNameIndex = this.addConstantUtf8("java/lang/String");
        this.stringBufferClassNameIndex = this.addConstantUtf8("java/lang/StringBuffer");
        this.stringBuilderClassNameIndex = this.addConstantUtf8("java/lang/StringBuilder");
        this.thisLocalVariableNameIndex = this.addConstantUtf8("this");
    }

    public Constant get(int i) {
        return this.listOfConstants.get(i);
    }

    public int size() {
        return this.listOfConstants.size();
    }

    public int addConstantUtf8(String s) {
        Objects.requireNonNull(s, "Constant string is null");
        Validate.matchesPattern((CharSequence)s, (String)"^((?!L\\[).)*$", (String)"Constant string starts with L[", (Object[])new Object[0]);
        int index = this.constantUtf8ToIndex.get(s);
        if (index == -1) {
            ConstantUtf8 cutf8 = new ConstantUtf8(s);
            index = this.listOfConstants.size();
            this.listOfConstants.add((Constant)cutf8);
            this.constantUtf8ToIndex.put(s, index);
        }
        return index;
    }

    public int addConstantClass(int nameIndex) {
        int index;
        String internalName = this.getConstantUtf8(nameIndex);
        if (internalName == null || internalName.isEmpty() || internalName.charAt(internalName.length() - 1) == ';') {
            System.err.println("ConstantPool.addConstantClass: invalid name index");
        }
        if ((index = this.constantClassToIndex.get(nameIndex)) == -1) {
            ConstantClass cc = new ConstantClass(nameIndex);
            index = this.listOfConstants.size();
            this.listOfConstants.add((Constant)cc);
            this.constantClassToIndex.put(nameIndex, index);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public int addConstantNameAndType(int nameIndex, int descriptorIndex) {
        int index = this.listOfConstants.size();
        while (--index > 0) {
            void cnat;
            ConstantNameAndType constantNameAndType;
            Constant constant = this.listOfConstants.get(index);
            Constant constant2 = constant;
            if (!(constant2 instanceof ConstantNameAndType) || (constantNameAndType = (ConstantNameAndType)constant2) != (ConstantNameAndType)constant2 || cnat.getNameIndex() != nameIndex || cnat.getSignatureIndex() != descriptorIndex) continue;
            return index;
        }
        ConstantNameAndType cnat = new ConstantNameAndType(nameIndex, descriptorIndex);
        index = this.listOfConstants.size();
        this.listOfConstants.add((Constant)cnat);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public int addConstantFieldref(int classIndex, int nameAndTypeIndex) {
        int index = this.listOfConstants.size();
        while (--index > 0) {
            void cfr;
            ConstantFieldref constantFieldref;
            Constant constant = this.listOfConstants.get(index);
            Constant constant2 = constant;
            if (!(constant2 instanceof ConstantFieldref) || (constantFieldref = (ConstantFieldref)constant2) != (ConstantFieldref)constant2 || cfr.getClassIndex() != classIndex || cfr.getNameAndTypeIndex() != nameAndTypeIndex) continue;
            return index;
        }
        ConstantFieldref cfr = new ConstantFieldref(classIndex, nameAndTypeIndex);
        index = this.listOfConstants.size();
        this.listOfConstants.add((Constant)cfr);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public int addConstantMethodref(int classIndex, int nameAndTypeIndex) {
        int index = this.listOfConstants.size();
        while (--index > 0) {
            void cmr;
            ConstantMethodref constantMethodref;
            Constant constant = this.listOfConstants.get(index);
            Constant constant2 = constant;
            if (!(constant2 instanceof ConstantMethodref) || (constantMethodref = (ConstantMethodref)constant2) != (ConstantMethodref)constant2 || cmr.getClassIndex() != classIndex || cmr.getNameAndTypeIndex() != nameAndTypeIndex) continue;
            return index;
        }
        ConstantMethodref cmr = new ConstantMethodref(classIndex, nameAndTypeIndex);
        index = this.listOfConstants.size();
        this.listOfConstants.add((Constant)cmr);
        return index;
    }

    public String getConstantUtf8(int index) {
        ConstantUtf8 cutf8 = (ConstantUtf8)this.listOfConstants.get(index);
        return cutf8.getBytes();
    }

    public String getConstantClassName(int index) {
        ConstantClass cc = (ConstantClass)this.listOfConstants.get(index);
        ConstantUtf8 cutf8 = (ConstantUtf8)this.listOfConstants.get(cc.getNameIndex());
        return cutf8.getBytes();
    }

    public ConstantClass getConstantClass(int index) {
        return (ConstantClass)this.listOfConstants.get(index);
    }

    public ConstantFieldref getConstantFieldref(int index) {
        return (ConstantFieldref)this.listOfConstants.get(index);
    }

    public ConstantNameAndType getConstantNameAndType(int index) {
        return (ConstantNameAndType)this.listOfConstants.get(index);
    }

    public ConstantCP getConstantMethodref(int index) {
        return (ConstantCP)this.listOfConstants.get(index);
    }

    public ConstantMethodType getConstantMethodType(int index) {
        return (ConstantMethodType)this.listOfConstants.get(index);
    }

    public ConstantMethodHandle getConstantMethodHandle(int index) {
        return (ConstantMethodHandle)this.listOfConstants.get(index);
    }

    public ConstantInterfaceMethodref getConstantInterfaceMethodref(int index) {
        return (ConstantInterfaceMethodref)this.listOfConstants.get(index);
    }

    public ConstantInvokeDynamic getConstantInvokeDynamic(int index) {
        return (ConstantInvokeDynamic)this.listOfConstants.get(index);
    }

    public Constant getConstantValue(int index) {
        return this.listOfConstants.get(index);
    }

    public int getAppendIndex() {
        return this.appendIndex;
    }

    public int getClassConstructorIndex() {
        return this.classConstructorIndex;
    }

    public int getInstanceConstructorIndex() {
        return this.instanceConstructorIndex;
    }

    public int getInternalDeprecatedSignatureIndex() {
        return this.internalDeprecatedSignatureIndex;
    }

    public int getOverrideSignatureIndex() {
        return this.overrideSignatureIndex;
    }

    public int getObjectClassNameIndex() {
        return this.objectClassNameIndex;
    }

    public int getObjectSignatureIndex() {
        return this.objectSignatureIndex;
    }

    public int getStringBufferClassNameIndex() {
        return this.stringBufferClassNameIndex;
    }

    public int getStringBuilderClassNameIndex() {
        return this.stringBuilderClassNameIndex;
    }

    public int getToStringIndex() {
        return this.toStringIndex;
    }

    public int getStringClassNameIndex() {
        return this.stringClassNameIndex;
    }

    public int getValueOfIndex() {
        return this.valueOfIndex;
    }

    public int getThisLocalVariableNameIndex() {
        return this.thisLocalVariableNameIndex;
    }

    public String getLocalVariableName(LocalVariable localVariable) {
        return this.getConstantUtf8(localVariable.getNameIndex());
    }

    public org.apache.bcel.classfile.ConstantPool getConstantPool() {
        return this.constantPool;
    }
}

