/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jd.core.model.classfile.Base;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.variable.DefaultVariableNameGenerator;
import jd.core.process.analyzer.variable.VariableNameGenerator;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.MethodParameters;
import org.apache.bcel.classfile.Signature;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.javasyntax.type.AbstractTypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class ClassFile
extends Base {
    private final int minorVersion;
    private final int majorVersion;
    private final int thisClass;
    private final int superClass;
    private final int[] interfaces;
    private final Field[] fields;
    private final Method[] methods;
    private final ConstantPool constants;
    private final String thisClassName;
    private final String superClassName;
    private final String internalClassName;
    private final String internalPackageName;
    private ClassFile outerClass;
    private final Map<String, ClassFile> superClassAndInterfaces;
    private Field outerThisField;
    private List<ClassFile> innerClassFiles;
    private final Method staticMethod;
    private List<Instruction> enumValues;
    private String internalAnonymousClassName;
    private final Map<String, Map<String, Accessor>> accessors;
    private final VariableNameGenerator variableNameGenerator;
    private final Map<String, List<Integer>> switchMaps;
    private final Loader loader;

    public ClassFile(int minorVersion, int majorVersion, ConstantPool constants, int accessFlags, int thisClass, int superClass, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes, Loader loader) {
        super(accessFlags, attributes);
        this.loader = loader;
        this.minorVersion = minorVersion;
        this.majorVersion = majorVersion;
        this.thisClass = thisClass;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.constants = constants;
        this.thisClassName = this.constants.getConstantClassName(this.thisClass);
        this.superClassName = this.superClass == 0 ? null : this.constants.getConstantClassName(this.superClass);
        this.internalClassName = SignatureUtil.createTypeName(this.thisClassName);
        int index = this.thisClassName.lastIndexOf(47);
        this.internalPackageName = index == -1 ? "" : this.thisClassName.substring(0, index);
        this.staticMethod = this.findStaticMethod();
        this.internalAnonymousClassName = null;
        this.accessors = new HashMap<String, Map<String, Accessor>>(10);
        this.switchMaps = new HashMap<String, List<Integer>>();
        this.variableNameGenerator = new DefaultVariableNameGenerator(this);
        this.superClassAndInterfaces = new HashMap<String, ClassFile>();
    }

    private Method findStaticMethod() {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if ((method.getAccessFlags() & 8) != 0 && method.getNameIndex() == this.constants.getClassConstructorIndex()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public ConstantPool getConstantPool() {
        return this.constants;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getSuperClassIndex() {
        return this.superClass;
    }

    public int getThisClassIndex() {
        return this.thisClass;
    }

    public String getClassName() {
        if (this.outerClass == null) {
            int index = this.thisClassName.lastIndexOf(47);
            return index == -1 ? this.thisClassName : this.thisClassName.substring(index + 1);
        }
        String outerClassName = this.outerClass.getThisClassName();
        return this.thisClassName.substring(outerClassName.length() + 1);
    }

    public String getThisClassName() {
        return this.thisClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public String getInternalPackageName() {
        return this.internalPackageName;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(int i) {
        return this.methods[i];
    }

    public InnerClasses getAttributeInnerClasses() {
        Attribute[] attributeArray = this.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 6) {
                return (InnerClasses)attribute;
            }
            ++n2;
        }
        return null;
    }

    public BootstrapMethods getAttributeBootstrapMethods() {
        Attribute[] attributeArray = this.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 20) {
                return (BootstrapMethods)attribute;
            }
            ++n2;
        }
        return null;
    }

    public MethodParameters getAttributeMethodParameters() {
        Attribute[] attributeArray = this.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 21) {
                return (MethodParameters)attribute;
            }
            ++n2;
        }
        return null;
    }

    private boolean isAnonymousClass() {
        int index = this.thisClassName.lastIndexOf(36);
        return index != -1 && index + 1 < this.thisClassName.length() && Character.isDigit(this.thisClassName.charAt(index + 1));
    }

    public boolean isAInnerClass() {
        return this.outerClass != null;
    }

    public ClassFile getOuterClass() {
        return this.outerClass;
    }

    public void setOuterClass(ClassFile outerClass) {
        this.outerClass = outerClass;
        if (this.isAnonymousClass()) {
            ConstantClass cc = this.constants.getConstantClass(this.superClass);
            if (cc.getNameIndex() != this.constants.getObjectClassNameIndex()) {
                this.internalAnonymousClassName = this.superClassName;
            } else if (this.interfaces != null && this.interfaces.length > 0) {
                int interfaceIndex = this.interfaces[0];
                this.internalAnonymousClassName = this.constants.getConstantClassName(interfaceIndex);
            } else {
                this.internalAnonymousClassName = "java/lang/Object";
            }
        } else {
            this.internalAnonymousClassName = null;
        }
    }

    public Field getOuterThisField() {
        return this.outerThisField;
    }

    public void setOuterThisField(Field outerThisField) {
        this.outerThisField = outerThisField;
    }

    public List<ClassFile> getInnerClassFiles() {
        return this.innerClassFiles;
    }

    public void setInnerClassFiles(List<ClassFile> innerClassFiles) {
        this.innerClassFiles = innerClassFiles;
    }

    public ClassFile getInnerClassFile(String internalClassName) {
        if (this.innerClassFiles != null && internalClassName.length() > this.thisClassName.length() + 1 && internalClassName.charAt(this.thisClassName.length()) == '$') {
            for (ClassFile innerClassFile : this.innerClassFiles) {
                if (!innerClassFile.thisClassName.equals(internalClassName)) continue;
                return innerClassFile;
            }
        }
        return null;
    }

    public Field getField(int fieldNameIndex, int fieldDescriptorIndex) {
        Field[] fieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (fieldNameIndex == field.getNameIndex() && fieldDescriptorIndex == field.getDescriptorIndex()) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public Field getField(String fieldName, String fieldDescriptor) {
        Field[] fieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            String descriptor;
            Field field = fieldArray[n2];
            String name = this.constants.getConstantUtf8(field.getNameIndex());
            if (fieldName.equals(name) && fieldDescriptor.equals(descriptor = this.constants.getConstantUtf8(field.getDescriptorIndex()))) {
                return field;
            }
            ++n2;
        }
        return null;
    }

    public Method getStaticMethod() {
        return this.staticMethod;
    }

    public Method getMethod(String methodName, String methodDescriptor) {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = this.constants.getConstantUtf8(method.getNameIndex());
            if (methodName.equals(name)) {
                String descriptor = this.constants.getConstantUtf8(method.getDescriptorIndex());
                Signature attributeSignature = method.getAttributeSignature();
                if (methodDescriptor.equals(descriptor)) {
                    return method;
                }
                if (attributeSignature != null) {
                    List<String> genericParameters;
                    List<String> methodParameters;
                    int nbrOfParameters2;
                    String signature = attributeSignature.getSignature();
                    int nbrOfParameters1 = SignatureUtil.getParameterSignatureCount(methodDescriptor);
                    if (nbrOfParameters1 == (nbrOfParameters2 = SignatureUtil.getParameterSignatureCount(descriptor)) && ((methodParameters = SignatureUtil.getParameterSignatures(methodDescriptor)).equals(genericParameters = SignatureUtil.getParameterSignatures(signature)) || genericParameters.stream().allMatch(SignatureUtil::isGenericSignature) && methodParameters.stream().noneMatch(SignatureUtil::isPrimitiveSignature))) {
                        return method;
                    }
                }
            }
            ++n2;
        }
        return this.findMethodInSuperClassAndInterfaces(methodName, methodDescriptor);
    }

    public Method findMethodInSuperClassAndInterfaces(String methodName, String methodDescriptor) {
        for (ClassFile classFile : this.superClassAndInterfaces.values()) {
            Method method = classFile.getMethod(methodName, methodDescriptor);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public List<Instruction> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<Instruction> enumValues) {
        this.enumValues = enumValues;
    }

    public String getInternalAnonymousClassName() {
        return this.internalAnonymousClassName;
    }

    public void addAccessor(String name, String descriptor, Accessor accessor) {
        this.accessors.computeIfAbsent(name, k -> new HashMap(1)).put(descriptor, accessor);
    }

    public Accessor getAccessor(String name, String descriptor) {
        Map<String, Accessor> map = this.accessors.get(name);
        return map == null ? null : map.get(descriptor);
    }

    public Map<String, List<Integer>> getSwitchMaps() {
        return this.switchMaps;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public VariableNameGenerator getVariableNameGenerator() {
        return this.variableNameGenerator;
    }

    public Map<String, ClassFile> getSuperClassAndInterfaces() {
        return this.superClassAndInterfaces;
    }

    public String toString() {
        return this.internalClassName;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getTypeArgumentInnerClasses() {
        ObjectType objectType;
        TypeMaker typeMaker;
        Type type;
        Type type2;
        final HashSet<String> typeArgumentInnerClasses = new HashSet<String>();
        Signature signature = this.getAttributeSignature();
        if (signature != null && (type2 = (type = (typeMaker = new TypeMaker(this.loader)).makeFromSignature(signature.getSignature()))) instanceof ObjectType && (objectType = (ObjectType)type2) == (ObjectType)type2) {
            void ot;
            ot.accept((TypeArgumentVisitor)new AbstractTypeArgumentVisitor(){

                public void visit(InnerObjectType type) {
                    typeArgumentInnerClasses.add(type.getInternalName());
                }
            });
        }
        return typeArgumentInnerClasses;
    }
}

