/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import jd.core.model.classfile.ClassFile;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Signature;

public class Base {
    private int accessFlags;
    private final Attribute[] attributes;

    public Base(int accessFlags, Attribute[] attributes) {
        this.setAccessFlags(accessFlags);
        this.attributes = attributes;
    }

    public Signature getAttributeSignature() {
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 10) {
                return (Signature)attribute;
            }
            ++n2;
        }
        return null;
    }

    public boolean containsAttributeDeprecated() {
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute.getTag() == 8) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsAnnotationDeprecated(ClassFile classFile) {
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry[] annotations;
            Attribute attribute = attributeArray[n2];
            if ((attribute.getTag() == 13 || attribute.getTag() == 12) && Base.containsAnnotationDeprecated(classFile, annotations = ((Annotations)attribute).getAnnotationEntries())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsAnnotationDeprecated(ClassFile classFile, AnnotationEntry[] annotations) {
        int idsIndex = classFile.getConstantPool().getInternalDeprecatedSignatureIndex();
        AnnotationEntry[] annotationEntryArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry annotationEntry = annotationEntryArray[n2];
            if (idsIndex == annotationEntry.getTypeIndex()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }
}

