/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.writer.visitor;

import java.util.List;
import org.jd.core.v1.api.printer.Printer;
import org.jd.core.v1.model.token.AbstractNopTokenVisitor;
import org.jd.core.v1.model.token.BooleanConstantToken;
import org.jd.core.v1.model.token.CharacterConstantToken;
import org.jd.core.v1.model.token.DeclarationToken;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.NumericConstantToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.StringConstantToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.model.token.TokenVisitor;

public class PrintTokenVisitor
implements TokenVisitor {
    private final SearchLineNumberVisitor searchLineNumberVisitor = new SearchLineNumberVisitor();
    private Printer printer;
    private List<Token> tokens;
    private int index;
    private int newLineCount;

    public void start(Printer printer, List<Token> tokens) {
        this.printer = printer;
        this.tokens = tokens;
        this.index = 0;
        this.newLineCount = 0;
        printer.startLine(this.searchLineNumber());
    }

    public void end() {
        this.printer.endLine();
    }

    @Override
    public void visit(BooleanConstantToken token) {
        this.prepareNewLine();
        this.printer.printKeyword(token.value() ? "true" : "false");
        ++this.index;
    }

    @Override
    public void visit(CharacterConstantToken token) {
        this.prepareNewLine();
        this.printer.printStringConstant("'" + token.getCharacter() + "'", token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(DeclarationToken token) {
        this.prepareNewLine();
        this.printer.printDeclaration(token.getType(), token.getInternalTypeName(), token.getName(), token.getDescriptor());
        ++this.index;
    }

    @Override
    public void visit(StartBlockToken token) {
        this.prepareNewLine();
        this.printer.printText(token.text());
        this.printer.indent();
        if (token == StartBlockToken.START_RESOURCES_BLOCK) {
            this.printer.indent();
        }
        ++this.index;
    }

    @Override
    public void visit(EndBlockToken token) {
        this.printer.unindent();
        if (token == EndBlockToken.END_RESOURCES_BLOCK) {
            this.printer.unindent();
        }
        this.prepareNewLine();
        this.printer.printText(token.text());
        ++this.index;
    }

    @Override
    public void visit(StartMarkerToken token) {
        this.prepareNewLine();
        this.printer.startMarker(token.type());
        ++this.index;
    }

    @Override
    public void visit(EndMarkerToken token) {
        this.prepareNewLine();
        this.printer.endMarker(token.type());
        ++this.index;
    }

    @Override
    public void visit(NewLineToken token) {
        this.newLineCount += token.count();
        ++this.index;
    }

    @Override
    public void visit(KeywordToken token) {
        this.prepareNewLine();
        this.printer.printKeyword(token.keyword());
        ++this.index;
    }

    @Override
    public void visit(LineNumberToken token) {
        ++this.index;
    }

    @Override
    public void visit(NumericConstantToken token) {
        this.prepareNewLine();
        this.printer.printNumericConstant(token.text());
        ++this.index;
    }

    @Override
    public void visit(ReferenceToken token) {
        this.prepareNewLine();
        this.printer.printReference(token.getType(), token.getInternalTypeName(), token.getName(), token.getDescriptor(), token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(StringConstantToken token) {
        this.prepareNewLine();
        this.printer.printStringConstant("\"" + token.text() + "\"", token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(TextToken token) {
        this.prepareNewLine();
        this.printer.printText(token.text());
        ++this.index;
    }

    protected void prepareNewLine() {
        if (this.newLineCount > 0) {
            this.printer.endLine();
            if (this.newLineCount > 2) {
                this.printer.extraLine(this.newLineCount - 2);
                this.newLineCount = 2;
            }
            if (this.newLineCount > 1) {
                this.printer.startLine(0);
                this.printer.endLine();
            }
            this.printer.startLine(this.searchLineNumber());
            this.newLineCount = 0;
        }
    }

    protected int searchLineNumber() {
        this.searchLineNumberVisitor.reset();
        for (int i = this.index; i >= 0; --i) {
            this.tokens.get(i).accept(this.searchLineNumberVisitor);
            if (this.searchLineNumberVisitor.lineNumber != 0) {
                return this.searchLineNumberVisitor.lineNumber;
            }
            if (this.searchLineNumberVisitor.newLineCounter > 0) break;
        }
        this.searchLineNumberVisitor.reset();
        int size = this.tokens.size();
        for (int i = this.index; i < size; ++i) {
            this.tokens.get(i).accept(this.searchLineNumberVisitor);
            if (this.searchLineNumberVisitor.lineNumber != 0) {
                return this.searchLineNumberVisitor.lineNumber;
            }
            if (this.searchLineNumberVisitor.newLineCounter > 0) break;
        }
        return 0;
    }

    protected static class SearchLineNumberVisitor
    extends AbstractNopTokenVisitor {
        private int lineNumber;
        private int newLineCounter;

        protected SearchLineNumberVisitor() {
        }

        public void reset() {
            this.lineNumber = 0;
            this.newLineCounter = 0;
        }

        @Override
        public void visit(LineNumberToken token) {
            this.lineNumber = token.lineNumber();
        }

        @Override
        public void visit(NewLineToken token) {
            ++this.newLineCounter;
        }
    }
}

