/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.writer;

import java.util.List;
import org.jd.core.v1.api.printer.Printer;
import org.jd.core.v1.model.message.DecompileContext;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.service.writer.visitor.PrintTokenVisitor;
import org.jd.core.v1.util.DefaultList;

public class WriteTokenProcessor {
    public void process(DecompileContext decompileContext) {
        Printer printer = decompileContext.getPrinter();
        DefaultList<Token> tokens = decompileContext.getTokens();
        PrintTokenVisitor visitor = new PrintTokenVisitor();
        int maxLineNumber = decompileContext.getMaxLineNumber();
        int majorVersion = decompileContext.getMajorVersion();
        int minorVersion = decompileContext.getMinorVersion();
        printer.start(maxLineNumber, majorVersion, minorVersion);
        visitor.start(printer, (List<Token>)tokens);
        for (Token token : tokens) {
            token.accept(visitor);
        }
        visitor.end();
        printer.end();
    }
}

