/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.tokenizer.javafragmenttotoken.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jd.core.v1.model.javafragment.EndBlockFragment;
import org.jd.core.v1.model.javafragment.EndBlockInParameterFragment;
import org.jd.core.v1.model.javafragment.EndBodyFragment;
import org.jd.core.v1.model.javafragment.EndBodyInParameterFragment;
import org.jd.core.v1.model.javafragment.EndMovableJavaBlockFragment;
import org.jd.core.v1.model.javafragment.EndSingleStatementBlockFragment;
import org.jd.core.v1.model.javafragment.EndStatementsBlockFragment;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javafragment.JavaFragmentVisitor;
import org.jd.core.v1.model.javafragment.LineNumberTokensFragment;
import org.jd.core.v1.model.javafragment.SpaceSpacerFragment;
import org.jd.core.v1.model.javafragment.SpacerBetweenMembersFragment;
import org.jd.core.v1.model.javafragment.SpacerFragment;
import org.jd.core.v1.model.javafragment.StartBlockFragment;
import org.jd.core.v1.model.javafragment.StartBodyFragment;
import org.jd.core.v1.model.javafragment.StartMovableJavaBlockFragment;
import org.jd.core.v1.model.javafragment.StartSingleStatementBlockFragment;
import org.jd.core.v1.model.javafragment.StartStatementsBlockFragment;
import org.jd.core.v1.model.javafragment.StartStatementsDoWhileBlockFragment;
import org.jd.core.v1.model.javafragment.StartStatementsTryBlockFragment;
import org.jd.core.v1.model.javafragment.TokensFragment;
import org.jd.core.v1.model.token.AbstractNopTokenVisitor;
import org.jd.core.v1.model.token.BooleanConstantToken;
import org.jd.core.v1.model.token.CharacterConstantToken;
import org.jd.core.v1.model.token.DeclarationToken;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.NumericConstantToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.StringConstantToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.model.token.TokenVisitor;
import org.jd.core.v1.util.DefaultList;

public class TokenizeJavaFragmentVisitor
implements JavaFragmentVisitor {
    protected static final KeywordToken DO = new KeywordToken("do");
    protected static final KeywordToken IMPORT = new KeywordToken("import");
    protected static final KeywordToken TRY = new KeywordToken("try");
    protected static final List<Token> DO_TOKENS = Arrays.asList(DO);
    protected static final List<Token> TRY_TOKENS = Arrays.asList(TRY);
    private final KnownLineNumberTokenVisitor knownLineNumberTokenVisitor = new KnownLineNumberTokenVisitor();
    private final UnknownLineNumberTokenVisitor unknownLineNumberTokenVisitor = new UnknownLineNumberTokenVisitor();
    protected final DefaultList<Token> tokens;

    public TokenizeJavaFragmentVisitor(int initialCapacity) {
        this.tokens = new DefaultList(initialCapacity);
    }

    public DefaultList<Token> getTokens() {
        return this.tokens;
    }

    @Override
    public void visit(EndBlockFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
            }
        }
    }

    @Override
    public void visit(EndBlockInParameterFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
            }
        }
    }

    @Override
    public void visit(EndBodyFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            case 1: {
                if (fragment.getStartBodyFragment().getLineCount() == 0) {
                    this.tokens.add((Object)TextToken.SPACE);
                    this.tokens.add((Object)EndBlockToken.END_BLOCK);
                    this.tokens.add((Object)NewLineToken.NEWLINE_1);
                    break;
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
            }
        }
    }

    @Override
    public void visit(EndBodyInParameterFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.COMMA);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
            }
        }
    }

    @Override
    public void visit(EndMovableJavaBlockFragment fragment) {
    }

    @Override
    public void visit(EndSingleStatementBlockFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                if (fragment.getStartSingleStatementBlockFragment().getLineCount() == 0 || fragment.getStartSingleStatementBlockFragment().getLineCount() == 1) {
                    this.tokens.add((Object)TextToken.SPACE);
                    this.tokens.add((Object)EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
                    break;
                }
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                if (fragment.getStartSingleStatementBlockFragment().getLineCount() == 0) {
                    this.tokens.add((Object)EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
                    this.tokens.add((Object)NewLineToken.NEWLINE_1);
                    break;
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                break;
            }
            case 2: {
                if (fragment.getStartSingleStatementBlockFragment().getLineCount() == 0) {
                    this.tokens.add((Object)EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
                    this.tokens.add((Object)NewLineToken.NEWLINE_2);
                    break;
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                if (fragment.getStartSingleStatementBlockFragment().getLineCount() == 0) {
                    this.tokens.add((Object)EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
                    this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                    break;
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
            }
        }
    }

    @Override
    public void visit(EndStatementsBlockFragment fragment) {
        int minimalLineCount = fragment.getGroup().getMinimalLineCount();
        block0 : switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                if (minimalLineCount == 0) {
                    this.tokens.add((Object)TextToken.SPACE);
                    this.tokens.add((Object)EndBlockToken.END_BLOCK);
                    this.tokens.add((Object)NewLineToken.NEWLINE_1);
                    break;
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 2: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)EndBlockToken.END_BLOCK);
                        this.tokens.add((Object)NewLineToken.NEWLINE_2);
                        break block0;
                    }
                    case 1: {
                        this.tokens.add((Object)NewLineToken.NEWLINE_1);
                        this.tokens.add((Object)EndBlockToken.END_BLOCK);
                        this.tokens.add((Object)NewLineToken.NEWLINE_1);
                        break block0;
                    }
                }
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)EndBlockToken.END_BLOCK);
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        break block0;
                    }
                    case 1: {
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        this.tokens.add((Object)EndBlockToken.END_BLOCK);
                        break block0;
                    }
                }
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
                this.tokens.add((Object)EndBlockToken.END_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
            }
        }
    }

    @Override
    public void visit(ImportsFragment fragment) {
        DefaultList imports = new DefaultList(fragment.getImports());
        imports.sort(Comparator.comparing(ImportsFragment.Import::getQualifiedName));
        this.tokens.add((Object)StartMarkerToken.IMPORT_STATEMENTS);
        for (ImportsFragment.Import imp : imports) {
            this.tokens.add((Object)IMPORT);
            this.tokens.add((Object)TextToken.SPACE);
            this.tokens.add((Object)new ReferenceToken(1, imp.getInternalName(), imp.getQualifiedName()));
            this.tokens.add((Object)TextToken.SEMICOLON);
            this.tokens.add((Object)NewLineToken.NEWLINE_1);
        }
        this.tokens.add((Object)EndMarkerToken.IMPORT_STATEMENTS);
    }

    @Override
    public void visit(LineNumberTokensFragment fragment) {
        this.knownLineNumberTokenVisitor.reset(fragment.getFirstLineNumber());
        for (Token token : fragment.getTokens()) {
            token.accept(this.knownLineNumberTokenVisitor);
        }
    }

    @Override
    public void visit(SpacerBetweenMembersFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
            }
        }
    }

    @Override
    public void visit(SpacerFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
            }
        }
    }

    @Override
    public void visit(SpaceSpacerFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                break;
            }
            default: {
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
            }
        }
    }

    @Override
    public void visit(StartBlockFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_2);
                break;
            }
            default: {
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
            }
        }
    }

    @Override
    public void visit(StartBodyFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
            }
        }
    }

    @Override
    public void visit(StartMovableJavaBlockFragment fragment) {
    }

    @Override
    public void visit(StartSingleStatementBlockFragment fragment) {
        switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                if (fragment.getEndSingleStatementBlockFragment().getLineCount() == 0) {
                    this.tokens.add((Object)StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
                } else {
                    this.tokens.add((Object)TextToken.SPACE);
                    this.tokens.add((Object)StartBlockToken.START_BLOCK);
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
            }
        }
    }

    @Override
    public void visit(StartStatementsBlockFragment fragment) {
        int minimalLineCount = fragment.getGroup().getMinimalLineCount();
        block0 : switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                if (minimalLineCount == 0) {
                    this.tokens.add((Object)NewLineToken.NEWLINE_1);
                    this.tokens.add((Object)StartBlockToken.START_BLOCK);
                    this.tokens.add((Object)TextToken.SPACE);
                    break;
                }
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)NewLineToken.NEWLINE_2);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)TextToken.SPACE);
                        break block0;
                    }
                    case 1: {
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)NewLineToken.NEWLINE_2);
                        break block0;
                    }
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)TextToken.SPACE);
                        break block0;
                    }
                    case 1: {
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        break block0;
                    }
                }
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
            }
        }
    }

    @Override
    public void visit(StartStatementsDoWhileBlockFragment fragment) {
        this.visit(fragment, DO_TOKENS);
    }

    @Override
    public void visit(StartStatementsTryBlockFragment fragment) {
        this.visit(fragment, TRY_TOKENS);
    }

    @Override
    public void visit(TokensFragment fragment) {
        for (Token token : fragment.getTokens()) {
            token.accept(this.unknownLineNumberTokenVisitor);
        }
    }

    protected void visit(StartStatementsBlockFragment fragment, Collection<Token> adds) {
        int minimalLineCount = fragment.getGroup().getMinimalLineCount();
        block0 : switch (fragment.getLineCount()) {
            case 0: {
                this.tokens.addAll(adds);
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)TextToken.SPACE);
                break;
            }
            case 1: {
                if (minimalLineCount == 0) {
                    this.tokens.add((Object)NewLineToken.NEWLINE_1);
                    this.tokens.addAll(adds);
                    this.tokens.add((Object)TextToken.SPACE);
                    this.tokens.add((Object)StartBlockToken.START_BLOCK);
                    this.tokens.add((Object)TextToken.SPACE);
                    break;
                }
                this.tokens.addAll(adds);
                this.tokens.add((Object)TextToken.SPACE);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            case 2: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)NewLineToken.NEWLINE_2);
                        this.tokens.addAll(adds);
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)TextToken.SPACE);
                        break block0;
                    }
                    case 1: {
                        this.tokens.add((Object)NewLineToken.NEWLINE_1);
                        this.tokens.addAll(adds);
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)NewLineToken.NEWLINE_1);
                        break block0;
                    }
                }
                this.tokens.addAll(adds);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                break;
            }
            default: {
                switch (minimalLineCount) {
                    case 0: {
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        this.tokens.addAll(adds);
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)TextToken.SPACE);
                        break block0;
                    }
                    case 1: {
                        this.tokens.addAll(adds);
                        this.tokens.add((Object)TextToken.SPACE);
                        this.tokens.add((Object)StartBlockToken.START_BLOCK);
                        this.tokens.add((Object)new NewLineToken(fragment.getLineCount()));
                        break block0;
                    }
                }
                this.tokens.addAll(adds);
                this.tokens.add((Object)NewLineToken.NEWLINE_1);
                this.tokens.add((Object)StartBlockToken.START_BLOCK);
                this.tokens.add((Object)new NewLineToken(fragment.getLineCount() - 1));
            }
        }
    }

    protected class KnownLineNumberTokenVisitor
    extends AbstractNopTokenVisitor {
        private int currentLineNumber;

        protected KnownLineNumberTokenVisitor() {
        }

        public void reset(int firstLineNumber) {
            this.currentLineNumber = firstLineNumber;
        }

        @Override
        public void visit(EndBlockToken token) {
            if (token == EndBlockToken.END_BLOCK) {
                throw new IllegalArgumentException("Unexpected EndBlockToken.END_BLOCK at this step. Uses 'JavaFragmentFactory.addEnd***(fragments)' instead");
            }
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(LineNumberToken token) {
            int lineNumber = token.lineNumber();
            if (lineNumber != 0) {
                if (this.currentLineNumber != 0) {
                    switch (lineNumber - this.currentLineNumber) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            TokenizeJavaFragmentVisitor.this.tokens.add((Object)NewLineToken.NEWLINE_1);
                            break;
                        }
                        case 2: {
                            TokenizeJavaFragmentVisitor.this.tokens.add((Object)NewLineToken.NEWLINE_2);
                            break;
                        }
                        default: {
                            TokenizeJavaFragmentVisitor.this.tokens.add((Object)new NewLineToken(lineNumber - this.currentLineNumber));
                        }
                    }
                }
                this.currentLineNumber = token.lineNumber();
                TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
            }
        }

        @Override
        public void visit(StartBlockToken token) {
            if (token == StartBlockToken.START_BLOCK) {
                throw new IllegalArgumentException("Unexpected StartBlockToken.START_BLOCK at this step. Uses 'JavaFragmentFactory.addStart***(fragments)' instead");
            }
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(BooleanConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(CharacterConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(DeclarationToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(EndMarkerToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(KeywordToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(NumericConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(ReferenceToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(StartMarkerToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(StringConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(TextToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }
    }

    protected class UnknownLineNumberTokenVisitor
    implements TokenVisitor {
        protected UnknownLineNumberTokenVisitor() {
        }

        @Override
        public void visit(EndBlockToken token) {
            if (token == EndBlockToken.END_BLOCK) {
                throw new IllegalArgumentException("Unexpected EndBlockToken.END_BLOCK at this step. Uses 'JavaFragmentFactory.addEnd***(fragments)' instead");
            }
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(LineNumberToken token) {
            if (token.lineNumber() != 0) {
                throw new IllegalArgumentException("LineNumberToken cannot have a known line number. Uses 'LineNumberTokensFragment' instead");
            }
        }

        @Override
        public void visit(StartBlockToken token) {
            if (token == StartBlockToken.START_BLOCK) {
                throw new IllegalArgumentException("Unexpected StartBlockToken.START_BLOCK at this step. Uses 'JavaFragmentFactory.addStart***(fragments)' instead");
            }
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(BooleanConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(CharacterConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(DeclarationToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(EndMarkerToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(KeywordToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(NewLineToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(NumericConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(ReferenceToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(StartMarkerToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(StringConstantToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }

        @Override
        public void visit(TextToken token) {
            TokenizeJavaFragmentVisitor.this.tokens.add((Object)token);
        }
    }
}

