/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.layouter.visitor;

import org.jd.core.v1.model.fragment.EndFlexibleBlockFragment;
import org.jd.core.v1.model.fragment.EndMovableBlockFragment;
import org.jd.core.v1.model.fragment.FixedFragment;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.model.fragment.FragmentVisitor;
import org.jd.core.v1.model.fragment.SpacerBetweenMovableBlocksFragment;
import org.jd.core.v1.model.fragment.StartFlexibleBlockFragment;
import org.jd.core.v1.model.fragment.StartMovableBlockFragment;
import org.jd.core.v1.util.DefaultList;

public class UpdateSpacerBetweenMovableBlocksVisitor
implements FragmentVisitor {
    private final DefaultList<StartMovableBlockFragment> blocks = new DefaultList();
    private final DefaultList<SpacerBetweenMovableBlocksFragment> spacers = new DefaultList();
    private int lastStartMovableBlockFragmentType;
    private SpacerBetweenMovableBlocksFragment lastSpacer;
    private int depth;

    public void reset() {
        this.lastStartMovableBlockFragmentType = 0;
        this.lastSpacer = null;
        this.depth = 0;
    }

    @Override
    public void visit(StartMovableBlockFragment fragment) {
        if (this.lastSpacer != null) {
            if (this.lastStartMovableBlockFragmentType == 2 && fragment.getType() == 2) {
                this.lastSpacer.setInitialLineCount(1);
            } else {
                this.lastSpacer.setInitialLineCount(2);
            }
        }
        if (this.depth != 0) {
            this.blocks.add((Object)fragment);
            this.spacers.add((Object)this.lastSpacer);
            this.lastSpacer = null;
        }
        this.lastStartMovableBlockFragmentType = fragment.getType();
        this.depth = 1;
    }

    @Override
    public void visit(EndMovableBlockFragment fragment) {
        if (this.depth != 1) {
            this.lastSpacer = (SpacerBetweenMovableBlocksFragment)this.spacers.remove(this.spacers.size() - 1);
            this.lastStartMovableBlockFragmentType = ((StartMovableBlockFragment)this.blocks.removeLast()).getType();
        }
        this.depth = 0;
    }

    @Override
    public void visit(SpacerBetweenMovableBlocksFragment fragment) {
        this.lastSpacer = fragment;
    }

    @Override
    public void visit(FlexibleFragment fragment) {
    }

    @Override
    public void visit(EndFlexibleBlockFragment fragment) {
    }

    @Override
    public void visit(StartFlexibleBlockFragment fragment) {
    }

    @Override
    public void visit(FixedFragment fragment) {
    }
}

