/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.layouter;

import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.fragment.FixedFragment;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.model.fragment.Fragment;
import org.jd.core.v1.model.message.DecompileContext;
import org.jd.core.v1.service.layouter.model.Section;
import org.jd.core.v1.service.layouter.util.VisitorsHolder;
import org.jd.core.v1.service.layouter.visitor.BuildSectionsVisitor;
import org.jd.core.v1.service.layouter.visitor.UpdateSpacerBetweenMovableBlocksVisitor;
import org.jd.core.v1.util.DefaultList;

public class LayoutFragmentProcessor {
    public void process(DecompileContext decompileContext) {
        int maxLineNumber = decompileContext.getMaxLineNumber();
        Map<String, Object> configuration = decompileContext.getConfiguration();
        String realignLineNumbersConfiguration = configuration == null ? "false" : configuration.get("realignLineNumbers");
        boolean realignLineNumbers = realignLineNumbersConfiguration != null && "true".equals(realignLineNumbersConfiguration.toString());
        List fragments = (List)decompileContext.getBody();
        if (maxLineNumber != 0 && realignLineNumbers) {
            BuildSectionsVisitor buildSectionsVisitor = new BuildSectionsVisitor();
            for (Fragment fragment : fragments) {
                fragment.accept(buildSectionsVisitor);
            }
            DefaultList<Section> sections = buildSectionsVisitor.getSections();
            VisitorsHolder holder = new VisitorsHolder();
            UpdateSpacerBetweenMovableBlocksVisitor visitor = new UpdateSpacerBetweenMovableBlocksVisitor();
            int sumOfRates = Integer.MAX_VALUE;
            int max = sections.size() * 2;
            if (max > 20) {
                max = 20;
            }
            for (int loop = 0; loop < max; ++loop) {
                visitor.reset();
                for (Section section : sections) {
                    for (FlexibleFragment fragment : section.getFlexibleFragments()) {
                        fragment.accept(visitor);
                    }
                    if (section.getFixedFragment() == null) continue;
                    section.getFixedFragment().accept(visitor);
                }
                for (int redo = 0; redo < 10; ++redo) {
                    boolean changed = false;
                    for (Section section : sections) {
                        changed |= section.layout(false);
                    }
                    if (!changed) break;
                }
                int newSumOfRates = 0;
                Section mostConstrainedSection = (Section)sections.get(0);
                for (Section section : sections) {
                    section.updateRate();
                    if (mostConstrainedSection.getRate() < section.getRate()) {
                        mostConstrainedSection = section;
                    }
                    newSumOfRates += section.getRate();
                }
                if (mostConstrainedSection.getRate() == 0 || sumOfRates <= newSumOfRates) break;
                sumOfRates = newSumOfRates;
                if (!mostConstrainedSection.releaseConstraints(holder)) break;
            }
            for (Section section : sections) {
                section.layout(true);
            }
            fragments.clear();
            for (Section section : sections) {
                fragments.addAll(section.getFlexibleFragments());
                FixedFragment fixedFragment = section.getFixedFragment();
                if (fixedFragment == null) continue;
                fragments.add(fixedFragment);
            }
        }
    }
}

