/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.fragment.Fragment;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javafragment.StartSingleStatementBlockFragment;
import org.jd.core.v1.model.javafragment.StartStatementsBlockFragment;
import org.jd.core.v1.model.javafragment.TokensFragment;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.JavaFragmentFactory;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.ExpressionVisitor;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.TypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class StatementVisitor
extends ExpressionVisitor {
    public static final KeywordToken ASSERT = new KeywordToken("assert");
    public static final KeywordToken BREAK = new KeywordToken("break");
    public static final KeywordToken CASE = new KeywordToken("case");
    public static final KeywordToken CATCH = new KeywordToken("catch");
    public static final KeywordToken CONTINUE = new KeywordToken("continue");
    public static final KeywordToken DEFAULT = new KeywordToken("default");
    public static final KeywordToken ELSE = new KeywordToken("else");
    public static final KeywordToken FINAL = new KeywordToken("final");
    public static final KeywordToken FINALLY = new KeywordToken("finally");
    public static final KeywordToken FOR = new KeywordToken("for");
    public static final KeywordToken IF = new KeywordToken("if");
    public static final KeywordToken RETURN = new KeywordToken("return");
    public static final KeywordToken STRICT = new KeywordToken("strictfp");
    public static final KeywordToken SYNCHRONIZED = new KeywordToken("synchronized");
    public static final KeywordToken SWITCH = new KeywordToken("switch");
    public static final KeywordToken THROW = new KeywordToken("throw");
    public static final KeywordToken TRANSIENT = new KeywordToken("transient");
    public static final KeywordToken TRY = new KeywordToken("try");
    public static final KeywordToken VOLATILE = new KeywordToken("volatile");
    public static final KeywordToken WHILE = new KeywordToken("while");

    public StatementVisitor(Loader loader, String mainInternalTypeName, int majorVersion, ImportsFragment importsFragment) {
        super(loader, mainInternalTypeName, majorVersion, importsFragment);
    }

    @Override
    public void visit(AssertStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.add(ASSERT);
        this.tokens.add(TextToken.SPACE);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        Expression msg = statement.getMessage();
        if (msg != null) {
            this.tokens.add(TextToken.SPACE_COLON_SPACE);
            msg.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(BreakStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.addLineNumberToken(statement.getLineNumber());
        this.tokens.add(BREAK);
        if (statement.getLabel() != null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(statement.getLabel()));
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(CommentStatement statement) {
        this.visitComment(statement.getText());
    }

    protected void visitComment(String text) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartMarkerToken.COMMENT);
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            this.tokens.add(new TextToken(st.nextToken()));
            this.tokens.add(NewLineToken.NEWLINE_1);
        }
        this.tokens.remove(this.tokens.size() - 1);
        this.tokens.add(EndMarkerToken.COMMENT);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ContinueStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(CONTINUE);
        if (statement.getLabel() != null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(statement.getLabel()));
        }
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(DoWhileStatement statement) {
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsDoWhileBlock((List<Fragment>)((Object)this.fragments));
        this.safeAccept(statement.getStatements());
        JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(WHILE);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.tokens.add(TextToken.SEMICOLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ExpressionStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.safeAccept((BaseExpression)statement.getExpression());
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ForStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(FOR);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        this.safeAccept((Declaration)statement.getDeclaration());
        this.safeAccept(statement.getInit());
        if (statement.getCondition() == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            this.tokens.add(TextToken.SEMICOLON_SPACE);
            statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        if (statement.getUpdate() == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            this.tokens.add(TextToken.SEMICOLON_SPACE);
            statement.getUpdate().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        this.visitLoopStatements(statement.getStatements());
    }

    @Override
    public void visit(ForEachStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(FOR);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        if (statement.isFinal()) {
            this.tokens.add(FINAL);
            this.tokens.add(TextToken.SPACE);
        }
        Type type = statement.getType();
        type.accept((TypeVisitor)this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(this.newTextToken(statement.getName()));
        this.tokens.add(TextToken.SPACE_COLON_SPACE);
        statement.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.visitLoopStatements(statement.getStatements());
    }

    protected void visitLoopStatements(BaseStatement statements) {
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        if (statements == null) {
            this.tokens.add(TextToken.SEMICOLON);
        } else {
            ExpressionVisitor.Fragments tmp = this.fragments;
            this.fragments = new ExpressionVisitor.Fragments();
            statements.accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            switch (this.fragments.size()) {
                case 0: {
                    this.tokens.add(TextToken.SEMICOLON);
                    break;
                }
                case 1: {
                    StartSingleStatementBlockFragment start = JavaFragmentFactory.addStartSingleStatementBlock((List<Fragment>)((Object)tmp));
                    tmp.addAll((Collection)((Object)this.fragments));
                    JavaFragmentFactory.addEndSingleStatementBlock((List<Fragment>)((Object)tmp), start);
                    break;
                }
                default: {
                    StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)tmp));
                    tmp.addAll((Collection)((Object)this.fragments));
                    JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)tmp), group);
                }
            }
            this.fragments = tmp;
        }
    }

    @Override
    public void visit(IfStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(IF);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        BaseStatement stmt = statement.getStatements();
        if (stmt == null) {
            this.fragments.add(TokensFragment.SEMICOLON);
        } else {
            ExpressionVisitor.Fragments tmp = this.fragments;
            this.fragments = new ExpressionVisitor.Fragments();
            stmt.accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            switch (stmt.size()) {
                case 0: {
                    tmp.add(TokensFragment.SEMICOLON);
                    break;
                }
                case 1: {
                    StartSingleStatementBlockFragment start = JavaFragmentFactory.addStartSingleStatementBlock((List<Fragment>)((Object)tmp));
                    tmp.addAll((Collection)((Object)this.fragments));
                    JavaFragmentFactory.addEndSingleStatementBlock((List<Fragment>)((Object)tmp), start);
                    break;
                }
                default: {
                    StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)tmp));
                    tmp.addAll((Collection)((Object)this.fragments));
                    JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)tmp), group);
                }
            }
            this.fragments = tmp;
        }
    }

    @Override
    public void visit(IfElseStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(IF);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments));
        statement.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        this.visitElseStatements(statement.getElseStatements(), group);
    }

    protected void visitElseStatements(BaseStatement elseStatements, StartStatementsBlockFragment.Group group) {
        BaseStatement statementList = elseStatements;
        if (elseStatements.isList() && elseStatements.size() == 1) {
            statementList = (BaseStatement)elseStatements.getFirst();
        }
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(ELSE);
        if (statementList.isIfElseStatement()) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(IF);
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
            statementList.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
            this.fragments.addTokensFragment(this.tokens);
            JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments), group);
            statementList.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
            this.visitElseStatements(statementList.getElseStatements(), group);
        } else {
            if (statementList.isIfStatement()) {
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(IF);
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
                statementList.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
                this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
                this.fragments.addTokensFragment(this.tokens);
                JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments), group);
                statementList.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            } else {
                this.fragments.addTokensFragment(this.tokens);
                JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments), group);
                elseStatements.accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
            JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        }
    }

    @Override
    public void visit(LabelStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(this.newTextToken(statement.label()));
        this.tokens.add(TextToken.COLON);
        if (statement.statement() == null) {
            this.fragments.addTokensFragment(this.tokens);
        } else {
            this.tokens.add(TextToken.SPACE);
            this.fragments.addTokensFragment(this.tokens);
            statement.statement().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        }
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        statement.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
    }

    @Override
    public void visit(LocalVariableDeclarationStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        if (statement.isFinal()) {
            this.tokens.add(FINAL);
            this.tokens.add(TextToken.SPACE);
        }
        Type type = statement.getType();
        type.accept((TypeVisitor)this);
        this.tokens.add(TextToken.SPACE);
        statement.getLocalVariableDeclarators().accept((DeclarationVisitor)this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.addLineNumberToken(statement.getLineNumber());
        this.tokens.add(RETURN);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(ReturnStatement statement) {
        this.fragments.add(TokensFragment.RETURN_SEMICOLON);
    }

    @Override
    public void visit(Statements list) {
        int size = list.size();
        if (size > 0) {
            Iterator iterator = list.iterator();
            ((Statement)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            for (int i = 1; i < size; ++i) {
                JavaFragmentFactory.addSpacerBetweenStatements((List<Fragment>)((Object)this.fragments));
                ((Statement)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
        }
    }

    @Override
    public void visit(SwitchStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(SWITCH);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
        StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments));
        Iterator iterator = statement.getBlocks().iterator();
        if (iterator.hasNext()) {
            ((SwitchStatement.Block)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            while (iterator.hasNext()) {
                JavaFragmentFactory.addSpacerBetweenSwitchLabelBlock((List<Fragment>)((Object)this.fragments));
                ((SwitchStatement.Block)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
        }
        JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        JavaFragmentFactory.addSpacerAfterEndStatementsBlock((List<Fragment>)((Object)this.fragments));
    }

    @Override
    public void visit(SwitchStatement.LabelBlock statement) {
        statement.getLabel().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        JavaFragmentFactory.addSpacerAfterSwitchLabel((List<Fragment>)((Object)this.fragments));
        statement.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        JavaFragmentFactory.addSpacerAfterSwitchBlock((List<Fragment>)((Object)this.fragments));
    }

    @Override
    public void visit(SwitchStatement.DefaultLabel statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(DEFAULT);
        this.tokens.add(TextToken.COLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(SwitchStatement.ExpressionLabel statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(CASE);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(TextToken.COLON);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(SwitchStatement.MultiLabelsBlock statement) {
        Iterator iterator = statement.getLabels().iterator();
        if (iterator.hasNext()) {
            ((SwitchStatement.Label)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            while (iterator.hasNext()) {
                JavaFragmentFactory.addSpacerBetweenSwitchLabels((List<Fragment>)((Object)this.fragments));
                ((SwitchStatement.Label)iterator.next()).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
        }
        JavaFragmentFactory.addSpacerAfterSwitchLabel((List<Fragment>)((Object)this.fragments));
        statement.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        JavaFragmentFactory.addSpacerAfterSwitchBlock((List<Fragment>)((Object)this.fragments));
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(SYNCHRONIZED);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getMonitor().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        BaseStatement statements = statement.getStatements();
        if (statements == null) {
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(TextToken.LEFTRIGHTCURLYBRACKETS);
            this.fragments.addTokensFragment(this.tokens);
        } else {
            this.fragments.addTokensFragment(this.tokens);
            StartStatementsBlockFragment.Group group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments));
            statements.accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(StartBlockToken.START_DECLARATION_OR_STATEMENT_BLOCK);
        this.tokens.add(THROW);
        this.tokens.add(TextToken.SPACE);
        statement.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(TextToken.SEMICOLON);
        this.tokens.add(EndBlockToken.END_DECLARATION_OR_STATEMENT_BLOCK);
        this.fragments.addTokensFragment(this.tokens);
    }

    @Override
    public void visit(TryStatement statement) {
        StartStatementsBlockFragment.Group group;
        DefaultList resources = statement.getResources();
        if (resources == null) {
            group = JavaFragmentFactory.addStartStatementsTryBlock((List<Fragment>)((Object)this.fragments));
        } else {
            int size = resources.size();
            assert (size > 0);
            this.tokens = new TypeVisitor.Tokens(this);
            this.tokens.add(TRY);
            if (size == 1) {
                this.tokens.add(TextToken.SPACE);
            }
            this.tokens.add(StartBlockToken.START_RESOURCES_BLOCK);
            ((TryStatement.Resource)resources.get(0)).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            for (int i = 1; i < size; ++i) {
                this.tokens.add(TextToken.SEMICOLON_SPACE);
                ((TryStatement.Resource)resources.get(i)).accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
            this.tokens.add(EndBlockToken.END_RESOURCES_BLOCK);
            this.fragments.addTokensFragment(this.tokens);
            group = JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments));
        }
        this.visitTryStatement(statement, group);
    }

    @Override
    public void visit(TryStatement.Resource resource) {
        Expression expression = resource.getExpression();
        this.tokens.addLineNumberToken(expression);
        ObjectType type = resource.getType();
        type.accept((TypeVisitor)this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(this.newTextToken(resource.getName()));
        this.tokens.add(TextToken.SPACE_EQUAL_SPACE);
        expression.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
    }

    protected void visitTryStatement(TryStatement statement, StartStatementsBlockFragment.Group group) {
        int fragmentCount1;
        int fragmentCount2 = fragmentCount1 = this.fragments.size();
        statement.getTryStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        if (statement.getCatchClauses() != null) {
            for (TryStatement.CatchClause cc : statement.getCatchClauses()) {
                JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
                ObjectType type = cc.getType();
                this.tokens = new TypeVisitor.Tokens(this);
                this.tokens.add(CATCH);
                this.tokens.add(TextToken.SPACE_LEFTROUNDBRACKET);
                if (cc.isFinal()) {
                    this.tokens.add(FINAL);
                    this.tokens.add(TextToken.SPACE);
                }
                type.accept((TypeVisitor)this);
                if (cc.getOtherTypes() != null) {
                    for (BaseType otherType : cc.getOtherTypes()) {
                        this.tokens.add(TextToken.VERTICALLINE);
                        otherType.accept((TypeVisitor)this);
                    }
                }
                this.tokens.add(TextToken.SPACE);
                this.tokens.add(this.newTextToken(cc.getName()));
                this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                int lineNumber = cc.getLineNumber();
                if (lineNumber != 0) {
                    this.tokens.addLineNumberToken(lineNumber);
                }
                this.fragments.addTokensFragment(this.tokens);
                fragmentCount1 = this.fragments.size();
                JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments), group);
                fragmentCount2 = this.fragments.size();
                cc.getStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
            }
        }
        if (statement.getFinallyStatements() != null) {
            JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
            this.tokens = new TypeVisitor.Tokens(this);
            this.tokens.add(FINALLY);
            this.fragments.addTokensFragment(this.tokens);
            fragmentCount1 = this.fragments.size();
            JavaFragmentFactory.addStartStatementsBlock((List<Fragment>)((Object)this.fragments), group);
            fragmentCount2 = this.fragments.size();
            statement.getFinallyStatements().accept((org.jd.core.v1.model.javasyntax.statement.StatementVisitor)this);
        }
        if (fragmentCount2 == this.fragments.size()) {
            this.fragments.subList(fragmentCount1, fragmentCount2).clear();
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(TextToken.LEFTRIGHTCURLYBRACKETS);
        } else {
            JavaFragmentFactory.addEndStatementsBlock((List<Fragment>)((Object)this.fragments), group);
        }
    }

    @Override
    public void visit(TypeDeclarationStatement statement) {
        statement.typeDeclaration().accept((DeclarationVisitor)this);
        this.fragments.add(TokensFragment.SEMICOLON);
    }

    @Override
    public void visit(WhileStatement statement) {
        this.tokens = new TypeVisitor.Tokens(this);
        this.tokens.add(WHILE);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        statement.getCondition().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.visitLoopStatements(statement.getStatements());
    }
}

