/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.fragment.Fragment;
import org.jd.core.v1.model.javafragment.ImportsFragment;
import org.jd.core.v1.model.javafragment.LineNumberTokensFragment;
import org.jd.core.v1.model.javafragment.StartBlockFragment;
import org.jd.core.v1.model.javafragment.StartBodyFragment;
import org.jd.core.v1.model.javafragment.TokensFragment;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.CommentExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaFormalParametersExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NoExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.ParenthesesExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.QualifiedSuperExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.token.BooleanConstantToken;
import org.jd.core.v1.model.token.CharacterConstantToken;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.NumericConstantToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.StringConstantToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.CharacterUtil;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.JavaFragmentFactory;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.util.StringUtil;
import org.jd.core.v1.service.fragmenter.javasyntaxtojavafragment.visitor.TypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class ExpressionVisitor
extends TypeVisitor {
    private static final String[] BIN_OPS = new String[]{"&", "&=", "^", "^=", "|", "|="};
    public static final KeywordToken CLASS = new KeywordToken("class");
    public static final KeywordToken FALSE = new KeywordToken("false");
    public static final KeywordToken INSTANCEOF = new KeywordToken("instanceof");
    public static final KeywordToken LENGTH = new KeywordToken("length");
    public static final KeywordToken NEW = new KeywordToken("new");
    public static final KeywordToken NULL = new KeywordToken("null");
    public static final KeywordToken THIS = new KeywordToken("this");
    public static final KeywordToken TRUE = new KeywordToken("true");
    protected static final int UNKNOWN_LINE_NUMBER = 0;
    protected final LinkedList<Context> contextStack = new LinkedList();
    protected Fragments fragments = new Fragments();
    protected boolean inExpressionFlag;
    protected boolean inInvokeNewFlag;
    protected boolean inVarArgMethod;
    protected boolean inVarArgParam;
    protected int parameterTypeCount;
    protected Set<String> currentMethodParamNames = new HashSet<String>();
    protected String currentTypeName;
    private final HexaExpressionVisitor hexaExpressionVisitor = new HexaExpressionVisitor();
    private final int majorVersion;

    public ExpressionVisitor(Loader loader, String mainInternalTypeName, int majorVersion, ImportsFragment importsFragment) {
        super(loader, mainInternalTypeName, majorVersion, importsFragment);
        this.majorVersion = majorVersion;
    }

    public DefaultList<Fragment> getFragments() {
        return this.fragments;
    }

    public String getCurrentTypeInternalName() {
        return this.currentType == null ? null : this.currentType.getInternalName();
    }

    @Override
    protected boolean isInInvokeNew() {
        return this.inInvokeNewFlag;
    }

    @Override
    public void visit(ArrayExpression expression) {
        this.visit((Expression)expression, expression.getExpression());
        this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
        expression.getIndex().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        if (Arrays.binarySearch(BIN_OPS, expression.getOperator()) >= 0) {
            this.visitHexa((Expression)expression, expression.getLeftExpression());
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(expression.getOperator()));
            this.tokens.add(TextToken.SPACE);
            this.visitHexa((Expression)expression, expression.getRightExpression());
        } else {
            this.visit((Expression)expression, expression.getLeftExpression());
            this.tokens.add(TextToken.SPACE);
            this.tokens.add(this.newTextToken(expression.getOperator()));
            this.tokens.add(TextToken.SPACE);
            this.visit((Expression)expression, expression.getRightExpression());
        }
    }

    @Override
    public void visit(BooleanExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        if (expression.isTrue()) {
            this.tokens.add(TRUE);
        } else {
            this.tokens.add(FALSE);
        }
    }

    @Override
    public void visit(CastExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken((Expression)expression);
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            Type type = expression.getType();
            type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        }
        this.visit((Expression)expression, expression.getExpression());
    }

    @Override
    public void visit(CommentExpression expression) {
        this.tokens.add(StartMarkerToken.COMMENT);
        this.tokens.add(this.newTextToken(expression.text()));
        this.tokens.add(EndMarkerToken.COMMENT);
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(THIS);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
        ObjectType ot = expression.getObjectType();
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(this.newTypeReferenceToken(ot, this.currentType));
        this.tokens.add(TextToken.COLON_COLON);
        this.tokens.add(NEW);
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getDoubleValue()) + "D"));
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        ObjectType type = expression.getObjectType();
        this.tokens.add(new ReferenceToken(2, type.getInternalName(), expression.getName(), type.getDescriptor(), this.currentType));
    }

    @Override
    public void visit(Expressions list) {
        int size;
        if (list != null && (size = list.size()) > 0) {
            boolean ief = this.inExpressionFlag;
            boolean ivapf = this.inVarArgParam;
            Iterator iterator = list.iterator();
            while (size-- > 1) {
                NewArray newArray;
                this.inExpressionFlag = true;
                boolean bl = this.inVarArgParam = this.inVarArgMethod && list.size() - size >= this.parameterTypeCount;
                if (size == 1 && list.getLast() instanceof NewArray && (newArray = (NewArray)list.getLast()).isEmptyNewArray()) {
                    this.inExpressionFlag = false;
                }
                ((Expression)iterator.next()).accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
                this.inVarArgParam = ivapf;
                if (this.tokens.isEmpty()) continue;
                this.tokens.add(TextToken.COMMA_SPACE);
            }
            this.inExpressionFlag = false;
            this.inVarArgParam = this.inVarArgMethod && list.size() - size >= this.parameterTypeCount;
            ((Expression)iterator.next()).accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.inExpressionFlag = ief;
            this.inVarArgParam = ivapf;
        }
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        if (expression.getExpression() == null) {
            this.tokens.addLineNumberToken((Expression)expression);
            this.tokens.add(new TextToken(expression.getName()));
        } else {
            this.tokens.addLineNumberToken(expression.getExpression());
            int delta = this.tokens.size();
            if ("this".equals(expression.getName()) && expression.getExpression() instanceof ObjectTypeReferenceExpression && expression.getExpression().getObjectType() instanceof InnerObjectType) {
                InnerObjectType innerObjectType = (InnerObjectType)expression.getExpression().getObjectType();
                InnerObjectType newObjectType = (InnerObjectType)innerObjectType.createType(innerObjectType.getTypeArguments());
                newObjectType.setOuterType(null);
                expression.setExpression((Expression)new ObjectTypeReferenceExpression((ObjectType)newObjectType));
            }
            this.visit((Expression)expression, expression.getExpression());
            this.tokens.addLineNumberToken((Expression)expression);
            if ((delta -= this.tokens.size()) != 0) {
                this.tokens.add(TextToken.DOT);
            }
            this.tokens.add(new ReferenceToken(2, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentType));
        }
    }

    @Override
    public void visit(FloatConstantExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getFloatValue()) + "F"));
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        PrimitiveType pt = (PrimitiveType)expression.getType();
        switch (pt.getJavaPrimitiveFlags()) {
            case 2: {
                this.tokens.add(new CharacterConstantToken(CharacterUtil.escapeChar((char)expression.getIntegerValue()), this.getCurrentTypeInternalName()));
                break;
            }
            case 1: {
                this.tokens.add(new BooleanConstantToken(expression.getIntegerValue() != 0));
                break;
            }
            default: {
                this.tokens.add(new NumericConstantToken(String.valueOf(expression.getIntegerValue())));
            }
        }
    }

    @Override
    public void visit(InstanceOfExpression expression) {
        expression.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(TextToken.SPACE);
        this.tokens.add(INSTANCEOF);
        this.tokens.add(TextToken.SPACE);
        Type type = expression.getInstanceOfType();
        type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
    }

    @Override
    public void visit(LambdaFormalParametersExpression expression) {
        BaseFormalParameter parameters = expression.getFormalParameters();
        if (parameters == null) {
            this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
        } else {
            int size = parameters.size();
            switch (size) {
                case 0: {
                    this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
                    break;
                }
                case 1: {
                    ((FormalParameter)parameters.getFirst()).accept((DeclarationVisitor)this);
                    break;
                }
                default: {
                    this.tokens.add(TextToken.LEFTROUNDBRACKET);
                    Iterator iterator = parameters.iterator();
                    ((FormalParameter)iterator.next()).accept((DeclarationVisitor)this);
                    while (iterator.hasNext()) {
                        this.tokens.add(TextToken.COMMA_SPACE);
                        ((FormalParameter)iterator.next()).accept((DeclarationVisitor)this);
                    }
                    this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                }
            }
        }
        this.visitLambdaBody(expression.getStatements());
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        List parameters = expression.getParameterNames();
        if (parameters == null) {
            this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
        } else {
            int size = parameters.size();
            switch (size) {
                case 0: {
                    this.tokens.add(TextToken.LEFTRIGHTROUNDBRACKETS);
                    break;
                }
                case 1: {
                    this.tokens.add(this.newTextToken((String)parameters.get(0)));
                    break;
                }
                default: {
                    this.tokens.add(TextToken.LEFTROUNDBRACKET);
                    this.tokens.add(this.newTextToken((String)parameters.get(0)));
                    for (int i = 1; i < size; ++i) {
                        this.tokens.add(TextToken.COMMA_SPACE);
                        this.tokens.add(this.newTextToken((String)parameters.get(i)));
                    }
                    this.tokens.add(TextToken.RIGHTROUNDBRACKET);
                }
            }
        }
        this.visitLambdaBody(expression.getStatements());
    }

    protected void visitLambdaBody(BaseStatement statementList) {
        if (statementList != null) {
            this.tokens.add(TextToken.SPACE_ARROW_SPACE);
            if (statementList.isLambdaExpressionStatement()) {
                statementList.accept((StatementVisitor)this);
            } else {
                this.fragments.addTokensFragment(this.tokens);
                StartBlockFragment start = JavaFragmentFactory.addStartStatementsInLambdaBlock((List<Fragment>)((Object)this.fragments));
                this.tokens = new TypeVisitor.Tokens(this);
                statementList.accept((StatementVisitor)this);
                if (this.inExpressionFlag) {
                    JavaFragmentFactory.addEndStatementsInLambdaBlockInParameter((List<Fragment>)((Object)this.fragments), start);
                } else {
                    JavaFragmentFactory.addEndStatementsInLambdaBlock((List<Fragment>)((Object)this.fragments), start);
                }
                this.tokens = new TypeVisitor.Tokens(this);
            }
        }
    }

    @Override
    public void visit(LengthExpression expression) {
        this.visit((Expression)expression, expression.getExpression());
        this.tokens.add(TextToken.DOT);
        this.tokens.add(LENGTH);
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(this.newTextToken(expression.getName()));
    }

    @Override
    public void visit(LongConstantExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(new NumericConstantToken(String.valueOf(expression.getLongValue()) + "L"));
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        Expression exp = expression.getExpression();
        BaseTypeArgument nonWildcardTypeArguments = expression.getNonWildcardTypeArguments();
        BaseExpression parameters = expression.getParameters();
        boolean dot = false;
        if (!exp.isThisExpression()) {
            if (exp.isObjectTypeReferenceExpression()) {
                ObjectType ot = exp.getObjectType();
                if (expression.getNonWildcardTypeArguments() != null || !ot.getInternalName().equals(this.getCurrentTypeInternalName())) {
                    this.visit((Expression)expression, exp);
                    this.tokens.addLineNumberToken((Expression)expression);
                    this.tokens.add(TextToken.DOT);
                    dot = true;
                }
            } else {
                if (exp.isFieldReferenceExpression() || exp.isLocalVariableReferenceExpression()) {
                    this.tokens.addLineNumberToken((Expression)expression);
                    this.visit((Expression)expression, exp);
                } else {
                    if (exp instanceof NewExpression) {
                        NewExpression newExpression = (NewExpression)exp;
                        newExpression.setDiamondPossible(false);
                    }
                    this.visit((Expression)expression, exp);
                    this.tokens.addLineNumberToken((Expression)expression);
                }
                this.tokens.add(TextToken.DOT);
                dot = true;
            }
        }
        this.tokens.addLineNumberToken((Expression)expression);
        if (nonWildcardTypeArguments != null && dot) {
            this.tokens.add(TextToken.LEFTANGLEBRACKET);
            nonWildcardTypeArguments.accept((TypeArgumentVisitor)this);
            this.tokens.add(TextToken.RIGHTANGLEBRACKET);
        }
        this.tokens.add(new ReferenceToken(3, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentType));
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        if (parameters != null) {
            boolean ief = this.inExpressionFlag;
            boolean ivmf = this.inVarArgMethod;
            boolean ivpf = this.inVarArgParam;
            this.inExpressionFlag = false;
            this.inVarArgMethod = expression.isVarArgs();
            if (expression instanceof ClassFileMethodInvocationExpression) {
                ClassFileMethodInvocationExpression mie = (ClassFileMethodInvocationExpression)expression;
                this.parameterTypeCount = mie.getParameterTypes() == null ? 0 : mie.getParameterTypes().size();
            }
            this.inVarArgParam = this.inVarArgMethod && parameters.size() == 1;
            parameters.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.inExpressionFlag = ief;
            this.inVarArgMethod = ivmf;
            this.inVarArgParam = ivpf;
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(MethodReferenceExpression expression) {
        expression.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(TextToken.COLON_COLON);
        this.tokens.add(new ReferenceToken(3, expression.getInternalTypeName(), expression.getName(), expression.getDescriptor(), this.currentType));
    }

    @Override
    public void visit(NewArray expression) {
        if (this.inVarArgParam && expression.isEmptyNewArray()) {
            if (!this.tokens.isEmpty() && TextToken.COMMA_SPACE.equals(this.tokens.get(this.tokens.size() - 1))) {
                this.tokens.remove(this.tokens.size() - 1);
            }
            return;
        }
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(NEW);
        this.tokens.add(TextToken.SPACE);
        Type type = expression.getType();
        type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
        BaseExpression dimensionExpressionList = expression.getDimensionExpressionList();
        int dimension = expression.getType().getDimension();
        if (dimension > 0) {
            this.tokens.remove(this.tokens.size() - 1);
        }
        if (dimensionExpressionList != null) {
            if (dimensionExpressionList.isList()) {
                Iterator iterator = dimensionExpressionList.iterator();
                while (iterator.hasNext()) {
                    this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
                    ((Expression)iterator.next()).accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
                    this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
                    --dimension;
                }
            } else {
                this.tokens.add(StartBlockToken.START_ARRAY_BLOCK);
                dimensionExpressionList.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
                this.tokens.add(EndBlockToken.END_ARRAY_BLOCK);
                --dimension;
            }
        }
        this.visitDimension(dimension);
    }

    @Override
    public void visit(NewInitializedArray expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        if (this.inVarArgParam && expression.getArrayInitializer() != null) {
            ArrayVariableInitializer arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer.isList()) {
                Iterator iterator = arrayInitializer.getList().iterator();
                while (iterator.hasNext()) {
                    this.safeAccept((Declaration)iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.tokens.add(TextToken.COMMA_SPACE);
                }
            } else {
                this.safeAccept((Declaration)arrayInitializer.getFirst());
            }
        } else {
            this.tokens.add(NEW);
            this.tokens.add(TextToken.SPACE);
            Type type = expression.getType();
            type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
            this.tokens.add(TextToken.SPACE);
            expression.getArrayInitializer().accept((DeclarationVisitor)this);
        }
    }

    @Override
    public void visit(NewExpression expression) {
        this.inInvokeNewFlag = true;
        BodyDeclaration bodyDeclaration = expression.getBodyDeclaration();
        this.tokens.addLineNumberToken((Expression)expression);
        if (expression.getQualifier() != null) {
            expression.getQualifier().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.tokens.add(TextToken.DOT);
        }
        this.tokens.add(NEW);
        this.tokens.add(TextToken.SPACE);
        ObjectType objectType = expression.getObjectType();
        if (objectType.getTypeArguments() != null && expression.isDiamondPossible() && this.majorVersion >= 51) {
            objectType = objectType.createType((BaseTypeArgument)DiamondTypeArgument.DIAMOND);
        }
        if (objectType instanceof InnerObjectType && expression.getQualifier() != null) {
            InnerObjectType innerObjectType = (InnerObjectType)objectType;
            InnerObjectType newObjectType = (InnerObjectType)innerObjectType.createType(innerObjectType.getTypeArguments());
            newObjectType.setOuterType(null);
            expression.setObjectType((ObjectType)newObjectType);
            objectType = expression.getObjectType();
        }
        ObjectType type = objectType;
        type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
        if (bodyDeclaration != null) {
            this.fragments.addTokensFragment(this.tokens);
            StartBodyFragment start = JavaFragmentFactory.addStartTypeBody((List<Fragment>)((Object)this.fragments));
            ObjectType ot = expression.getObjectType();
            this.storeContext();
            this.currentType = this.typeMaker.makeFromInternalTypeName(bodyDeclaration.getInternalTypeName());
            this.currentTypeName = ot.getName();
            bodyDeclaration.accept((DeclarationVisitor)this);
            if (!this.tokens.isEmpty()) {
                this.tokens = new TypeVisitor.Tokens(this);
            }
            this.restoreContext();
            if (this.inExpressionFlag) {
                JavaFragmentFactory.addEndSubTypeBodyInParameter((List<Fragment>)((Object)this.fragments), start);
            } else {
                JavaFragmentFactory.addEndSubTypeBody((List<Fragment>)((Object)this.fragments), start);
            }
            this.tokens = new TypeVisitor.Tokens(this);
        }
        this.inInvokeNewFlag = false;
    }

    @Override
    public void visit(NullExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(NULL);
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken((Expression)expression);
            Type type = expression.getType();
            type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
        }
    }

    @Override
    public void visit(ParenthesesExpression expression) {
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        expression.getExpression().accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(PostOperatorExpression expression) {
        this.visit((Expression)expression, expression.getExpression());
        this.tokens.add(this.newTextToken(expression.getOperator()));
    }

    @Override
    public void visit(PreOperatorExpression expression) {
        this.tokens.addLineNumberToken(expression.getExpression());
        this.tokens.add(this.newTextToken(expression.getOperator()));
        this.visit((Expression)expression, expression.getExpression());
    }

    @Override
    public void visit(StringConstantExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(new StringConstantToken(StringUtil.escapeString(expression.getStringValue()), this.getCurrentTypeInternalName()));
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(SUPER);
        this.tokens.add(StartBlockToken.START_PARAMETERS_BLOCK);
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            parameters.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
        this.tokens.add(EndBlockToken.END_PARAMETERS_BLOCK);
    }

    @Override
    public void visit(SuperExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        this.tokens.add(SUPER);
    }

    @Override
    public void visit(QualifiedSuperExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        ObjectType qualifierType = expression.getType();
        this.tokens.add(this.newTypeReferenceToken(qualifierType, qualifierType));
        this.tokens.add(TextToken.DOT);
        this.tokens.add(SUPER);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        NewExpression newExpression;
        this.tokens.addLineNumberToken(expression.getCondition());
        if (expression.getTrueExpression().isBooleanExpression() && expression.getFalseExpression().isBooleanExpression()) {
            BooleanExpression be1 = (BooleanExpression)expression.getTrueExpression();
            BooleanExpression be2 = (BooleanExpression)expression.getFalseExpression();
            if (be1.isTrue() && be2.isFalse()) {
                this.printTernaryOperatorExpression(expression.getCondition());
                return;
            }
            if (be1.isFalse() && be2.isTrue()) {
                this.tokens.add(TextToken.EXCLAMATION);
                this.printTernaryOperatorExpression(expression.getCondition());
                return;
            }
        }
        if (expression.getTrueExpression() instanceof NewExpression) {
            newExpression.setDiamondPossible((newExpression = (NewExpression)expression.getTrueExpression()).isDiamondPossible() && this.majorVersion > 51);
        }
        if (expression.getFalseExpression() instanceof NewExpression) {
            newExpression.setDiamondPossible((newExpression = (NewExpression)expression.getFalseExpression()).isDiamondPossible() && this.majorVersion > 51);
        }
        this.printTernaryOperatorExpression(expression.getCondition());
        this.tokens.add(TextToken.SPACE_QUESTION_SPACE);
        this.printTernaryOperatorExpression(expression.getTrueExpression());
        this.tokens.add(TextToken.SPACE_COLON_SPACE);
        this.printTernaryOperatorExpression(expression.getFalseExpression());
    }

    protected void printTernaryOperatorExpression(Expression expression) {
        if (expression.getPriority() > 3) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            expression.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            this.inVarArgParam = false;
            expression.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
    }

    @Override
    public void visit(ThisExpression expression) {
        if (expression.isExplicit()) {
            this.tokens.addLineNumberToken((Expression)expression);
            this.tokens.add(THIS);
        }
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
        this.tokens.addLineNumberToken((Expression)expression);
        Type type = expression.getTypeDotClass();
        type.accept((org.jd.core.v1.model.javasyntax.type.TypeVisitor)this);
        this.tokens.add(TextToken.DOT);
        this.tokens.add(CLASS);
    }

    protected void storeContext() {
        this.contextStack.add(new Context(this.currentType, this.currentTypeName, this.currentMethodParamNames));
    }

    protected void restoreContext() {
        Context currentContext = this.contextStack.removeLast();
        this.currentType = currentContext.currentType;
        this.currentTypeName = currentContext.currentTypeName;
        this.currentMethodParamNames = currentContext.currentMethodParamNames;
    }

    protected void visit(Expression parent, Expression child) {
        if (parent.getPriority() < child.getPriority() || parent.getPriority() == 14 && child.getPriority() == 13) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            child.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            child.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this);
        }
    }

    protected void visitHexa(Expression parent, Expression child) {
        if (parent.getPriority() < child.getPriority() || parent.getPriority() == 14 && child.getPriority() == 13) {
            this.tokens.add(TextToken.LEFTROUNDBRACKET);
            child.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this.hexaExpressionVisitor);
            this.tokens.add(TextToken.RIGHTROUNDBRACKET);
        } else {
            child.accept((org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor)this.hexaExpressionVisitor);
        }
    }

    protected static class Fragments
    extends DefaultList<Fragment> {
        private static final long serialVersionUID = 1L;

        protected Fragments() {
        }

        public void addTokensFragment(TypeVisitor.Tokens tokens) {
            if (!tokens.isEmpty()) {
                if (tokens.getCurrentLineNumber() == 0) {
                    super.add((Object)new TokensFragment((List<Token>)((Object)tokens)));
                } else {
                    super.add((Object)new LineNumberTokensFragment((List<Token>)((Object)tokens)));
                }
            }
        }
    }

    protected class HexaExpressionVisitor
    implements org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor {
        protected HexaExpressionVisitor() {
        }

        public void visit(IntegerConstantExpression expression) {
            ExpressionVisitor.this.tokens.addLineNumberToken((Expression)expression);
            PrimitiveType pt = (PrimitiveType)expression.getType();
            if (pt.getJavaPrimitiveFlags() == 1) {
                ExpressionVisitor.this.tokens.add(new BooleanConstantToken(expression.getIntegerValue() == 1));
            } else {
                ExpressionVisitor.this.tokens.add(new NumericConstantToken("0x" + Integer.toHexString(expression.getIntegerValue()).toUpperCase()));
            }
        }

        public void visit(LongConstantExpression expression) {
            ExpressionVisitor.this.tokens.addLineNumberToken((Expression)expression);
            ExpressionVisitor.this.tokens.add(new NumericConstantToken("0x" + Long.toHexString(expression.getLongValue()).toUpperCase() + "L"));
        }

        public void visit(ArrayExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(BinaryOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(BooleanExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(CastExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(CommentExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(ConstructorInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(ConstructorReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(DoubleConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(EnumConstantReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(Expressions expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(FieldReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(FloatConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(InstanceOfExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(LambdaFormalParametersExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(LambdaIdentifiersExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(LengthExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(LocalVariableReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(MethodInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(MethodReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(NewArray expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(NewExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(NewInitializedArray expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(NoExpression expression) {
        }

        public void visit(NullExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(ObjectTypeReferenceExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(ParenthesesExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(PostOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(PreOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(QualifiedSuperExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(StringConstantExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(SuperConstructorInvocationExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(SuperExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(TernaryOperatorExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(ThisExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }

        public void visit(TypeReferenceDotClassExpression expression) {
            ExpressionVisitor.this.visit(expression);
        }
    }

    protected static class Context {
        private final ObjectType currentType;
        private final String currentTypeName;
        private final Set<String> currentMethodParamNames;

        public Context(ObjectType currentType, String currentTypeName, Set<String> currentMethodParamNames) {
            this.currentType = currentType;
            this.currentTypeName = currentTypeName;
            this.currentMethodParamNames = new HashSet<String>(currentMethodParamNames);
        }
    }
}

