/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.CompilationUnit;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileEnumDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AddCastExpressionVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AggregateFieldsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AutoboxingVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitEnumVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitInnerClassVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitInstanceFieldVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.InitStaticFieldVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveDefaultConstructorVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SortMembersVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateBridgeMethodVisitor;

public class UpdateJavaSyntaxTreeStep2Visitor
extends AbstractJavaSyntaxVisitor {
    protected static final AggregateFieldsVisitor AGGREGATE_FIELDS_VISITOR = new AggregateFieldsVisitor();
    protected static final SortMembersVisitor SORT_MEMBERS_VISITOR = new SortMembersVisitor();
    protected static final AutoboxingVisitor AUTOBOXING_VISITOR = new AutoboxingVisitor();
    private final InitStaticFieldVisitor initStaticFieldVisitor = new InitStaticFieldVisitor();
    private final InitInstanceFieldVisitor initInstanceFieldVisitor = new InitInstanceFieldVisitor();
    private final InitEnumVisitor initEnumVisitor = new InitEnumVisitor();
    private final RemoveDefaultConstructorVisitor removeDefaultConstructorVisitor = new RemoveDefaultConstructorVisitor();
    private final UpdateBridgeMethodVisitor replaceBridgeMethodVisitor;
    private final InitInnerClassVisitor.UpdateNewExpressionVisitor initInnerClassStep2Visitor;
    private final AddCastExpressionVisitor addCastExpressionVisitor;
    private TypeDeclaration typeDeclaration;

    public UpdateJavaSyntaxTreeStep2Visitor(TypeMaker typeMaker) {
        this.replaceBridgeMethodVisitor = new UpdateBridgeMethodVisitor(typeMaker);
        this.initInnerClassStep2Visitor = new InitInnerClassVisitor.UpdateNewExpressionVisitor(typeMaker);
        this.addCastExpressionVisitor = new AddCastExpressionVisitor(typeMaker);
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        if (bodyDeclaration.hasInnerTypeDeclarations()) {
            TypeDeclaration td = this.typeDeclaration;
            this.acceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
            this.typeDeclaration = td;
        }
        this.initStaticFieldVisitor.setInternalTypeName(this.typeDeclaration.getInternalTypeName());
        this.initInnerClassStep2Visitor.visit(declaration);
        this.initStaticFieldVisitor.visit(declaration);
        this.initInstanceFieldVisitor.visit(declaration);
        this.removeDefaultConstructorVisitor.visit(declaration);
        AGGREGATE_FIELDS_VISITOR.visit(declaration);
        SORT_MEMBERS_VISITOR.visit(declaration);
        if (bodyDeclaration.isMainBodyDeclaration()) {
            if (bodyDeclaration.hasInnerTypeDeclarations() && this.replaceBridgeMethodVisitor.init(bodyDeclaration)) {
                this.replaceBridgeMethodVisitor.visit(bodyDeclaration);
            }
            this.addCastExpressionVisitor.visit(declaration);
            AUTOBOXING_VISITOR.visit(declaration);
        }
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.addCastExpressionVisitor.pushContext(declaration);
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
        this.addCastExpressionVisitor.popContext(declaration);
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.typeDeclaration = declaration;
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.typeDeclaration = declaration;
        ClassFileEnumDeclaration cfed = (ClassFileEnumDeclaration)declaration;
        cfed.setFlags(cfed.getFlags() & 0xFFFFFBE7);
        cfed.getBodyDeclaration().accept((DeclarationVisitor)this);
        this.initEnumVisitor.visit(cfed.getBodyDeclaration());
        cfed.setConstants((List<EnumDeclaration.Constant>)this.initEnumVisitor.getConstants());
    }

    @Override
    public void visit(CompilationUnit compilationUnit) {
        SORT_MEMBERS_VISITOR.init();
        super.visit(compilationUnit);
    }
}

