/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;
import org.jd.core.v1.util.DefaultList;

public class UpdateIntegerConstantTypeVisitor
extends AbstractJavaSyntaxVisitor {
    protected static final Map<String, BaseType> TYPES = new HashMap<String, BaseType>();
    protected static final DimensionTypes DIMENSION_TYPES = new DimensionTypes();
    protected static final ObjectTypeReferenceExpression TYPE_CHARACTER_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_CHARACTER);
    protected static final ObjectTypeReferenceExpression TYPE_BYTE_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_BYTE);
    protected static final ObjectTypeReferenceExpression TYPE_SHORT_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_SHORT);
    protected static final ObjectTypeReferenceExpression TYPE_INTEGER_REFERENCE = new ObjectTypeReferenceExpression(ObjectType.TYPE_INTEGER);
    private Type returnedType;
    private Type arrayVariableInitializerType;

    public UpdateIntegerConstantTypeVisitor(Type returnedType) {
        this.returnedType = returnedType;
    }

    @Override
    public void visit(AssertStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
    }

    @Override
    public void visit(DoWhileStatement statement) {
        statement.setCondition(this.safeUpdateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ForStatement statement) {
        this.safeAccept((Declaration)statement.getDeclaration());
        this.safeAccept(statement.getInit());
        statement.setCondition(this.safeUpdateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getUpdate());
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(IfStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
        statement.getElseStatements().accept((StatementVisitor)this);
    }

    @Override
    public void visit(WhileStatement statement) {
        statement.setCondition(this.updateBooleanExpression(statement.getCondition()));
        this.safeAccept(statement.getStatements());
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        statement.setExpression(this.updateExpression(this.returnedType, statement.getExpression()));
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        Expression left = expression.getLeftExpression();
        Expression right = expression.getRightExpression();
        Type leftType = left.getType();
        Type rightType = right.getType();
        switch (expression.getOperator()) {
            case "&": 
            case "|": 
            case "^": {
                if (!leftType.isPrimitiveType() || !rightType.isPrimitiveType()) break;
                PrimitiveType type = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)((PrimitiveType)leftType), (PrimitiveType)((PrimitiveType)rightType));
                if (type == null) {
                    type = PrimitiveType.TYPE_INT;
                }
                expression.setLeftExpression(this.updateExpression((Type)type, left));
                expression.setRightExpression(this.updateExpression((Type)type, right));
                break;
            }
            case "=": {
                left.accept((ExpressionVisitor)this);
                expression.setRightExpression(this.updateExpression(leftType, right));
                break;
            }
            case ">": 
            case ">=": 
            case "<": 
            case "<=": 
            case "==": 
            case "!=": {
                if (leftType.getDimension() == 0 && rightType.getDimension() == 0) {
                    if (leftType.isPrimitiveType()) {
                        if (rightType.isPrimitiveType()) {
                            Type type;
                            if (leftType == rightType) {
                                type = leftType;
                            } else {
                                type = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)((PrimitiveType)leftType), (PrimitiveType)((PrimitiveType)rightType));
                                if (type == null) {
                                    type = PrimitiveType.TYPE_INT;
                                }
                            }
                            expression.setLeftExpression(this.updateExpression(type, left));
                            expression.setRightExpression(this.updateExpression(type, right));
                            break;
                        }
                        expression.setLeftExpression(this.updateExpression(rightType, left));
                        right.accept((ExpressionVisitor)this);
                        break;
                    }
                    if (rightType.isPrimitiveType()) {
                        left.accept((ExpressionVisitor)this);
                        expression.setRightExpression(this.updateExpression(leftType, right));
                        break;
                    }
                }
                left.accept((ExpressionVisitor)this);
                right.accept((ExpressionVisitor)this);
                break;
            }
            default: {
                expression.setRightExpression(this.updateExpression(expression.getType(), right));
                expression.setLeftExpression(this.updateExpression(expression.getType(), left));
            }
        }
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        Type rt = this.returnedType;
        this.returnedType = expression.getReturnedType();
        this.safeAccept(expression.getStatements());
        this.returnedType = rt;
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            expression.setParameters(this.updateExpressions(((ClassFileSuperConstructorInvocationExpression)expression).getParameterTypes(), parameters));
        }
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            expression.setParameters(this.updateExpressions(((ClassFileConstructorInvocationExpression)expression).getParameterTypes(), parameters));
        }
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            String descriptor;
            String name;
            String internalTypeName = expression.getInternalTypeName();
            BaseType types = TYPES.get(internalTypeName + ":" + (name = expression.getName()) + (descriptor = expression.getDescriptor()));
            if (types == null) {
                types = ((ClassFileMethodInvocationExpression)expression).getParameterTypes();
            }
            expression.setParameters(this.updateExpressions(types, parameters));
        }
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(NewExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            String descriptor;
            String internalTypeName = expression.getObjectType().getInternalName();
            BaseType types = TYPES.get(internalTypeName + ":<init>" + (descriptor = expression.getDescriptor()));
            if (types == null) {
                types = ((ClassFileNewExpression)expression).getParameterTypes();
            }
            expression.setParameters(this.updateExpressions(types, parameters));
        }
    }

    @Override
    public void visit(NewArray expression) {
        BaseExpression dimensions = expression.getDimensionExpressionList();
        if (dimensions != null) {
            this.updateExpressions((BaseType)DIMENSION_TYPES, dimensions);
        }
    }

    @Override
    public void visit(ArrayExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
        expression.setIndex(this.updateExpression((Type)PrimitiveType.TYPE_INT, expression.getIndex()));
    }

    @Override
    public void visit(CastExpression expression) {
        expression.setExpression(this.updateExpression(expression.getType(), expression.getExpression()));
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        Type trueType = expression.getTrueExpression().getType();
        Type falseType = expression.getFalseExpression().getType();
        expression.setCondition(this.updateBooleanExpression(expression.getCondition()));
        if (trueType.isPrimitiveType()) {
            if (falseType.isPrimitiveType()) {
                expression.setTrueExpression(this.updateExpression((Type)PrimitiveType.TYPE_INT, expression.getTrueExpression()));
                expression.setFalseExpression(this.updateExpression((Type)PrimitiveType.TYPE_INT, expression.getFalseExpression()));
            } else {
                expression.getTrueExpression().accept((ExpressionVisitor)this);
                expression.setTrueExpression(this.updateExpression(falseType, expression.getTrueExpression()));
            }
        } else {
            if (falseType.isPrimitiveType()) {
                expression.setFalseExpression(this.updateExpression(trueType, expression.getFalseExpression()));
            } else {
                expression.getTrueExpression().accept((ExpressionVisitor)this);
            }
            expression.getFalseExpression().accept((ExpressionVisitor)this);
        }
    }

    @Override
    public void visit(ArrayVariableInitializer declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        this.acceptListDeclaration((List<? extends Declaration>)declaration);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(LocalVariableDeclaration declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        declaration.getLocalVariableDeclarators().accept((DeclarationVisitor)this);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        Type t = this.arrayVariableInitializerType;
        this.arrayVariableInitializerType = declaration.getType();
        declaration.getFieldDeclarators().accept((DeclarationVisitor)this);
        this.arrayVariableInitializerType = t;
    }

    @Override
    public void visit(ExpressionVariableInitializer declaration) {
        if (declaration != null) {
            declaration.setExpression(this.updateExpression(this.arrayVariableInitializerType, declaration.getExpression()));
        }
    }

    protected BaseExpression updateExpressions(BaseType types, BaseExpression expressions) {
        if (expressions.isList()) {
            DefaultList t = types.getList();
            DefaultList e = expressions.getList();
            for (int i = e.size() - 1; i >= 0; --i) {
                int primitiveFlags;
                Type type = (Type)t.get(i);
                if (type.getDimension() != 0 || !type.isPrimitiveType()) continue;
                Expression parameter = (Expression)e.get(i);
                Expression updatedParameter = this.updateExpression(type, parameter);
                if (updatedParameter.isIntegerConstantExpression() && ((primitiveFlags = ((PrimitiveType)type).getJavaPrimitiveFlags()) == 16 || primitiveFlags == 32)) {
                    updatedParameter = new CastExpression(type, updatedParameter);
                }
                e.set(i, (Object)updatedParameter);
            }
        } else {
            Type type = (Type)types.getFirst();
            if (type.getDimension() == 0 && type.isPrimitiveType()) {
                int primitiveFlags;
                Expression updatedParameter = this.updateExpression(type, (Expression)expressions);
                if (updatedParameter.isIntegerConstantExpression() && ((primitiveFlags = ((PrimitiveType)type).getJavaPrimitiveFlags()) == 16 || primitiveFlags == 32)) {
                    updatedParameter = new CastExpression(type, updatedParameter);
                }
                expressions = updatedParameter;
            }
        }
        expressions.accept((ExpressionVisitor)this);
        return expressions;
    }

    protected Expression updateExpression(Type type, Expression expression) {
        if (type == PrimitiveType.TYPE_VOID) {
            throw new IllegalArgumentException("UpdateIntegerConstantTypeVisitor.updateExpression(type, expr) : try to set 'void' to a numeric expression");
        }
        if (type != expression.getType() && expression.isIntegerConstantExpression()) {
            if (ObjectType.TYPE_STRING.equals((Object)type)) {
                type = PrimitiveType.TYPE_CHAR;
            }
            if (type.isPrimitiveType()) {
                PrimitiveType primitiveType = (PrimitiveType)type;
                IntegerConstantExpression ice = (IntegerConstantExpression)expression;
                PrimitiveType icePrimitiveType = (PrimitiveType)ice.getType();
                int value = ice.getIntegerValue();
                int lineNumber = ice.getLineNumber();
                switch (primitiveType.getJavaPrimitiveFlags()) {
                    case 1: {
                        return new BooleanExpression(lineNumber, value != 0);
                    }
                    case 2: {
                        switch (value) {
                            case 65535: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_CHAR, (Expression)TYPE_CHARACTER_REFERENCE, "java/lang/Character", "MAX_VALUE", "C");
                            }
                        }
                        if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                            ice.setType(type);
                            break;
                        }
                        ice.setType((Type)PrimitiveType.TYPE_INT);
                        break;
                    }
                    case 16: {
                        switch (value) {
                            case -128: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_BYTE, (Expression)TYPE_BYTE_REFERENCE, "java/lang/Byte", "MIN_VALUE", "B");
                            }
                            case 127: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_BYTE, (Expression)TYPE_BYTE_REFERENCE, "java/lang/Byte", "MAX_VALUE", "B");
                            }
                        }
                        if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                            ice.setType(type);
                            break;
                        }
                        ice.setType((Type)PrimitiveType.TYPE_INT);
                        break;
                    }
                    case 32: {
                        switch (value) {
                            case -32768: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_SHORT, (Expression)TYPE_SHORT_REFERENCE, "java/lang/Short", "MIN_VALUE", "S");
                            }
                            case 32767: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_SHORT, (Expression)TYPE_SHORT_REFERENCE, "java/lang/Short", "MAX_VALUE", "S");
                            }
                        }
                        if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                            ice.setType(type);
                            break;
                        }
                        ice.setType((Type)PrimitiveType.TYPE_INT);
                        break;
                    }
                    case 64: {
                        switch (value) {
                            case -2147483648: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_INT, (Expression)TYPE_INTEGER_REFERENCE, "java/lang/Integer", "MIN_VALUE", "I");
                            }
                            case 0x7FFFFFFF: {
                                return new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_INT, (Expression)TYPE_INTEGER_REFERENCE, "java/lang/Integer", "MAX_VALUE", "I");
                            }
                        }
                        if ((icePrimitiveType.getFlags() & primitiveType.getFlags()) != 0) {
                            ice.setType(type);
                            break;
                        }
                        ice.setType((Type)PrimitiveType.TYPE_INT);
                        break;
                    }
                    case 128: {
                        return new LongConstantExpression(ice.getLineNumber(), (long)ice.getIntegerValue());
                    }
                }
                return expression;
            }
        }
        if (type.isPrimitiveType() && expression.isTernaryOperatorExpression()) {
            TernaryOperatorExpression toe = (TernaryOperatorExpression)expression;
            toe.setType(type);
            toe.setCondition(this.updateBooleanExpression(toe.getCondition()));
            toe.setTrueExpression(this.updateExpression(type, toe.getTrueExpression()));
            toe.setFalseExpression(this.updateExpression(type, toe.getFalseExpression()));
            return expression;
        }
        expression.accept((ExpressionVisitor)this);
        return expression;
    }

    protected Expression safeUpdateBooleanExpression(Expression expression) {
        return expression == null ? null : this.updateBooleanExpression(expression);
    }

    protected Expression updateBooleanExpression(Expression expression) {
        if (PrimitiveType.TYPE_BOOLEAN != expression.getType()) {
            if (expression.isIntegerConstantExpression()) {
                return new BooleanExpression(expression.getLineNumber(), expression.getIntegerValue() != 0);
            }
            if (expression.isTernaryOperatorExpression()) {
                TernaryOperatorExpression toe = (TernaryOperatorExpression)expression;
                toe.setType((Type)PrimitiveType.TYPE_BOOLEAN);
                toe.setCondition(this.updateBooleanExpression(toe.getCondition()));
                toe.setTrueExpression(this.updateBooleanExpression(toe.getTrueExpression()));
                toe.setFalseExpression(this.updateBooleanExpression(toe.getFalseExpression()));
                return expression;
            }
        }
        expression.accept((ExpressionVisitor)this);
        return expression;
    }

    @Override
    public void visit(FloatConstantExpression expression) {
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
    }

    @Override
    public void visit(LongConstantExpression expression) {
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
    }

    @Override
    public void visit(SuperExpression expression) {
    }

    @Override
    public void visit(ThisExpression expression) {
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
    }

    public void visit(TypeArguments type) {
    }

    public void visit(WildcardExtendsTypeArgument type) {
    }

    public void visit(ObjectType type) {
    }

    public void visit(InnerObjectType type) {
    }

    public void visit(WildcardSuperTypeArgument type) {
    }

    @Override
    public void visit(Types list) {
    }

    @Override
    public void visit(TypeParameterWithTypeBounds type) {
    }

    @Override
    public void visit(BodyDeclaration declaration) {
    }

    static {
        PrimitiveType c = PrimitiveType.TYPE_CHAR;
        Types ci = new Types((Type)PrimitiveType.TYPE_CHAR, new Type[]{PrimitiveType.TYPE_INT});
        TYPES.put("java/lang/String:indexOf(I)I", (BaseType)c);
        TYPES.put("java/lang/String:indexOf(II)I", (BaseType)ci);
        TYPES.put("java/lang/String:lastIndexOf(I)I", (BaseType)c);
        TYPES.put("java/lang/String:lastIndexOf(II)I", (BaseType)ci);
    }

    protected static class DimensionTypes
    extends Types {
        private static final long serialVersionUID = 1L;

        protected DimensionTypes() {
        }

        public Type getFirst() {
            return PrimitiveType.TYPE_INT;
        }

        public Type getLast() {
            return PrimitiveType.TYPE_INT;
        }

        public Type get(int i) {
            return PrimitiveType.TYPE_INT;
        }

        public int size() {
            return 0;
        }
    }
}

