/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AbstractUpdateExpressionVisitor;
import org.jd.core.v1.util.DefaultList;

public class UpdateBridgeMethodVisitor
extends AbstractUpdateExpressionVisitor {
    private final BodyDeclarationsVisitor bodyDeclarationsVisitor = new BodyDeclarationsVisitor();
    private final Map<String, Map<String, ClassFileMethodDeclaration>> bridgeMethodDeclarations = new HashMap<String, Map<String, ClassFileMethodDeclaration>>();
    private final TypeMaker typeMaker;

    public UpdateBridgeMethodVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    public boolean init(ClassFileBodyDeclaration bodyDeclaration) {
        this.bridgeMethodDeclarations.clear();
        this.bodyDeclarationsVisitor.visit(bodyDeclaration);
        return !this.bridgeMethodDeclarations.isEmpty();
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        expression.setExpression(this.updateExpression(expression.getExpression()));
        if (expression.getParameters() != null) {
            expression.setParameters(this.updateBaseExpression(expression.getParameters()));
            expression.getParameters().accept((ExpressionVisitor)this);
        }
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    protected Expression updateExpression(Expression expression) {
        int parameterTypesCount;
        if (!expression.isMethodInvocationExpression()) {
            return expression;
        }
        ClassFileMethodInvocationExpression mie1 = (ClassFileMethodInvocationExpression)expression;
        Map<String, ClassFileMethodDeclaration> map = this.bridgeMethodDeclarations.get(mie1.getExpression().getType().getDescriptor());
        if (map == null) {
            return expression;
        }
        ClassFileMethodDeclaration bridgeMethodDeclaration = map.get(mie1.getName() + mie1.getDescriptor());
        if (bridgeMethodDeclaration == null) {
            return expression;
        }
        Statement statement = (Statement)bridgeMethodDeclaration.getStatements().getFirst();
        if (!statement.isReturnExpressionStatement() && !statement.isExpressionStatement()) {
            return expression;
        }
        Expression exp = statement.getExpression();
        BaseType parameterTypes = bridgeMethodDeclaration.getParameterTypes();
        int n = parameterTypesCount = parameterTypes == null ? 0 : parameterTypes.size();
        if (exp.isFieldReferenceExpression()) {
            FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(exp);
            expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
            return new FieldReferenceExpression(mie1.getLineNumber(), fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor());
        }
        if (exp.isMethodInvocationExpression()) {
            MethodInvocationExpression mie2 = (MethodInvocationExpression)exp;
            TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor());
            if (methodTypes != null) {
                if (mie2.getExpression().isObjectTypeReferenceExpression()) {
                    return new ClassFileMethodInvocationExpression(mie1.getLineNumber(), methodTypes.getReturnedType(), mie2.getExpression(), mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor(), mie1.getParameters(), methodTypes);
                }
                BaseExpression mie1Parameters = mie1.getParameters();
                BaseExpression newParameters = null;
                switch (mie1Parameters.size()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        newParameters = (BaseExpression)mie1Parameters.getList().get(1);
                        break;
                    }
                    default: {
                        DefaultList p = mie1Parameters.getList();
                        newParameters = new Expressions((Collection)p.subList(1, p.size()));
                    }
                }
                return new ClassFileMethodInvocationExpression(mie1.getLineNumber(), methodTypes.getReturnedType(), (Expression)mie1Parameters.getFirst(), mie2.getInternalTypeName(), mie2.getName(), mie2.getDescriptor(), newParameters, methodTypes);
            }
        } else if (exp.isBinaryOperatorExpression()) {
            FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(exp.getLeftExpression());
            if (parameterTypesCount == 1) {
                return new BinaryOperatorExpression(mie1.getLineNumber(), mie1.getType(), (Expression)new FieldReferenceExpression(fre.getType(), fre.getExpression(), fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), exp.getOperator(), (Expression)mie1.getParameters().getFirst(), exp.getPriority());
            }
            if (parameterTypesCount == 2) {
                DefaultList parameters = mie1.getParameters().getList();
                return new BinaryOperatorExpression(mie1.getLineNumber(), mie1.getType(), (Expression)new FieldReferenceExpression(fre.getType(), (Expression)parameters.get(0), fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), exp.getOperator(), (Expression)parameters.get(1), exp.getPriority());
            }
        } else {
            if (exp.isPostOperatorExpression()) {
                FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(exp.getExpression());
                expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
                return new PostOperatorExpression(mie1.getLineNumber(), (Expression)new FieldReferenceExpression(fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()), exp.getOperator());
            }
            if (exp.isPreOperatorExpression()) {
                FieldReferenceExpression fre = UpdateBridgeMethodVisitor.getFieldReferenceExpression(exp.getExpression());
                expression = parameterTypesCount == 0 ? fre.getExpression() : (Expression)mie1.getParameters().getFirst();
                return new PreOperatorExpression(mie1.getLineNumber(), exp.getOperator(), (Expression)new FieldReferenceExpression(fre.getType(), expression, fre.getInternalTypeName(), fre.getName(), fre.getDescriptor()));
            }
            if (exp.isIntegerConstantExpression()) {
                return exp;
            }
        }
        return expression;
    }

    protected static FieldReferenceExpression getFieldReferenceExpression(Expression expression) {
        FieldReferenceExpression fre = (FieldReferenceExpression)expression;
        Expression freExpression = fre.getExpression();
        if (freExpression != null && freExpression.isObjectTypeReferenceExpression()) {
            ((ObjectTypeReferenceExpression)freExpression).setExplicit(true);
        }
        return fre;
    }

    protected class BodyDeclarationsVisitor
    extends AbstractJavaSyntaxVisitor {
        private Map<String, ClassFileMethodDeclaration> map;

        protected BodyDeclarationsVisitor() {
        }

        @Override
        public void visit(ClassDeclaration declaration) {
            this.safeAccept((Declaration)declaration.getBodyDeclaration());
        }

        @Override
        public void visit(EnumDeclaration declaration) {
            this.safeAccept((Declaration)declaration.getBodyDeclaration());
        }

        @Override
        public void visit(InterfaceDeclaration declaration) {
        }

        @Override
        public void visit(AnnotationDeclaration declaration) {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            List<ClassFileConstructorOrMethodDeclaration> methodDeclarations = bodyDeclaration.getMethodDeclarations();
            if (!methodDeclarations.isEmpty()) {
                Map<String, ClassFileMethodDeclaration> backup = this.map;
                this.map = new HashMap<String, ClassFileMethodDeclaration>();
                this.acceptListDeclaration(methodDeclarations);
                if (!this.map.isEmpty()) {
                    UpdateBridgeMethodVisitor.this.bridgeMethodDeclarations.put("L" + bodyDeclaration.getInternalTypeName() + ";", this.map);
                }
                this.map = backup;
            }
            this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            if ((declaration.getFlags() & 8) == 0) {
                return;
            }
            BaseStatement statements = declaration.getStatements();
            if (statements == null || statements.size() != 1) {
                return;
            }
            String name = declaration.getName();
            if (!name.startsWith("access$")) {
                return;
            }
            ClassFileMethodDeclaration bridgeMethodDeclaration = (ClassFileMethodDeclaration)declaration;
            if (!this.checkBridgeMethodDeclaration(bridgeMethodDeclaration)) {
                return;
            }
            this.map.put(name + declaration.getDescriptor(), bridgeMethodDeclaration);
        }

        private boolean checkBridgeMethodDeclaration(ClassFileMethodDeclaration bridgeMethodDeclaration) {
            int parameterTypesCount;
            Statement statement = (Statement)bridgeMethodDeclaration.getStatements().getFirst();
            if (!statement.isReturnExpressionStatement() && !statement.isExpressionStatement()) {
                return false;
            }
            Expression exp = statement.getExpression();
            BaseType parameterTypes = bridgeMethodDeclaration.getParameterTypes();
            int n = parameterTypesCount = parameterTypes == null ? 0 : parameterTypes.size();
            if (exp.isFieldReferenceExpression()) {
                FieldReferenceExpression fre = (FieldReferenceExpression)exp;
                if (parameterTypesCount == 0) {
                    return fre.getExpression() != null && fre.getExpression().isObjectTypeReferenceExpression();
                }
                if (parameterTypesCount == 1) {
                    return fre.getExpression() == null || this.checkLocalVariableReference((BaseExpression)fre.getExpression(), 0);
                }
            } else if (exp.isMethodInvocationExpression()) {
                MethodInvocationExpression mie2 = (MethodInvocationExpression)exp;
                if (mie2.getExpression().isObjectTypeReferenceExpression()) {
                    BaseExpression mie2Parameters = mie2.getParameters();
                    if (mie2Parameters == null || mie2Parameters.size() == 0) {
                        return true;
                    }
                    if (mie2Parameters.isList()) {
                        int i = 0;
                        for (Expression parameter : mie2Parameters) {
                            if (!this.checkLocalVariableReference((BaseExpression)parameter, i++)) {
                                return false;
                            }
                            Type type = parameter.getType();
                            if (!type.equals(PrimitiveType.TYPE_LONG) && !type.equals(PrimitiveType.TYPE_DOUBLE)) continue;
                            ++i;
                        }
                        return true;
                    }
                    return this.checkLocalVariableReference(mie2Parameters, 0);
                }
                if (parameterTypesCount > 0 && this.checkLocalVariableReference((BaseExpression)mie2.getExpression(), 0)) {
                    BaseExpression mie2Parameters = mie2.getParameters();
                    if (mie2Parameters == null || mie2Parameters.size() == 0) {
                        return true;
                    }
                    if (mie2Parameters.isList()) {
                        int i = 1;
                        for (Expression parameter : mie2Parameters) {
                            if (!this.checkLocalVariableReference((BaseExpression)parameter, i++)) {
                                return false;
                            }
                            Type type = parameter.getType();
                            if (!type.equals(PrimitiveType.TYPE_LONG) && !type.equals(PrimitiveType.TYPE_DOUBLE)) continue;
                            ++i;
                        }
                        return true;
                    }
                    return this.checkLocalVariableReference(mie2Parameters, 1);
                }
            } else if (exp.isBinaryOperatorExpression()) {
                if (parameterTypesCount == 1) {
                    if (exp.getLeftExpression().isFieldReferenceExpression() && this.checkLocalVariableReference((BaseExpression)exp.getRightExpression(), 0)) {
                        FieldReferenceExpression fre = (FieldReferenceExpression)exp.getLeftExpression();
                        return fre.getExpression().isObjectTypeReferenceExpression();
                    }
                } else if (parameterTypesCount == 2 && exp.getLeftExpression().isFieldReferenceExpression() && this.checkLocalVariableReference((BaseExpression)exp.getRightExpression(), 1)) {
                    FieldReferenceExpression fre = (FieldReferenceExpression)exp.getLeftExpression();
                    return this.checkLocalVariableReference((BaseExpression)fre.getExpression(), 0);
                }
            } else if (exp.isPostOperatorExpression() || parameterTypesCount == 1 && exp.isPreOperatorExpression()) {
                if ((exp = exp.getExpression()).isFieldReferenceExpression()) {
                    if (parameterTypesCount == 0 && exp.getExpression().isObjectTypeReferenceExpression()) {
                        return true;
                    }
                    if (parameterTypesCount == 1 && exp.getExpression() != null && this.checkLocalVariableReference((BaseExpression)exp.getExpression(), 0)) {
                        return true;
                    }
                }
            } else if (parameterTypesCount == 0 && exp.isIntegerConstantExpression()) {
                return true;
            }
            return false;
        }

        private boolean checkLocalVariableReference(BaseExpression expression, int index) {
            if (expression.isLocalVariableReferenceExpression()) {
                ClassFileLocalVariableReferenceExpression exp = (ClassFileLocalVariableReferenceExpression)expression;
                return exp.getLocalVariable().getIndex() == index;
            }
            return false;
        }
    }
}

