/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class UpdateBridgeMethodTypeVisitor
extends AbstractJavaSyntaxVisitor {
    private final TypeMaker typeMaker;

    public UpdateBridgeMethodTypeVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        TypeMaker.TypeTypes typeTypes;
        if (declaration.isStatic() && declaration.getReturnedType().isObjectType() && declaration.getName().startsWith("access$") && (typeTypes = this.typeMaker.makeTypeTypes(declaration.getReturnedType().getInternalName())) != null && typeTypes.getTypeParameters() != null) {
            String descriptor;
            String name;
            ConstantNameAndType constantNameAndType;
            String typeName;
            ConstantCP constantMemberRef;
            ConstantPool constants;
            int index;
            ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
            Method method = cfmd.getMethod();
            byte[] code = method.getCode().getCode();
            int offset = 0;
            int opcode = code[offset] & 0xFF;
            while (21 <= opcode && opcode <= 45 || 89 <= opcode && opcode <= 95) {
                opcode = code[++offset] & 0xFF;
            }
            if (opcode >= 178 && opcode <= 181) {
                index = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                constants = method.getConstantPool();
                constantMemberRef = (ConstantCP)constants.getConstant(index);
                typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
                constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
                descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
                Type type = this.typeMaker.makeFieldType(typeName, name, descriptor);
                this.typeMaker.setMethodReturnedType(typeName, cfmd.getName(), cfmd.getDescriptor(), type);
            }
            if (opcode >= 182 && opcode <= 185) {
                index = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                constants = method.getConstantPool();
                constantMemberRef = (ConstantCP)constants.getConstant(index);
                typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
                constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
                descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
                TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(typeName, name, descriptor);
                this.typeMaker.setMethodReturnedType(typeName, cfmd.getName(), cfmd.getDescriptor(), methodTypes.getReturnedType());
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
    }

    @Override
    public void visit(EnumDeclaration declaration) {
    }
}

