/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BaseMemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MemberDeclarations;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.MergeMembersUtil;

public class SortMembersVisitor
extends AbstractJavaSyntaxVisitor {
    private Set<String> declaredTypes = new HashSet<String>();

    private boolean isDeclared(ClassFileTypeDeclaration classFileTypeDeclaration) {
        return this.declaredTypes.contains(classFileTypeDeclaration.getInternalTypeName());
    }

    private void addDeclaredType(ClassFileTypeDeclaration classFileTypeDeclaration) {
        this.declaredTypes.add(classFileTypeDeclaration.getInternalTypeName());
    }

    public void init() {
        this.declaredTypes.clear();
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        List<ClassFileTypeDeclaration> innerTypes = bodyDeclaration.getInnerTypeDeclarations();
        if (innerTypes != null) {
            innerTypes.removeIf(this::isDeclared);
            innerTypes.forEach(this::addDeclaredType);
        }
        MemberDeclarations members = MergeMembersUtil.merge(bodyDeclaration.getFieldDeclarations(), bodyDeclaration.getMethodDeclarations(), innerTypes);
        bodyDeclaration.setMemberDeclarations((BaseMemberDeclaration)members);
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }
}

