/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashSet;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;

public class SearchUndeclaredLocalVariableVisitor
extends AbstractJavaSyntaxVisitor {
    private final Set<AbstractLocalVariable> variables = new HashSet<AbstractLocalVariable>();

    public void init() {
        this.variables.clear();
    }

    public Set<AbstractLocalVariable> getVariables() {
        return this.variables;
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        AbstractLocalVariable lv;
        if (expression.getLeftExpression().isLocalVariableReferenceExpression() && "=".equals(expression.getOperator()) && !(lv = ((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable()).isDeclared()) {
            this.variables.add(lv);
        }
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        expression.getRightExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(DoWhileStatement statement) {
        this.safeAccept((BaseExpression)statement.getCondition());
    }

    @Override
    public void visit(ForEachStatement statement) {
        statement.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(ForStatement statement) {
        this.safeAccept((Declaration)statement.getDeclaration());
        this.safeAccept(statement.getInit());
        this.safeAccept((BaseExpression)statement.getCondition());
        this.safeAccept(statement.getUpdate());
    }

    @Override
    public void visit(IfStatement statement) {
        statement.getCondition().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(IfElseStatement statement) {
        statement.getCondition().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        statement.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getCondition().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(SynchronizedStatement statement) {
        statement.getMonitor().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(TryStatement statement) {
    }

    @Override
    public void visit(WhileStatement statement) {
        statement.getCondition().accept((ExpressionVisitor)this);
    }
}

