/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;

public class SearchLocalVariableReferenceVisitor
extends AbstractJavaSyntaxVisitor {
    private int index;
    private boolean found;
    private String name;
    private Deque<LambdaIdentifiersExpression> lambdas = new ArrayDeque<LambdaIdentifiersExpression>();

    public void init(int index, String name) {
        this.index = index;
        this.name = name;
        this.found = false;
    }

    public void init(AbstractLocalVariable localVariable) {
        this.init(localVariable.getIndex(), localVariable.getName());
    }

    public boolean containsReference() {
        return this.found;
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        if (this.index < 0) {
            this.found = !this.isLambdaParameter(expression.getName());
        } else {
            ClassFileLocalVariableReferenceExpression referenceExpression = (ClassFileLocalVariableReferenceExpression)expression;
            this.found = this.lambdas.isEmpty() ? (this.found |= referenceExpression.getLocalVariable().getIndex() == this.index) : (this.found |= referenceExpression.getLocalVariable().getName().equals(this.name));
        }
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        this.lambdas.push(expression);
        super.visit(expression);
        this.lambdas.pop();
    }

    private boolean isLambdaParameter(String name) {
        for (LambdaIdentifiersExpression lambda : this.lambdas) {
            if (!lambda.getParameterNames().contains(name)) continue;
            return true;
        }
        return false;
    }
}

