/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.List;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.NoStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.DeclaredSyntheticLocalVariableVisitor;

public class RemoveFinallyStatementsVisitor
implements StatementVisitor {
    private final DeclaredSyntheticLocalVariableVisitor declaredSyntheticLocalVariableVisitor = new DeclaredSyntheticLocalVariableVisitor();
    private int statementCountInFinally;
    private int statementCountToRemove;
    private boolean lastFinallyStatementIsATryStatement;

    public void init() {
        this.statementCountInFinally = 0;
        this.statementCountToRemove = 0;
        this.lastFinallyStatementIsATryStatement = false;
    }

    public void visit(Statements statements) {
        Statements stmts = statements;
        int size = statements.size();
        if (size > 0) {
            int i = size;
            int oldStatementCountToRemove = this.statementCountToRemove;
            Statement lastStatement = (Statement)stmts.getLast();
            if (lastStatement.isReturnExpressionStatement() || lastStatement.isReturnStatement()) {
                this.statementCountToRemove = this.statementCountInFinally;
                --i;
            } else if (lastStatement.isThrowStatement()) {
                this.statementCountToRemove = 0;
                --i;
            } else if (lastStatement.isContinueStatement() || lastStatement.isBreakStatement()) {
                --i;
            } else {
                WhileStatement whileStatement = RemoveFinallyStatementsVisitor.getInfiniteWhileStatement(lastStatement);
                if (whileStatement != null) {
                    this.statementCountToRemove = 0;
                    --i;
                    whileStatement.getStatements().accept((StatementVisitor)this);
                }
            }
            if (this.statementCountToRemove > 0) {
                if (!this.lastFinallyStatementIsATryStatement && i > 0 && ((Statement)stmts.get(i - 1)).isTryStatement()) {
                    ((Statement)stmts.get(i - 1)).accept((StatementVisitor)this);
                    this.statementCountToRemove = 0;
                } else {
                    this.declaredSyntheticLocalVariableVisitor.init();
                    if (i > this.statementCountToRemove) {
                        list = statements.subList(i - this.statementCountToRemove, i);
                        var8_8 = list.iterator();
                        while (var8_8.hasNext()) {
                            statement = (Statement)var8_8.next();
                            statement.accept((StatementVisitor)this.declaredSyntheticLocalVariableVisitor);
                        }
                        lastStatement.accept((StatementVisitor)this.declaredSyntheticLocalVariableVisitor);
                        list.clear();
                        i -= this.statementCountToRemove;
                        this.statementCountToRemove = 0;
                    } else {
                        list = statements;
                        var8_8 = list.iterator();
                        while (var8_8.hasNext()) {
                            statement = (Statement)var8_8.next();
                            statement.accept((StatementVisitor)this.declaredSyntheticLocalVariableVisitor);
                        }
                        list.clear();
                        if (i < size) {
                            list.add(lastStatement);
                        }
                        this.statementCountToRemove -= i;
                        i = 0;
                    }
                }
            }
            while (true) {
                int n = --i;
                --i;
                if (n <= 0) break;
                ((Statement)stmts.get(i)).accept((StatementVisitor)this);
                if (this.statementCountToRemove <= 0 || i + this.statementCountToRemove >= statements.size()) continue;
                statements.subList(i + 1, i + 1 + this.statementCountToRemove).clear();
                this.statementCountToRemove = 0;
            }
            this.statementCountToRemove = oldStatementCountToRemove;
        }
    }

    private static WhileStatement getInfiniteWhileStatement(Statement statement) {
        if (statement.isLabelStatement()) {
            statement = ((LabelStatement)statement).statement();
        }
        if (statement == null || !statement.isWhileStatement() || !statement.getCondition().isBooleanExpression()) {
            return null;
        }
        BooleanExpression booleanExpression = (BooleanExpression)statement.getCondition();
        if (booleanExpression.isFalse()) {
            return null;
        }
        return (WhileStatement)statement;
    }

    public void visit(IfElseStatement statement) {
        statement.getStatements().accept((StatementVisitor)this);
        statement.getElseStatements().accept((StatementVisitor)this);
    }

    public void visit(SwitchStatement statement) {
        for (SwitchStatement.Block block : statement.getBlocks()) {
            block.getStatements().accept((StatementVisitor)this);
        }
    }

    public void visit(TryStatement statement) {
        boolean oldLastFinallyStatementIsTryStatement = this.lastFinallyStatementIsATryStatement;
        ClassFileTryStatement ts = (ClassFileTryStatement)statement;
        Statements tryStatements = (Statements)ts.getTryStatements();
        Statements finallyStatements = (Statements)ts.getFinallyStatements();
        if (finallyStatements != null) {
            switch (finallyStatements.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    ((Statement)finallyStatements.getFirst()).accept((StatementVisitor)this);
                    break;
                }
                default: {
                    for (Statement stmt : finallyStatements) {
                        stmt.accept((StatementVisitor)this);
                    }
                }
            }
            if (this.statementCountInFinally == 0 && !finallyStatements.isEmpty()) {
                this.lastFinallyStatementIsATryStatement = ((Statement)finallyStatements.getLast()).isTryStatement();
            }
        }
        if (ts.isJsr() || finallyStatements == null || finallyStatements.isEmpty()) {
            tryStatements.accept((StatementVisitor)this);
            this.safeAcceptListStatement((List<? extends Statement>)statement.getCatchClauses());
        } else {
            if (ts.isEclipse()) {
                catchClauses = statement.getCatchClauses();
                int oldStatementCountInFinally = this.statementCountInFinally;
                int finallyStatementsSize = finallyStatements.size();
                this.statementCountInFinally += finallyStatementsSize;
                tryStatements.accept((StatementVisitor)this);
                this.statementCountToRemove = finallyStatementsSize;
                if (catchClauses != null) {
                    for (TryStatement.CatchClause cc : catchClauses) {
                        cc.getStatements().accept((StatementVisitor)this);
                    }
                }
                this.statementCountInFinally = oldStatementCountInFinally;
            } else {
                catchClauses = statement.getCatchClauses();
                int oldStatementCountInFinally = this.statementCountInFinally;
                int oldStatementCountToRemove = this.statementCountToRemove;
                int finallyStatementsSize = finallyStatements.size();
                this.statementCountInFinally += finallyStatementsSize;
                this.statementCountToRemove += finallyStatementsSize;
                tryStatements.accept((StatementVisitor)this);
                if (catchClauses != null) {
                    for (TryStatement.CatchClause cc : catchClauses) {
                        cc.getStatements().accept((StatementVisitor)this);
                    }
                }
                this.statementCountInFinally = oldStatementCountInFinally;
                this.statementCountToRemove = oldStatementCountToRemove;
            }
            if (statement.getResources() != null) {
                ts.setFinallyStatements(null);
            }
        }
        this.lastFinallyStatementIsATryStatement = oldLastFinallyStatementIsTryStatement;
    }

    public void visit(DoWhileStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(ForEachStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(ForStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(IfStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(SynchronizedStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(TryStatement.CatchClause statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(WhileStatement statement) {
        this.safeAccept(statement.getStatements());
    }

    public void visit(SwitchStatement.LabelBlock statement) {
        statement.getStatements().accept((StatementVisitor)this);
    }

    public void visit(SwitchStatement.MultiLabelsBlock statement) {
        statement.getStatements().accept((StatementVisitor)this);
    }

    public void visit(AssertStatement statement) {
    }

    public void visit(BreakStatement statement) {
    }

    public void visit(CommentStatement statement) {
    }

    public void visit(ContinueStatement statement) {
    }

    public void visit(ExpressionStatement statement) {
    }

    public void visit(LabelStatement statement) {
    }

    public void visit(LambdaExpressionStatement statement) {
    }

    public void visit(LocalVariableDeclarationStatement statement) {
    }

    public void visit(NoStatement statement) {
    }

    public void visit(ReturnExpressionStatement statement) {
    }

    public void visit(ReturnStatement statement) {
    }

    public void visit(SwitchStatement.DefaultLabel statement) {
    }

    public void visit(SwitchStatement.ExpressionLabel statement) {
    }

    public void visit(ThrowStatement statement) {
    }

    public void visit(TryStatement.Resource statement) {
    }

    public void visit(TypeDeclarationStatement statement) {
    }

    protected void safeAccept(BaseStatement list) {
        if (list != null) {
            list.accept((StatementVisitor)this);
        }
    }

    protected void safeAcceptListStatement(List<? extends Statement> list) {
        if (list != null) {
            for (Statement statement : list) {
                statement.accept((StatementVisitor)this);
            }
        }
    }
}

