/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Iterator;
import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;

public class RemoveDefaultConstructorVisitor
extends AbstractJavaSyntaxVisitor {
    private int constructorCounter;
    private ClassFileMemberDeclaration constructor;

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        List<ClassFileConstructorOrMethodDeclaration> methods = bodyDeclaration.getMethodDeclarations();
        this.constructor = null;
        this.constructorCounter = 0;
        this.safeAcceptListDeclaration(methods);
        if (this.constructorCounter == 1 && this.constructor != null) {
            methods.remove(this.constructor);
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        if ((declaration.getFlags() & 0x400) == 0) {
            ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
            if (cfcd.getStatements() != null && cfcd.getStatements().isStatements()) {
                Statements statements = (Statements)cfcd.getStatements();
                Iterator iterator = statements.iterator();
                while (iterator.hasNext()) {
                    Expression es = ((Statement)iterator.next()).getExpression();
                    if (!es.isSuperConstructorInvocationExpression()) continue;
                    if ((declaration.getFlags() & 0x200) != 0) {
                        iterator.remove();
                        break;
                    }
                    BaseExpression parameters = es.getParameters();
                    if (parameters != null && parameters.size() != 0) continue;
                    iterator.remove();
                    break;
                }
                if (statements.isEmpty() && (cfcd.getFormalParameters() == null || cfcd.getFormalParameters().size() == 0)) {
                    this.constructor = cfcd;
                }
            }
            ++this.constructorCounter;
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }
}

