/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;

public class RemoveBinaryOpReturnStatementsVisitor
extends AbstractJavaSyntaxVisitor {
    private final LocalVariableMaker localVariableMaker;

    public RemoveBinaryOpReturnStatementsVisitor(LocalVariableMaker localVariableMaker) {
        this.localVariableMaker = localVariableMaker;
    }

    @Override
    public void visit(Statements statements) {
        Expression boe;
        Expression leftExpression;
        Statement statement;
        ClassFileLocalVariableReferenceExpression lvr1;
        Statement lastStatement;
        if (statements.size() > 1 && (lastStatement = (Statement)statements.getLast()).isReturnExpressionStatement() && lastStatement.getExpression().isLocalVariableReferenceExpression() && ((lvr1 = (ClassFileLocalVariableReferenceExpression)lastStatement.getExpression()).getName() == null || lvr1.getLocalVariable().getOriginalVariable() != null) && (statement = (Statement)statements.get(statements.size() - 2)).getExpression() != null && statement.getExpression().isBinaryOperatorExpression() && (leftExpression = (boe = statement.getExpression()).getLeftExpression()).isLocalVariableReferenceExpression()) {
            ClassFileLocalVariableReferenceExpression lvr2 = (ClassFileLocalVariableReferenceExpression)leftExpression;
            if (lvr1.getLocalVariable() == lvr2.getLocalVariable() && lvr1.getLocalVariable().getReferences().size() == 2) {
                ReturnExpressionStatement res = (ReturnExpressionStatement)lastStatement;
                statements.remove(statements.size() - 2);
                res.setExpression(boe.getRightExpression());
                int expressionLineNumber = boe.getRightExpression().getLineNumber();
                if (res.getLineNumber() > expressionLineNumber) {
                    res.setLineNumber(expressionLineNumber);
                }
                this.localVariableMaker.removeLocalVariable(lvr1.getLocalVariable());
            }
        }
        super.visit(statements);
    }

    @Override
    public void visit(BodyDeclaration declaration) {
    }
}

