/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Iterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class PopulateBindingsWithTypeArgumentVisitor
implements TypeArgumentVisitor {
    private final TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    private final TypeMaker typeMaker;
    private Map<String, BaseType> contextualTypeBounds;
    private Map<String, TypeArgument> bindings;
    private Map<String, BaseType> typeBounds;
    private BaseTypeArgument current;

    public PopulateBindingsWithTypeArgumentVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
        this.current = null;
    }

    public void init(Map<String, BaseType> contextualTypeBounds, Map<String, TypeArgument> bindings, Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        this.contextualTypeBounds = contextualTypeBounds;
        this.bindings = bindings;
        this.typeBounds = typeBounds;
        this.current = typeArgument;
    }

    public void visit(TypeArguments arguments) {
        if (this.current != null && this.current.isTypeArgumentList()) {
            Iterator typeArgumentIterator = arguments.iterator();
            Iterator typeGenericArgumentIterator = this.current.getTypeArgumentList().iterator();
            while (typeArgumentIterator.hasNext() && typeGenericArgumentIterator.hasNext()) {
                this.current = (BaseTypeArgument)typeGenericArgumentIterator.next();
                ((TypeArgument)typeArgumentIterator.next()).accept((TypeArgumentVisitor)this);
            }
        }
    }

    public void visit(GenericType type) {
        String typeName = type.getName();
        if (this.bindings.containsKey(typeName)) {
            TypeArgument typeArgument = this.bindings.get(typeName);
            if (this.current != null) {
                if (this.current.isGenericTypeArgument() && !PopulateBindingsWithTypeArgumentVisitor.equals(this.contextualTypeBounds.get(typeName), this.typeBounds.get(((GenericType)this.current).getName()))) {
                    return;
                }
                if (this.current.isWildcardTypeArgument() && type.isGenericTypeArgument()) {
                    return;
                }
                if (typeArgument == null) {
                    this.bindings.put(typeName, this.checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(type));
                } else if (!this.current.equals(typeArgument)) {
                    ObjectType ot2;
                    ObjectType ot1;
                    this.typeArgumentToTypeVisitor.init();
                    typeArgument.accept((TypeArgumentVisitor)this.typeArgumentToTypeVisitor);
                    Type t1 = this.typeArgumentToTypeVisitor.getType();
                    this.typeArgumentToTypeVisitor.init();
                    this.current.accept((TypeArgumentVisitor)this.typeArgumentToTypeVisitor);
                    Type t2 = this.typeArgumentToTypeVisitor.getType();
                    if (!t1.createType(0).equals(t2.createType(0)) && t1.isObjectType() && t2.isObjectType() && !this.typeMaker.isAssignable(this.bindings, this.typeBounds, ot1 = (ObjectType)t1, ot2 = (ObjectType)t2.createType(Math.max(0, t2.getDimension() - type.getDimension())))) {
                        if (this.typeMaker.isAssignable(this.bindings, this.typeBounds, ot2, ot1)) {
                            TypeArgument newBoundType = this.checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(type);
                            if (!ObjectType.TYPE_CLASS_WILDCARD.equals((Object)newBoundType)) {
                                this.bindings.put(typeName, newBoundType);
                            }
                        } else {
                            this.bindings.put(typeName, (TypeArgument)WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                        }
                    }
                }
            }
        }
    }

    private static boolean equals(BaseType bt1, BaseType bt2) {
        return bt2 == null || bt2.equals(bt1);
    }

    protected TypeArgument checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(GenericType type) {
        if (this.current != null) {
            if (this.current.isObjectTypeArgument()) {
                ObjectType ot = (ObjectType)this.current;
                if (ot.getTypeArguments() == null && ot.getInternalName().equals(ObjectType.TYPE_CLASS.getInternalName())) {
                    return ObjectType.TYPE_CLASS_WILDCARD.createType(Math.max(0, ot.getDimension() - type.getDimension()));
                }
                return ot.createType(Math.max(0, ot.getDimension() - type.getDimension()));
            }
            if (this.current.isInnerObjectTypeArgument() || this.current.isGenericTypeArgument() || this.current.isPrimitiveTypeArgument()) {
                Type t = (Type)this.current;
                return t.createType(Math.max(0, t.getDimension() - type.getDimension()));
            }
            return this.current.getTypeArgumentFirst();
        }
        return null;
    }

    public void visit(WildcardExtendsTypeArgument type) {
        if (this.current != null) {
            if (this.current.isWildcardExtendsTypeArgument()) {
                this.current = this.current.type();
            }
            type.type().accept((TypeArgumentVisitor)this);
        }
    }

    public void visit(WildcardSuperTypeArgument type) {
        if (this.current != null) {
            if (this.current.isWildcardSuperTypeArgument()) {
                this.current = this.current.type();
            }
            type.type().accept((TypeArgumentVisitor)this);
        }
    }

    public void visit(ObjectType type) {
        if (this.current != null && type.getTypeArguments() != null && (this.current.isObjectTypeArgument() || this.current.isInnerObjectTypeArgument())) {
            this.current = ((ObjectType)this.current).getTypeArguments();
            type.getTypeArguments().accept((TypeArgumentVisitor)this);
        }
    }

    public void visit(InnerObjectType type) {
        if (this.current != null && type.getTypeArguments() != null && this.current.isInnerObjectTypeArgument()) {
            this.current = ((InnerObjectType)this.current).getTypeArguments();
            type.getTypeArguments().accept((TypeArgumentVisitor)this);
        }
    }

    public void visit(DiamondTypeArgument argument) {
    }

    public void visit(WildcardTypeArgument type) {
    }

    public void visit(PrimitiveType type) {
    }
}

