/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableReferenceVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitStaticFieldVisitor
extends AbstractJavaSyntaxVisitor {
    private final SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    private final SearchLocalVariableReferenceVisitor searchLocalVariableReferenceVisitor = new SearchLocalVariableReferenceVisitor();
    private String internalTypeName;
    private final Map<String, FieldDeclarator> fields = new HashMap<String, FieldDeclarator>();
    private List<ClassFileConstructorOrMethodDeclaration> methods;
    private Boolean deleteStaticDeclaration;

    void setInternalTypeName(String internalTypeName) {
        this.internalTypeName = internalTypeName;
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.fields.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getFieldDeclarations());
        if (!this.fields.isEmpty()) {
            this.methods = bodyDeclaration.getMethodDeclarations();
            if (this.methods != null) {
                this.deleteStaticDeclaration = null;
                int len = this.methods.size();
                for (int i = 0; i < len; ++i) {
                    this.methods.get(i).accept(this);
                    if (this.deleteStaticDeclaration == null) continue;
                    if (!this.deleteStaticDeclaration.booleanValue()) break;
                    this.methods.remove(i);
                    break;
                }
            }
        }
        this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
    }

    @Override
    public void visit(FieldDeclarator declaration) {
        this.fields.put(declaration.getName(), declaration);
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        ClassFileStaticInitializerDeclaration sid = (ClassFileStaticInitializerDeclaration)declaration;
        BaseStatement statements = sid.getStatements();
        if (statements != null) {
            if (statements.isList()) {
                DefaultList list = statements.getList();
                if (!list.isEmpty() && this.isAssertionsDisabledStatement((Statement)list.getFirst())) {
                    list.removeFirst();
                }
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    if (!this.setStaticFieldInitializer((Statement)list.get(i))) continue;
                    if (i > 0) {
                        BaseStatement newStatements;
                        List subList = null;
                        if (i == 1) {
                            newStatements = (BaseStatement)list.getFirst();
                        } else {
                            subList = list.subList(0, i);
                            newStatements = new Statements(subList);
                        }
                        int firstLineNumber = this.getFirstLineNumber(newStatements);
                        if (firstLineNumber != -1) {
                            i = 0;
                            len -= newStatements.size();
                            if (newStatements.size() == 1) {
                                list.removeFirst();
                            } else if (subList != null) {
                                subList.clear();
                            }
                            this.addStaticInitializerDeclaration(sid, firstLineNumber, newStatements);
                        }
                    }
                    list.remove(i--);
                    --len;
                }
            } else {
                if (this.isAssertionsDisabledStatement((Statement)statements.getFirst())) {
                    statements = null;
                }
                if (statements != null && this.setStaticFieldInitializer((Statement)statements.getFirst())) {
                    statements = null;
                }
            }
            if (statements == null || statements.size() == 0) {
                this.deleteStaticDeclaration = Boolean.TRUE;
            } else {
                int firstLineNumber = this.getFirstLineNumber(statements);
                sid.setFirstLineNumber(firstLineNumber == -1 ? 0 : firstLineNumber);
                this.deleteStaticDeclaration = Boolean.FALSE;
            }
        }
    }

    protected boolean isAssertionsDisabledStatement(Statement statement) {
        FieldReferenceExpression fre;
        Expression expression = statement.getExpression();
        return expression.getLeftExpression().isFieldReferenceExpression() && (fre = (FieldReferenceExpression)expression.getLeftExpression()).getType() == PrimitiveType.TYPE_BOOLEAN && fre.getInternalTypeName().equals(this.internalTypeName) && "$assertionsDisabled".equals(fre.getName());
    }

    protected boolean setStaticFieldInitializer(Statement statement) {
        FieldDeclaration fdn;
        FieldDeclarator fdr;
        FieldReferenceExpression fre;
        Expression expression = statement.getExpression();
        if (expression.getLeftExpression().isFieldReferenceExpression() && (fre = (FieldReferenceExpression)expression.getLeftExpression()).getInternalTypeName().equals(this.internalTypeName) && (fdr = this.fields.get(fre.getName())) != null && fdr.getVariableInitializer() == null && ((fdn = fdr.getFieldDeclaration()).getFlags() & 8) != 0 && fdn.getType().getDescriptor().equals(fre.getDescriptor())) {
            expression = expression.getRightExpression();
            this.searchLocalVariableReferenceVisitor.init(-1, null);
            expression.accept((ExpressionVisitor)this.searchLocalVariableReferenceVisitor);
            if (!this.searchLocalVariableReferenceVisitor.containsReference()) {
                fdr.setVariableInitializer((VariableInitializer)new ExpressionVariableInitializer(expression));
                ((ClassFileFieldDeclaration)fdr.getFieldDeclaration()).setFirstLineNumber(expression.getLineNumber());
                return true;
            }
        }
        return false;
    }

    protected int getFirstLineNumber(BaseStatement baseStatement) {
        this.searchFirstLineNumberVisitor.init();
        baseStatement.accept((StatementVisitor)this.searchFirstLineNumberVisitor);
        return this.searchFirstLineNumberVisitor.getLineNumber();
    }

    protected void addStaticInitializerDeclaration(ClassFileStaticInitializerDeclaration sid, int lineNumber, BaseStatement statements) {
        this.methods.add(new ClassFileStaticInitializerDeclaration(sid.getBodyDeclaration(), sid.getClassFile(), sid.getMethod(), sid.getBindings(), sid.getTypeBounds(), lineNumber, statements));
    }
}

